/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.shared_policy_group.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.EnvironmentAuditLogEntity;
import io.gravitee.apim.core.shared_policy_group.crud_service.SharedPolicyGroupCrudService;
import io.gravitee.apim.core.shared_policy_group.domain_service.ValidateCreateSharedPolicyGroupDomainService;
import io.gravitee.apim.core.shared_policy_group.model.CreateSharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupAuditEvent;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import java.util.Map;
import lombok.Generated;

@UseCase
public class CreateSharedPolicyGroupUseCase {
    private final SharedPolicyGroupCrudService sharedPolicyGroupCrudService;
    private final ValidateCreateSharedPolicyGroupDomainService validateCreateSharedPolicyGroup;
    private final AuditDomainService auditService;

    public Output execute(Input input) {
        SharedPolicyGroup sharedPolicyGroupToCreate = SharedPolicyGroup.from(input.sharedPolicyGroupToCreate()).toBuilder().id(UuidString.generateRandom()).environmentId(input.auditInfo().environmentId()).organizationId(input.auditInfo().organizationId()).lifecycleState(SharedPolicyGroup.SharedPolicyGroupLifecycleState.UNDEPLOYED).version(0).createdAt(TimeProvider.now()).updatedAt(TimeProvider.now()).build();
        this.validateCreateSharedPolicyGroup.validate(sharedPolicyGroupToCreate, input.auditInfo().environmentId());
        SharedPolicyGroup cratedSharedPolicyGroup = this.sharedPolicyGroupCrudService.create(sharedPolicyGroupToCreate);
        this.createAuditLog(cratedSharedPolicyGroup, input.auditInfo());
        return new Output(cratedSharedPolicyGroup);
    }

    private void createAuditLog(SharedPolicyGroup sharedPolicyGroup, AuditInfo auditInfo) {
        this.auditService.createEnvironmentAuditLog(EnvironmentAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).event(SharedPolicyGroupAuditEvent.SHARED_POLICY_GROUP_CREATED).actor(auditInfo.actor()).newValue(sharedPolicyGroup).createdAt(sharedPolicyGroup.getCreatedAt()).properties(Map.of(AuditProperties.SHARED_POLICY_GROUP, sharedPolicyGroup.getId())).build());
    }

    @Generated
    public CreateSharedPolicyGroupUseCase(SharedPolicyGroupCrudService sharedPolicyGroupCrudService, ValidateCreateSharedPolicyGroupDomainService validateCreateSharedPolicyGroup, AuditDomainService auditService) {
        this.sharedPolicyGroupCrudService = sharedPolicyGroupCrudService;
        this.validateCreateSharedPolicyGroup = validateCreateSharedPolicyGroup;
        this.auditService = auditService;
    }

    public record Input(CreateSharedPolicyGroup sharedPolicyGroupToCreate, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private CreateSharedPolicyGroup sharedPolicyGroupToCreate;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder sharedPolicyGroupToCreate(CreateSharedPolicyGroup sharedPolicyGroupToCreate) {
                this.sharedPolicyGroupToCreate = sharedPolicyGroupToCreate;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.sharedPolicyGroupToCreate, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "CreateSharedPolicyGroupUseCase.Input.InputBuilder(sharedPolicyGroupToCreate=" + String.valueOf(this.sharedPolicyGroupToCreate) + ", auditInfo=" + String.valueOf(this.auditInfo) + ")";
            }
        }
    }

    public record Output(SharedPolicyGroup sharedPolicyGroup) {
    }
}

