/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

@DomainService
public class GroupValidationService {
    private final GroupQueryService groupQueryService;

    public Set<String> validateAndSanitize(Set<String> groupIds, String environmentId, PrimaryOwnerEntity primaryOwner, boolean addDefaultGroups) {
        HashSet<Group> found;
        HashSet<Group> hashSet = found = !CollectionUtils.isEmpty(groupIds) ? new HashSet<Group>(this.groupQueryService.findByIds(groupIds)) : new HashSet();
        if (found.size() != CollectionUtils.size(groupIds)) {
            Set foundIds = found.stream().map(Group::getId).collect(Collectors.toSet());
            Set groupsNotFound = groupIds.stream().filter(groupId -> !foundIds.contains(groupId)).collect(Collectors.toSet());
            throw new InvalidDataException("These groupIds [" + String.valueOf(groupsNotFound) + "] do not exist");
        }
        if (addDefaultGroups) {
            found.addAll(this.groupQueryService.findByEvent(environmentId, Group.GroupEvent.API_CREATE));
        }
        Set<String> sanitized = found.stream().filter(group -> group.getApiPrimaryOwner() == null).map(Group::getId).collect(Collectors.toSet());
        if (primaryOwner != null && PrimaryOwnerEntity.Type.GROUP.equals((Object)primaryOwner.type())) {
            sanitized.add(primaryOwner.id());
        }
        return sanitized;
    }

    @Generated
    public GroupValidationService(GroupQueryService groupQueryService) {
        this.groupQueryService = groupQueryService;
    }
}

