/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.analytics.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.analytics.query_service.AnalyticsQueryService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.utils.DurationUtils;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.reactivex.rxjava3.core.Single;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SearchEnvironmentResponseTimeOverTimeUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SearchEnvironmentResponseTimeOverTimeUseCase.class);
    private final AnalyticsQueryService analyticsQueryService;
    private final ApiQueryService apiQueryService;

    public Single<Output> execute(ExecutionContext executionContext, Input input) {
        Instant to = input.to();
        Instant from = input.from();
        Duration interval = DurationUtils.buildIntervalFromTimePeriod(from, to);
        Map<DefinitionVersion, List<String>> apiIds = this.apisIdsForEnv(input.environmentId);
        List<String> apis = apiIds.values().stream().flatMap(Collection::stream).toList();
        return this.analyticsQueryService.searchAvgResponseTimeOverTime(executionContext, apis, from, to, interval, apiIds.keySet()).map(statsData -> new Output(from, to, interval, statsData.values().stream().map(Math::round).toList())).defaultIfEmpty((Object)new Output(from, to, interval, List.of()));
    }

    private Map<DefinitionVersion, List<String>> apisIdsForEnv(String envId) {
        return this.apiQueryService.search(ApiSearchCriteria.builder().environmentId(envId).definitionVersion(EnumSet.of(DefinitionVersion.V4, DefinitionVersion.V2)).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).collect(Collectors.groupingBy(this::getDefinitionVersion, Collectors.mapping(Api::getId, Collectors.toList())));
    }

    private DefinitionVersion getDefinitionVersion(Api api) {
        return api.getDefinitionVersion() != null ? api.getDefinitionVersion() : DefinitionVersion.V2;
    }

    @Generated
    public SearchEnvironmentResponseTimeOverTimeUseCase(AnalyticsQueryService analyticsQueryService, ApiQueryService apiQueryService) {
        this.analyticsQueryService = analyticsQueryService;
        this.apiQueryService = apiQueryService;
    }

    public record Input(String environmentId, Instant from, Instant to) {
    }

    public record Output(Instant from, Instant to, Duration interval, List<Long> data) {
    }
}

