/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.GenericNotificationConfigRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.GenericNotificationConfig;
import io.gravitee.repository.management.model.NotificationReferenceType;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class GenericNotificationConfigUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericNotificationConfigUpgrader.class);
    EnvironmentRepository environmentRepository;
    GenericNotificationConfigRepository genericNotificationConfigRepository;

    public GenericNotificationConfigUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy GenericNotificationConfigRepository genericNotificationConfigRepository) {
        this.environmentRepository = environmentRepository;
        this.genericNotificationConfigRepository = genericNotificationConfigRepository;
    }

    public boolean upgrade() {
        try {
            Set environments = this.environmentRepository.findAll();
            List genericNotificationConfigs = this.genericNotificationConfigRepository.findAll().stream().filter(genericNotificationConfig -> genericNotificationConfig.getReferenceType().equals((Object)NotificationReferenceType.PORTAL) && genericNotificationConfig.getReferenceId().equals("DEFAULT")).flatMap(genericNotificationConfig -> this.migrateGenericNotificationConfigToEnvironments(environments, (GenericNotificationConfig)genericNotificationConfig)).toList();
            log.info("Migrating genericNotificationConfig: {} for environments {}", (Object)genericNotificationConfigs.size(), (Object)environments);
        }
        catch (Exception e) {
            log.error("Error applying upgrader", (Throwable)e);
            return false;
        }
        return true;
    }

    private Stream<GenericNotificationConfig> migrateGenericNotificationConfigToEnvironments(Set<Environment> environments, GenericNotificationConfig genericNotificationConfig) {
        Stream<GenericNotificationConfig> stream = environments.stream().map(environment -> {
            GenericNotificationConfig genericNotificationConfigToCreate = this.duplicate((Environment)environment, genericNotificationConfig);
            try {
                return this.genericNotificationConfigRepository.create(genericNotificationConfigToCreate);
            }
            catch (TechnicalException e) {
                log.error("Failed to duplicate portalNotificationConfig {} to {}", new Object[]{genericNotificationConfig, environment, e});
                throw new TechnicalManagementException(e);
            }
        });
        try {
            this.genericNotificationConfigRepository.delete(genericNotificationConfig.getId());
        }
        catch (TechnicalException e) {
            log.error("Failed to delete genericNotificationConfig {}", (Object)genericNotificationConfig, (Object)e);
            throw new TechnicalManagementException(e);
        }
        return stream;
    }

    private GenericNotificationConfig duplicate(Environment environment, GenericNotificationConfig genericNotificationConfig) {
        return GenericNotificationConfig.builder().id(UuidString.generateRandom()).config(genericNotificationConfig.getConfig()).notifier(genericNotificationConfig.getNotifier()).useSystemProxy(genericNotificationConfig.isUseSystemProxy()).referenceId(environment.getId()).referenceType(NotificationReferenceType.ENVIRONMENT).hooks(genericNotificationConfig.getHooks()).createdAt(genericNotificationConfig.getCreatedAt()).updatedAt(genericNotificationConfig.getUpdatedAt()).build();
    }

    public int getOrder() {
        return 220;
    }
}

