/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.bridge.operation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommand;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeCommandPayload;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReply;
import io.gravitee.cockpit.api.command.v1.bridge.BridgeReplyPayload;
import io.gravitee.rest.api.model.promotion.PromotionEntity;
import io.gravitee.rest.api.service.InstallationService;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperation;
import io.gravitee.rest.api.service.cockpit.command.bridge.operation.BridgeOperationHandler;
import io.gravitee.rest.api.service.promotion.PromotionService;
import io.reactivex.rxjava3.core.Single;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ProcessPromotionOperationHandler
implements BridgeOperationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessPromotionOperationHandler.class);
    private final PromotionService promotionService;
    private final InstallationService installationService;
    private final ObjectMapper objectMapper;

    @Override
    public boolean canHandle(String bridgeOperation) {
        return Objects.equals(BridgeOperation.PROCESS_API_PROMOTION.name(), bridgeOperation);
    }

    @Override
    public Single<BridgeReply> handle(BridgeCommand bridgeCommand) {
        PromotionEntity promotionEntity;
        try {
            promotionEntity = (PromotionEntity)this.objectMapper.readValue(((BridgeCommandPayload)bridgeCommand.getPayload()).content(), PromotionEntity.class);
        }
        catch (JsonProcessingException e) {
            String errorDetails = "Problem while deserializing promotion for environment [%s]".formatted(((BridgeCommandPayload)bridgeCommand.getPayload()).environmentId());
            log.warn(errorDetails, (Throwable)e);
            return Single.just((Object)new BridgeReply(bridgeCommand.getId(), errorDetails));
        }
        try {
            PromotionEntity promotion = this.promotionService.createOrUpdate(promotionEntity);
            BridgeCommandPayload commandPayload = (BridgeCommandPayload)bridgeCommand.getPayload();
            return Single.just((Object)new BridgeReply(bridgeCommand.getId(), new BridgeReplyPayload(true, List.of(BridgeReplyPayload.BridgeReplyContent.builder().environmentId(commandPayload.target().environmentId()).organizationId(commandPayload.organizationId()).installationId(this.installationService.get().getId()).content(this.objectMapper.writeValueAsString((Object)promotion)).build()))));
        }
        catch (JsonProcessingException e) {
            String errorDetails = "Problem while serializing promotion for environment [%s]".formatted(((BridgeCommandPayload)bridgeCommand.getPayload()).environmentId());
            log.warn(errorDetails);
            return Single.just((Object)new BridgeReply(bridgeCommand.getId(), errorDetails));
        }
    }

    @Generated
    public ProcessPromotionOperationHandler(PromotionService promotionService, InstallationService installationService, ObjectMapper objectMapper) {
        this.promotionService = promotionService;
        this.installationService = installationService;
        this.objectMapper = objectMapper;
    }
}

