/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.exception;

import io.gravitee.apim.core.exception.ValidationDomainException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ApiCreatedWithErrorException
extends ValidationDomainException {
    public ApiCreatedWithErrorException(String apiId, List<String> errors) {
        super("API created with error:\n" + String.join((CharSequence)"\n", errors), Map.of("apiId", apiId));
    }

    public static class ApiCreatedWithErrorExceptionBuilder {
        private String apiId;
        private final List<String> errors = new ArrayList<String>();

        public ApiCreatedWithErrorExceptionBuilder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public ApiCreatedWithErrorExceptionBuilder addError(String scope, Exception e) {
            this.errors.add("- (" + scope + ") " + e.getMessage());
            return this;
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public ApiCreatedWithErrorException build() {
            return new ApiCreatedWithErrorException(this.apiId, this.errors);
        }
    }
}

