/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.common.data.domain.Page;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.IntegrationRepository;
import io.gravitee.repository.management.api.search.ApiCriteria;
import io.gravitee.repository.management.api.search.ApiFieldFilter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.api.ApiQuery;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.common.Sortable;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;
import io.gravitee.rest.api.model.v4.api.ApiEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.CategoryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.PaginationInvalidException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.impl.search.SearchResult;
import io.gravitee.rest.api.service.search.SearchEngineService;
import io.gravitee.rest.api.service.search.query.Query;
import io.gravitee.rest.api.service.search.query.QueryBuilder;
import io.gravitee.rest.api.service.v4.ApiAuthorizationService;
import io.gravitee.rest.api.service.v4.ApiSearchService;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.service.v4.mapper.GenericApiMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component(value="ApiSearchServiceImplV4")
public class ApiSearchServiceImpl
extends AbstractService
implements ApiSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSearchServiceImpl.class);
    private final ApiRepository apiRepository;
    private final ApiMapper apiMapper;
    private final GenericApiMapper genericApiMapper;
    private final PrimaryOwnerService primaryOwnerService;
    private final CategoryService categoryService;
    private final SearchEngineService searchEngineService;
    private final ApiAuthorizationService apiAuthorizationService;
    private final IntegrationRepository integrationRepository;

    public ApiSearchServiceImpl(@Lazy ApiRepository apiRepository, ApiMapper apiMapper, GenericApiMapper genericApiMapper, @Lazy PrimaryOwnerService primaryOwnerService, @Lazy CategoryService categoryService, SearchEngineService searchEngineService, @Lazy ApiAuthorizationService apiAuthorizationService, @Lazy IntegrationRepository integrationRepository) {
        this.apiRepository = apiRepository;
        this.apiMapper = apiMapper;
        this.genericApiMapper = genericApiMapper;
        this.primaryOwnerService = primaryOwnerService;
        this.categoryService = categoryService;
        this.searchEngineService = searchEngineService;
        this.apiAuthorizationService = apiAuthorizationService;
        this.integrationRepository = integrationRepository;
    }

    @Override
    public ApiEntity findById(ExecutionContext executionContext, String apiId) {
        Api api = this.findV4RepositoryApiById(executionContext, apiId);
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), api.getId());
        return this.apiMapper.toEntity(executionContext, api, primaryOwner, true);
    }

    @Override
    public GenericApiEntity findGenericById(ExecutionContext executionContext, String apiId) {
        Api api = this.findRepositoryApiById(executionContext, apiId);
        PrimaryOwnerEntity primaryOwner = this.primaryOwnerService.getPrimaryOwner(executionContext.getOrganizationId(), api.getId());
        GenericApiEntity genericApi = this.genericApiMapper.toGenericApi(executionContext, api, primaryOwner);
        return this.enrichFederatedApi(genericApi);
    }

    @Override
    public Optional<String> findIdByEnvironmentIdAndCrossId(String environment, String crossId) {
        try {
            return this.apiRepository.findIdByEnvironmentIdAndCrossId(environment, crossId);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurred while finding API by environment " + environment + " and crossId " + crossId, e);
        }
    }

    @Override
    public boolean exists(String apiId) {
        try {
            return this.apiRepository.existById(apiId);
        }
        catch (TechnicalException te) {
            String msg = "An error occurs while checking if the API exists: " + apiId;
            log.error(msg, (Throwable)te);
            throw new TechnicalManagementException(msg, te);
        }
    }

    @Override
    public Set<GenericApiEntity> findGenericByEnvironmentAndIdIn(ExecutionContext executionContext, Set<String> apiIds) {
        if (apiIds.isEmpty()) {
            return Set.of();
        }
        ApiCriteria criteria = new ApiCriteria.Builder().ids(apiIds).environmentId(executionContext.getEnvironmentId()).build();
        List apisFound = this.apiRepository.search(criteria, ApiFieldFilter.allFields());
        return this.toGenericApis(executionContext, apisFound);
    }

    @Override
    public Set<GenericApiEntity> findAllGenericByEnvironment(ExecutionContext executionContext) {
        ApiCriteria criteria = new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId()).build();
        List apisFound = this.apiRepository.search(criteria, ApiFieldFilter.allFields());
        return this.toGenericApis(executionContext, apisFound);
    }

    @Override
    public Api findRepositoryApiById(ExecutionContext executionContext, String apiId) {
        try {
            log.debug("Find API by ID: {}", (Object)apiId);
            Optional<Api> optApi = this.apiRepository.findById((Object)apiId);
            if (executionContext.hasEnvironmentId()) {
                optApi = optApi.filter(result -> result.getEnvironmentId().equals(executionContext.getEnvironmentId()));
            }
            return (Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId));
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    @Override
    public Api findV4RepositoryApiById(ExecutionContext executionContext, String apiId) {
        Api api = this.findRepositoryApiById(executionContext, apiId);
        if (api.getDefinitionVersion() != DefinitionVersion.V4) {
            throw new IllegalArgumentException(String.format("Api found doesn't support v%s definition model.", DefinitionVersion.V4.getLabel()));
        }
        return api;
    }

    public Set<GenericApiEntity> search(ExecutionContext executionContext, ApiQuery query) {
        return this.search(executionContext, query, false);
    }

    public Set<GenericApiEntity> search(ExecutionContext executionContext, ApiQuery query, boolean excludeDefinitionV4) {
        log.debug("Search APIs by {}", (Object)query);
        Optional<Collection<String>> optionalTargetIds = this.searchInDefinition(executionContext, query, excludeDefinitionV4);
        if (optionalTargetIds.isPresent()) {
            Collection<String> targetIds = optionalTargetIds.get();
            if (targetIds.isEmpty()) {
                return Collections.emptySet();
            }
            query.setIds(targetIds);
        }
        ApiCriteria.Builder queryToCriteria = this.queryToCriteria(executionContext, query);
        if (excludeDefinitionV4) {
            ArrayList<DefinitionVersion> allowedDefinitionVersion = new ArrayList<DefinitionVersion>();
            allowedDefinitionVersion.add(null);
            allowedDefinitionVersion.add(DefinitionVersion.V1);
            allowedDefinitionVersion.add(DefinitionVersion.V2);
            queryToCriteria.definitionVersion(allowedDefinitionVersion);
        }
        List<Api> apis = this.apiRepository.search(queryToCriteria.build(), null, ApiFieldFilter.allFields()).collect(Collectors.toList());
        return this.toGenericApis(executionContext, apis);
    }

    @Override
    public Page<GenericApiEntity> search(ExecutionContext executionContext, String userId, boolean isAdmin, QueryBuilder<ApiEntity> apiQueryBuilder, Pageable pageable, boolean mapToFullGenericApiEntity, boolean manageOnly) {
        List apis;
        List list;
        Query<ApiEntity> apiQuery = apiQueryBuilder.build();
        SearchResult apiIdsResult = this.searchEngineService.search(GraviteeContext.getExecutionContext(), apiQuery);
        if (!apiIdsResult.hasResults() && apiIdsResult.getDocuments().isEmpty()) {
            return new Page(List.of(), 0, 0, 0L);
        }
        LinkedList<String> apiIds = new LinkedList<String>(apiIdsResult.getDocuments());
        if (!isAdmin) {
            Set<String> userApiIds = this.apiAuthorizationService.findApiIdsByUserId(GraviteeContext.getExecutionContext(), userId, null, manageOnly);
            if (userApiIds.isEmpty()) {
                return new Page(List.of(), 0, 0, 0L);
            }
            apiIds.retainAll(userApiIds);
            if (apiIds.isEmpty()) {
                return new Page(List.of(), 0, 0, 0L);
            }
        }
        List<String> apiIdPageSubset = this.getApiIdPageSubset(apiIds, pageable);
        ApiCriteria.Builder apiCriteriaBuilder = new ApiCriteria.Builder().environmentId(GraviteeContext.getExecutionContext().getEnvironmentId()).ids(apiIdPageSubset);
        if (Objects.nonNull(apiQuery.getFilters()) && (list = apiQuery.getFilters().getOrDefault("definition_version", List.of())) instanceof List) {
            List versions = list;
            apiCriteriaBuilder.definitionVersion(CollectionUtils.stream(versions).map(Object::toString).map(DefinitionVersion::valueOfLabel).toList());
        }
        if ((apis = this.apiRepository.search(apiCriteriaBuilder.build(), ApiFieldFilter.allFields())).isEmpty()) {
            return new Page(List.of(), 0, 0, 0L);
        }
        Map<String, PrimaryOwnerEntity> primaryOwners = this.primaryOwnerService.getPrimaryOwners(executionContext, apis.stream().map(Api::getId).toList());
        Comparator<String> orderingComparator = Comparator.comparingInt(apiIdPageSubset::indexOf);
        Stream<GenericApiEntity> apisStream = mapToFullGenericApiEntity ? apis.stream().map(api -> this.enrichFederatedApi(this.genericApiMapper.toGenericApi(executionContext, (Api)api, (PrimaryOwnerEntity)primaryOwners.get(api.getId())))) : apis.stream().map(api -> this.enrichFederatedApi(this.genericApiMapper.toGenericApi((Api)api, (PrimaryOwnerEntity)primaryOwners.get(api.getId()))));
        return apisStream.sorted((o1, o2) -> orderingComparator.compare(o1.getId(), o2.getId())).collect(Collectors.collectingAndThen(Collectors.toList(), apiEntityList -> new Page(apiEntityList, pageable.getPageNumber(), apis.size(), (long)apiIds.size())));
    }

    private List<String> getApiIdPageSubset(Collection<String> ids, Pageable pageable) {
        int numberOfItems = ids.size();
        int numberOfItemPerPage = pageable.getPageSize();
        if (numberOfItemPerPage == 0 || numberOfItems <= 0) {
            return new ArrayList<String>();
        }
        int currentPage = pageable.getPageNumber();
        int startIndex = (currentPage - 1) * numberOfItemPerPage;
        if (startIndex >= numberOfItems || currentPage < 1) {
            throw new PaginationInvalidException();
        }
        return ids.stream().skip(startIndex).limit(numberOfItemPerPage).collect(Collectors.toList());
    }

    private Optional<Collection<String>> searchInDefinition(ExecutionContext executionContext, ApiQuery apiQuery, boolean excludeV4) {
        Query<GenericApiEntity> searchEngineQuery;
        if (apiQuery == null) {
            return Optional.empty();
        }
        QueryBuilder<GenericApiEntity> searchEngineQueryBuilder = this.convert(apiQuery);
        if (excludeV4) {
            searchEngineQueryBuilder.setExcludedFilters(Map.of("definition_version", List.of(DefinitionVersion.V4.getLabel())));
        }
        if (StringUtils.isBlank((CharSequence)(searchEngineQuery = searchEngineQueryBuilder.build()).getQuery())) {
            return Optional.empty();
        }
        SearchResult matchApis = this.searchEngineService.search(executionContext, searchEngineQuery);
        return Optional.of(matchApis.getDocuments());
    }

    private QueryBuilder<GenericApiEntity> convert(ApiQuery query) {
        QueryBuilder<GenericApiEntity> searchEngineQuery = QueryBuilder.create(GenericApiEntity.class);
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("api", query.getIds());
            searchEngineQuery.setFilters(filters);
        }
        if (!StringUtils.isBlank((CharSequence)query.getContextPath())) {
            searchEngineQuery.addExplicitFilter("paths", query.getContextPath());
        }
        if (!StringUtils.isBlank((CharSequence)query.getTag())) {
            searchEngineQuery.addExplicitFilter("tag", query.getTag());
        }
        return searchEngineQuery;
    }

    private ApiCriteria.Builder queryToCriteria(ExecutionContext executionContext, ApiQuery query) {
        ApiCriteria.Builder builder = new ApiCriteria.Builder().environmentId(executionContext.getEnvironmentId());
        if (query == null) {
            return builder;
        }
        builder.label(query.getLabel()).name(query.getName()).version(query.getVersion());
        if (!StringUtils.isBlank((CharSequence)query.getCategory())) {
            builder.category(this.categoryService.findById(query.getCategory(), executionContext.getEnvironmentId()).getId());
        }
        if (query.getGroups() != null && !query.getGroups().isEmpty()) {
            builder.groups((Collection)query.getGroups());
        }
        if (!StringUtils.isBlank((CharSequence)query.getState())) {
            builder.state(LifecycleState.valueOf((String)query.getState()));
        }
        if (query.getVisibility() != null) {
            builder.visibility(Visibility.valueOf((String)query.getVisibility().name()));
        }
        if (query.getLifecycleStates() != null) {
            builder.lifecycleStates(query.getLifecycleStates().stream().map(apiLifecycleState -> ApiLifecycleState.valueOf((String)apiLifecycleState.name())).collect(Collectors.toList()));
        }
        if (query.getIds() != null && !query.getIds().isEmpty()) {
            builder.ids(query.getIds());
        }
        if (query.getCrossId() != null && !query.getCrossId().isEmpty()) {
            builder.crossId(query.getCrossId());
        }
        return builder;
    }

    @Override
    public Collection<String> searchIds(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable) {
        return this.searchIds(executionContext, query, filters, sortable, EnumSet.noneOf(DefinitionVersion.class));
    }

    @Override
    public Collection<String> searchIds(ExecutionContext executionContext, String query, Map<String, Object> filters, Sortable sortable, Collection<DefinitionVersion> excludeDefinitionVersions) {
        QueryBuilder<GenericApiEntity> searchEngineQueryBuilder = QueryBuilder.create(GenericApiEntity.class).setSort(sortable).setFilters(filters);
        if (CollectionUtils.isNotEmpty(excludeDefinitionVersions)) {
            searchEngineQueryBuilder.setExcludedFilters(Map.of("definition_version", CollectionUtils.stream(excludeDefinitionVersions).map(DefinitionVersion::getLabel).toList()));
        }
        if (!StringUtils.isBlank((CharSequence)query)) {
            searchEngineQueryBuilder.setQuery(query);
        }
        SearchResult searchResult = this.searchEngineService.search(executionContext, searchEngineQueryBuilder.build());
        return searchResult.getDocuments();
    }

    private Set<GenericApiEntity> toGenericApis(ExecutionContext executionContext, List<Api> apis) {
        if (apis == null || apis.isEmpty()) {
            return Set.of();
        }
        List<String> apiIds = apis.stream().map(Api::getId).collect(Collectors.toList());
        Map<String, PrimaryOwnerEntity> primaryOwners = this.primaryOwnerService.getPrimaryOwners(executionContext, apiIds);
        Set apiWithoutPo = apiIds.stream().filter(apiId -> !primaryOwners.containsKey(apiId)).collect(Collectors.toSet());
        Stream<Object> streamApis = apis.stream();
        if (!apiWithoutPo.isEmpty()) {
            String apisAsString = String.join((CharSequence)" / ", apiWithoutPo);
            log.error("{} apis has no identified primary owners in this list {}.", (Object)apiWithoutPo.size(), (Object)apisAsString);
            streamApis = streamApis.filter(api -> !apiIds.contains(api.getId()));
        }
        return streamApis.map(publicApi -> this.genericApiMapper.toGenericApi(executionContext, (Api)publicApi, (PrimaryOwnerEntity)primaryOwners.get(publicApi.getId()))).collect(Collectors.toSet());
    }

    private GenericApiEntity enrichFederatedApi(GenericApiEntity genericApi) {
        try {
            FederatedApiEntity fede;
            if (genericApi instanceof FederatedApiEntity && (fede = (FederatedApiEntity)genericApi).getOriginContext() != null && fede.getOriginContext().integrationName() == null) {
                this.integrationRepository.findById((Object)fede.getOriginContext().integrationId()).map(integration -> new OriginContext.Integration(fede.getOriginContext().integrationId(), integration.getProvider(), integration.getName())).ifPresent(arg_0 -> ((FederatedApiEntity)fede).setOriginContext(arg_0));
            }
        }
        catch (TechnicalException e) {
            log.error("Impossible to find integrations", (Throwable)e);
        }
        return genericApi;
    }
}

