/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.NewApiMetadata;
import io.gravitee.apim.core.api.model.import_definition.ApiDescriptor;
import io.gravitee.apim.core.api.model.import_definition.PageExport;
import io.gravitee.apim.core.api.model.import_definition.PlanDescriptor;
import io.gravitee.apim.core.documentation.model.AccessControl;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.documentation.model.PageMedia;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.metadata.model.Metadata;
import io.gravitee.apim.infra.adapter.GraviteeDefinitionAdapter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.Plan;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.definition.model.federation.FederatedPlan;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.definition.model.v4.analytics.Analytics;
import io.gravitee.definition.model.v4.endpointgroup.EndpointGroup;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.flow.execution.FlowExecution;
import io.gravitee.definition.model.v4.listener.Listener;
import io.gravitee.definition.model.v4.nativeapi.NativeApi;
import io.gravitee.definition.model.v4.nativeapi.NativeEndpointGroup;
import io.gravitee.definition.model.v4.nativeapi.NativeFlow;
import io.gravitee.definition.model.v4.nativeapi.NativeListener;
import io.gravitee.definition.model.v4.nativeapi.NativePlan;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.definition.model.v4.property.Property;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.context.OriginContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class GraviteeDefinitionAdapterImpl
implements GraviteeDefinitionAdapter {
    @Override
    public List<PageExport> mapPage(Collection<Page> source) {
        if (source == null) {
            return null;
        }
        ArrayList<PageExport> list = new ArrayList<PageExport>(source.size());
        for (Page page : source) {
            list.add(this.pageToPageExport(page));
        }
        return list;
    }

    @Override
    public PlanDescriptor.V4 mapPlanV4(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list1;
        if (source == null) {
            return null;
        }
        PlanDescriptor.V4.V4Builder v4 = PlanDescriptor.V4.builder();
        v4.mode(this.sourcePlanDefinitionHttpV4Mode(source));
        v4.status(this.sourcePlanDefinitionHttpV4Status(source));
        v4.id(source.getId());
        v4.crossId(source.getCrossId());
        v4.name(source.getName());
        v4.definitionVersion(source.getDefinitionVersion());
        v4.description(source.getDescription());
        v4.createdAt(this.map(source.getCreatedAt()));
        v4.updatedAt(this.map(source.getUpdatedAt()));
        v4.publishedAt(this.map(source.getPublishedAt()));
        v4.closedAt(this.map(source.getClosedAt()));
        v4.validation(source.getValidation());
        v4.type(source.getType());
        Set<String> set = source.getTags();
        if (set != null) {
            v4.tags(new LinkedHashSet<String>(set));
        }
        v4.selectionRule(source.getSelectionRule());
        v4.apiId(source.getApiId());
        v4.environmentId(source.getEnvironmentId());
        v4.order(source.getOrder());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            v4.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            v4.excludedGroups(new ArrayList<String>(list1));
        }
        v4.commentRequired(source.isCommentRequired());
        v4.commentMessage(source.getCommentMessage());
        v4.generalConditions(source.getGeneralConditions());
        v4.security(this.mapPlanSecurity(source.getPlanDefinitionHttpV4().getSecurity()));
        return v4.build();
    }

    @Override
    public PlanDescriptor.Native mapPlanNative(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list1;
        if (source == null) {
            return null;
        }
        PlanDescriptor.Native.NativeBuilder native1 = PlanDescriptor.Native.builder();
        native1.mode(this.sourcePlanDefinitionNativeV4Mode(source));
        native1.status(this.sourcePlanDefinitionNativeV4Status(source));
        native1.id(source.getId());
        native1.crossId(source.getCrossId());
        native1.name(source.getName());
        native1.definitionVersion(source.getDefinitionVersion());
        native1.description(source.getDescription());
        native1.createdAt(this.map(source.getCreatedAt()));
        native1.updatedAt(this.map(source.getUpdatedAt()));
        native1.publishedAt(this.map(source.getPublishedAt()));
        native1.closedAt(this.map(source.getClosedAt()));
        native1.validation(source.getValidation());
        native1.type(source.getType());
        Set<String> set = source.getTags();
        if (set != null) {
            native1.tags(new LinkedHashSet<String>(set));
        }
        native1.selectionRule(source.getSelectionRule());
        native1.apiId(source.getApiId());
        native1.environmentId(source.getEnvironmentId());
        native1.order(source.getOrder());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            native1.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            native1.excludedGroups(new ArrayList<String>(list1));
        }
        native1.commentRequired(source.isCommentRequired());
        native1.commentMessage(source.getCommentMessage());
        native1.generalConditions(source.getGeneralConditions());
        native1.security(this.mapPlanSecurity(source.getPlanDefinitionNativeV4().getSecurity()));
        return native1.build();
    }

    @Override
    public PlanDescriptor.Federated mapPlanFederated(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list1;
        if (source == null) {
            return null;
        }
        PlanDescriptor.Federated.FederatedBuilder federated = PlanDescriptor.Federated.builder();
        federated.mode(this.sourceFederatedPlanDefinitionMode(source));
        federated.status(this.sourceFederatedPlanDefinitionStatus(source));
        federated.providerId(this.sourceFederatedPlanDefinitionProviderId(source));
        federated.id(source.getId());
        federated.crossId(source.getCrossId());
        federated.name(source.getName());
        federated.definitionVersion(source.getDefinitionVersion());
        federated.description(source.getDescription());
        federated.createdAt(this.map(source.getCreatedAt()));
        federated.updatedAt(this.map(source.getUpdatedAt()));
        federated.publishedAt(this.map(source.getPublishedAt()));
        federated.closedAt(this.map(source.getClosedAt()));
        federated.validation(source.getValidation());
        federated.type(source.getType());
        federated.selectionRule(source.getSelectionRule());
        federated.apiId(source.getApiId());
        federated.environmentId(source.getEnvironmentId());
        federated.order(source.getOrder());
        List<String> list = source.getCharacteristics();
        if (list != null) {
            federated.characteristics(new ArrayList<String>(list));
        }
        if ((list1 = source.getExcludedGroups()) != null) {
            federated.excludedGroups(new ArrayList<String>(list1));
        }
        federated.commentRequired(source.isCommentRequired());
        federated.commentMessage(source.getCommentMessage());
        federated.generalConditions(source.getGeneralConditions());
        federated.security(this.mapPlanSecurity(source.getFederatedPlanDefinition().getSecurity()));
        return federated.build();
    }

    @Override
    public PlanDescriptor.V2 mapPlanV2(io.gravitee.apim.core.plan.model.Plan source) {
        List<String> list2;
        List<io.gravitee.definition.model.flow.Flow> flows;
        List<io.gravitee.definition.model.flow.Flow> list;
        Map<String, List<Rule>> paths;
        if (source == null) {
            return null;
        }
        PlanDescriptor.V2.V2Builder v2 = PlanDescriptor.V2.builder();
        String status = this.sourcePlanDefinitionV2Status(source);
        if (status != null) {
            v2.status(Enum.valueOf(PlanStatus.class, status));
        }
        v2.securityDefinition(this.sourcePlanDefinitionV2SecurityDefinition(source));
        Map<String, List<Rule>> map = paths = this.sourcePlanDefinitionV2Paths(source);
        if (map != null) {
            v2.paths(new LinkedHashMap<String, List<Rule>>(map));
        }
        if ((list = (flows = this.sourcePlanDefinitionV2Flows(source))) != null) {
            v2.flows(new ArrayList<io.gravitee.definition.model.flow.Flow>(list));
        }
        v2.id(source.getId());
        v2.crossId(source.getCrossId());
        v2.name(source.getName());
        v2.definitionVersion(source.getDefinitionVersion());
        v2.description(source.getDescription());
        v2.createdAt(this.map(source.getCreatedAt()));
        v2.updatedAt(this.map(source.getUpdatedAt()));
        v2.publishedAt(this.map(source.getPublishedAt()));
        v2.closedAt(this.map(source.getClosedAt()));
        v2.validation(source.getValidation());
        v2.type(source.getType());
        Set<String> set = source.getTags();
        if (set != null) {
            v2.tags(new LinkedHashSet<String>(set));
        }
        v2.selectionRule(source.getSelectionRule());
        v2.apiId(source.getApiId());
        v2.environmentId(source.getEnvironmentId());
        v2.order(source.getOrder());
        List<String> list1 = source.getCharacteristics();
        if (list1 != null) {
            v2.characteristics(new ArrayList<String>(list1));
        }
        if ((list2 = source.getExcludedGroups()) != null) {
            v2.excludedGroups(new ArrayList<String>(list2));
        }
        v2.commentRequired(source.isCommentRequired());
        v2.commentMessage(source.getCommentMessage());
        v2.generalConditions(source.getGeneralConditions());
        v2.security(this.mapPlanSecurityV2(source.getPlanDefinitionV2().getSecurity(), source.getPlanDefinitionV2().getSecurityDefinition()));
        return v2.build();
    }

    @Override
    public PrimaryOwnerEntity map(io.gravitee.apim.core.membership.model.PrimaryOwnerEntity src) {
        if (src == null) {
            return null;
        }
        PrimaryOwnerEntity.PrimaryOwnerEntityBuilder primaryOwnerEntity = PrimaryOwnerEntity.builder();
        primaryOwnerEntity.id(src.id());
        primaryOwnerEntity.email(src.email());
        primaryOwnerEntity.displayName(src.displayName());
        if (src.type() != null) {
            primaryOwnerEntity.type(src.type().name());
        }
        return primaryOwnerEntity.build();
    }

    @Override
    public ApiDescriptor.ApiDescriptorV4 mapV4(Api apiEntity, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwner, WorkflowState workflowState, Set<String> groups, Collection<NewApiMetadata> metadata, List<Flow> flows) {
        if (apiEntity == null && primaryOwner == null && workflowState == null && groups == null && metadata == null && flows == null) {
            return null;
        }
        ApiDescriptor.ApiDescriptorV4.ApiDescriptorV4Builder apiDescriptorV4 = ApiDescriptor.ApiDescriptorV4.builder();
        if (apiEntity != null) {
            Set<String> set2;
            Set<String> set1;
            List<EndpointGroup> endpointGroups;
            List<EndpointGroup> list4;
            List<io.gravitee.definition.model.v4.resource.Resource> resources;
            List<io.gravitee.definition.model.v4.resource.Resource> list3;
            List<Property> properties;
            List<Property> list2;
            Map<String, Map<String, ResponseTemplate>> responseTemplates;
            Map<String, Map<String, ResponseTemplate>> map;
            List<Flow> flows1;
            List<Listener> listeners;
            apiDescriptorV4.id(apiEntity.getId());
            apiDescriptorV4.apiVersion(apiEntity.getVersion());
            apiDescriptorV4.type(apiEntity.getType());
            apiDescriptorV4.state(this.lifecycleStateToState(apiEntity.getLifecycleState()));
            apiDescriptorV4.lifecycleState(this.apiLifecycleStateToApiLifecycleState(apiEntity.getApiLifecycleState()));
            List<Listener> list = listeners = this.apiEntityApiDefinitionHttpV4Listeners(apiEntity);
            if (list != null) {
                apiDescriptorV4.listeners(new ArrayList<Listener>(list));
            }
            apiDescriptorV4.analytics(this.apiEntityApiDefinitionHttpV4Analytics(apiEntity));
            apiDescriptorV4.flowExecution(this.apiEntityApiDefinitionHttpV4FlowExecution(apiEntity));
            List<Flow> list1 = flows1 = this.apiEntityApiDefinitionHttpV4Flows(apiEntity);
            if (list1 != null) {
                apiDescriptorV4.flows(new ArrayList<Flow>(list1));
            }
            if ((map = (responseTemplates = this.apiEntityApiDefinitionHttpV4ResponseTemplates(apiEntity))) != null) {
                apiDescriptorV4.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map));
            }
            if ((list2 = (properties = this.apiEntityApiDefinitionHttpV4Properties(apiEntity))) != null) {
                apiDescriptorV4.properties(new ArrayList<Property>(list2));
            }
            if ((list3 = (resources = this.apiEntityApiDefinitionHttpV4Resources(apiEntity))) != null) {
                apiDescriptorV4.resources(new ArrayList<io.gravitee.definition.model.v4.resource.Resource>(list3));
            }
            if ((list4 = (endpointGroups = this.apiEntityApiDefinitionHttpV4EndpointGroups(apiEntity))) != null) {
                apiDescriptorV4.endpointGroups(new ArrayList<EndpointGroup>(list4));
            }
            apiDescriptorV4.crossId(apiEntity.getCrossId());
            apiDescriptorV4.name(apiEntity.getName());
            apiDescriptorV4.description(apiEntity.getDescription());
            apiDescriptorV4.deployedAt(this.map(apiEntity.getDeployedAt()));
            apiDescriptorV4.createdAt(this.map(apiEntity.getCreatedAt()));
            apiDescriptorV4.updatedAt(this.map(apiEntity.getUpdatedAt()));
            apiDescriptorV4.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
            Set<String> set = apiEntity.getGroups();
            if (set != null) {
                apiDescriptorV4.groups(new LinkedHashSet<String>(set));
            }
            apiDescriptorV4.visibility(this.visibilityToVisibility(apiEntity.getVisibility()));
            List<String> list5 = apiEntity.getLabels();
            if (list5 != null) {
                apiDescriptorV4.labels(new ArrayList<String>(list5));
            }
            if ((set1 = apiEntity.getTags()) != null) {
                apiDescriptorV4.tags(new LinkedHashSet<String>(set1));
            }
            if ((set2 = apiEntity.getCategories()) != null) {
                apiDescriptorV4.categories(new LinkedHashSet<String>(set2));
            }
            apiDescriptorV4.originContext(apiEntity.getOriginContext());
            apiDescriptorV4.picture(apiEntity.getPicture());
            apiDescriptorV4.background(apiEntity.getBackground());
        }
        apiDescriptorV4.primaryOwner(this.map(primaryOwner));
        apiDescriptorV4.workflowState(workflowState);
        apiDescriptorV4.metadata(this.map(metadata));
        apiDescriptorV4.failover(apiEntity.getApiDefinitionHttpV4() != null ? apiEntity.getApiDefinitionHttpV4().getFailover() : null);
        return apiDescriptorV4.build();
    }

    @Override
    public ApiDescriptor.Native mapNative(Api apiEntity, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwner, WorkflowState workflowState, Set<String> groups, Collection<NewApiMetadata> metadata, List<NativeFlow> flows) {
        if (apiEntity == null && primaryOwner == null && workflowState == null && groups == null && metadata == null && flows == null) {
            return null;
        }
        ApiDescriptor.Native.NativeBuilder native1 = ApiDescriptor.Native.builder();
        if (apiEntity != null) {
            Set<String> set2;
            Set<String> set1;
            List<NativeEndpointGroup> endpointGroups;
            List<NativeEndpointGroup> list4;
            List<io.gravitee.definition.model.v4.resource.Resource> resources;
            List<io.gravitee.definition.model.v4.resource.Resource> list3;
            List<Property> properties;
            List<Property> list2;
            List<NativeFlow> flows1;
            List<NativeFlow> list1;
            List<NativeListener> listeners;
            native1.id(apiEntity.getId());
            native1.apiVersion(apiEntity.getVersion());
            native1.state(this.lifecycleStateToState(apiEntity.getLifecycleState()));
            native1.lifecycleState(this.apiLifecycleStateToApiLifecycleState(apiEntity.getApiLifecycleState()));
            List<NativeListener> list = listeners = this.apiEntityApiDefinitionNativeV4Listeners(apiEntity);
            if (list != null) {
                native1.listeners(new ArrayList<NativeListener>(list));
            }
            if ((list1 = (flows1 = this.apiEntityApiDefinitionNativeV4Flows(apiEntity))) != null) {
                native1.flows(new ArrayList<NativeFlow>(list1));
            }
            if ((list2 = (properties = this.apiEntityApiDefinitionNativeV4Properties(apiEntity))) != null) {
                native1.properties(new ArrayList<Property>(list2));
            }
            if ((list3 = (resources = this.apiEntityApiDefinitionNativeV4Resources(apiEntity))) != null) {
                native1.resources(new ArrayList<io.gravitee.definition.model.v4.resource.Resource>(list3));
            }
            if ((list4 = (endpointGroups = this.apiEntityApiDefinitionNativeV4EndpointGroups(apiEntity))) != null) {
                native1.endpointGroups(new ArrayList<NativeEndpointGroup>(list4));
            }
            native1.crossId(apiEntity.getCrossId());
            native1.name(apiEntity.getName());
            native1.description(apiEntity.getDescription());
            native1.deployedAt(this.map(apiEntity.getDeployedAt()));
            native1.createdAt(this.map(apiEntity.getCreatedAt()));
            native1.updatedAt(this.map(apiEntity.getUpdatedAt()));
            native1.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
            Set<String> set = apiEntity.getGroups();
            if (set != null) {
                native1.groups(new LinkedHashSet<String>(set));
            }
            native1.visibility(this.visibilityToVisibility(apiEntity.getVisibility()));
            List<String> list5 = apiEntity.getLabels();
            if (list5 != null) {
                native1.labels(new ArrayList<String>(list5));
            }
            if ((set1 = apiEntity.getTags()) != null) {
                native1.tags(new LinkedHashSet<String>(set1));
            }
            if ((set2 = apiEntity.getCategories()) != null) {
                native1.categories(new LinkedHashSet<String>(set2));
            }
            native1.originContext(apiEntity.getOriginContext());
            native1.picture(apiEntity.getPicture());
            native1.background(apiEntity.getBackground());
        }
        native1.primaryOwner(this.map(primaryOwner));
        native1.workflowState(workflowState);
        native1.metadata(this.map(metadata));
        return native1.build();
    }

    @Override
    public ApiDescriptor.Federated mapFederated(Api apiEntity, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwner, WorkflowState workflowState, Set<String> groups, Collection<NewApiMetadata> metadata, Integration integration) {
        if (apiEntity == null && primaryOwner == null && workflowState == null && groups == null && metadata == null && integration == null) {
            return null;
        }
        ApiDescriptor.Federated.FederatedBuilder federated = ApiDescriptor.Federated.builder();
        if (apiEntity != null) {
            Set<String> set2;
            Set<String> set1;
            federated.id(apiEntity.getId());
            federated.name(apiEntity.getName());
            federated.description(apiEntity.getDescription());
            federated.createdAt(this.map(apiEntity.getCreatedAt()));
            federated.updatedAt(this.map(apiEntity.getUpdatedAt()));
            Set<String> set = apiEntity.getGroups();
            if (set != null) {
                federated.groups(new LinkedHashSet<String>(set));
            }
            federated.type(apiEntity.getType());
            federated.state(this.lifecycleStateToState(apiEntity.getLifecycleState()));
            federated.lifecycleState(this.apiLifecycleStateToApiLifecycleState(apiEntity.getApiLifecycleState()));
            federated.providerId(this.apiEntityFederatedApiDefinitionProviderId(apiEntity));
            federated.crossId(apiEntity.getCrossId());
            federated.deployedAt(this.map(apiEntity.getDeployedAt()));
            federated.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
            federated.visibility(this.visibilityToVisibility(apiEntity.getVisibility()));
            List<String> list = apiEntity.getLabels();
            if (list != null) {
                federated.labels(new ArrayList<String>(list));
            }
            if ((set1 = apiEntity.getTags()) != null) {
                federated.tags(new LinkedHashSet<String>(set1));
            }
            if ((set2 = apiEntity.getCategories()) != null) {
                federated.categories(new LinkedHashSet<String>(set2));
            }
            federated.picture(apiEntity.getPicture());
            federated.background(apiEntity.getBackground());
        }
        federated.primaryOwner(this.map(primaryOwner));
        federated.workflowState(workflowState);
        federated.metadata(this.map(metadata));
        federated.originContext(this.integrationToIntegration(integration));
        return federated.build();
    }

    @Override
    public ApiDescriptor.ApiDescriptorV2 mapV2(Api apiEntity, io.gravitee.apim.core.membership.model.PrimaryOwnerEntity primaryOwner, WorkflowState workflowState, Set<String> groups, Collection<NewApiMetadata> metadata, Collection<io.gravitee.definition.model.flow.Flow> flows) {
        if (apiEntity == null && primaryOwner == null && workflowState == null && groups == null && metadata == null && flows == null) {
            return null;
        }
        ApiDescriptor.ApiDescriptorV2.ApiDescriptorV2Builder apiDescriptorV2 = ApiDescriptor.ApiDescriptorV2.builder();
        if (apiEntity != null) {
            Set<String> set2;
            Map<String, Map<String, ResponseTemplate>> responseTemplates;
            Map<String, Map<String, ResponseTemplate>> map2;
            Map<String, Pattern> pathMappings;
            Map<String, Pattern> map1;
            Set<String> tags;
            List<io.gravitee.definition.model.flow.Flow> flows1;
            List<io.gravitee.definition.model.flow.Flow> list1;
            Map<String, List<Rule>> paths;
            Map<String, List<Rule>> map;
            List<Resource> resources;
            apiDescriptorV2.id(apiEntity.getId());
            apiDescriptorV2.apiVersion(apiEntity.getVersion());
            apiDescriptorV2.state(this.lifecycleStateToState(apiEntity.getLifecycleState()));
            apiDescriptorV2.lifecycleState(this.apiLifecycleStateToApiLifecycleState(apiEntity.getApiLifecycleState()));
            apiDescriptorV2.proxy(this.apiEntityApiDefinitionProxy(apiEntity));
            apiDescriptorV2.services(this.apiEntityApiDefinitionServices(apiEntity));
            List<Resource> list = resources = this.apiEntityApiDefinitionResources(apiEntity);
            if (list != null) {
                apiDescriptorV2.resources(new ArrayList<Resource>(list));
            }
            if ((map = (paths = this.apiEntityApiDefinitionPaths(apiEntity))) != null) {
                apiDescriptorV2.paths(new LinkedHashMap<String, List<Rule>>(map));
            }
            if ((list1 = (flows1 = this.apiEntityApiDefinitionFlows(apiEntity))) != null) {
                apiDescriptorV2.flows(new ArrayList<io.gravitee.definition.model.flow.Flow>(list1));
            }
            apiDescriptorV2.properties(this.apiEntityApiDefinitionProperties(apiEntity));
            Set<String> set = tags = this.apiEntityApiDefinitionTags(apiEntity);
            if (set != null) {
                apiDescriptorV2.tags(new LinkedHashSet<String>(set));
            }
            if ((map1 = (pathMappings = this.apiEntityApiDefinitionPathMappings(apiEntity))) != null) {
                apiDescriptorV2.pathMappings(new LinkedHashMap<String, Pattern>(map1));
            }
            if ((map2 = (responseTemplates = this.apiEntityApiDefinitionResponseTemplates(apiEntity))) != null) {
                apiDescriptorV2.responseTemplates(new LinkedHashMap<String, Map<String, ResponseTemplate>>(map2));
            }
            List<Plan> plans = this.apiEntityApiDefinitionPlans(apiEntity);
            apiDescriptorV2.plans(this.map(plans));
            apiDescriptorV2.executionMode(this.apiEntityApiDefinitionExecutionMode(apiEntity));
            apiDescriptorV2.crossId(apiEntity.getCrossId());
            apiDescriptorV2.name(apiEntity.getName());
            apiDescriptorV2.description(apiEntity.getDescription());
            apiDescriptorV2.deployedAt(this.map(apiEntity.getDeployedAt()));
            apiDescriptorV2.createdAt(this.map(apiEntity.getCreatedAt()));
            apiDescriptorV2.updatedAt(this.map(apiEntity.getUpdatedAt()));
            apiDescriptorV2.disableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
            Set<String> set1 = apiEntity.getGroups();
            if (set1 != null) {
                apiDescriptorV2.groups(new LinkedHashSet<String>(set1));
            }
            apiDescriptorV2.visibility(this.visibilityToVisibility(apiEntity.getVisibility()));
            List<String> list2 = apiEntity.getLabels();
            if (list2 != null) {
                apiDescriptorV2.labels(new ArrayList<String>(list2));
            }
            if ((set2 = apiEntity.getCategories()) != null) {
                apiDescriptorV2.categories(new LinkedHashSet<String>(set2));
            }
            apiDescriptorV2.originContext(apiEntity.getOriginContext());
            apiDescriptorV2.picture(apiEntity.getPicture());
            apiDescriptorV2.background(apiEntity.getBackground());
        }
        apiDescriptorV2.primaryOwner(this.map(primaryOwner));
        apiDescriptorV2.workflowState(workflowState);
        apiDescriptorV2.metadata(this.map(metadata));
        return apiDescriptorV2.build();
    }

    @Override
    public Set<NewApiMetadata> mapMetadata(Collection<Metadata> source) {
        if (source == null) {
            return null;
        }
        LinkedHashSet<NewApiMetadata> set = new LinkedHashSet<NewApiMetadata>(Math.max((int)((float)source.size() / 0.75f) + 1, 16));
        for (Metadata metadata : source) {
            set.add(this.metadataToNewApiMetadata(metadata));
        }
        return set;
    }

    protected PageExport pageToPageExport(Page page) {
        Map<String, String> map1;
        if (page == null) {
            return null;
        }
        PageExport.PageExportBuilder pageExport = PageExport.builder();
        pageExport.id(page.getId());
        pageExport.crossId(page.getCrossId());
        pageExport.referenceId(page.getReferenceId());
        pageExport.referenceType(page.getReferenceType());
        pageExport.name(page.getName());
        pageExport.type(page.getType());
        pageExport.lastContributor(page.getLastContributor());
        pageExport.order(page.getOrder());
        pageExport.published(page.isPublished());
        pageExport.visibility(page.getVisibility());
        if (page.getCreatedAt() != null) {
            pageExport.createdAt(page.getCreatedAt().toInstant());
        }
        if (page.getUpdatedAt() != null) {
            pageExport.updatedAt(page.getUpdatedAt().toInstant());
        }
        pageExport.parentId(page.getParentId());
        pageExport.excludedAccessControls(page.isExcludedAccessControls());
        Set<AccessControl> set = page.getAccessControls();
        if (set != null) {
            pageExport.accessControls(new LinkedHashSet<AccessControl>(set));
        }
        pageExport.hidden(page.getHidden());
        pageExport.content(page.getContent());
        pageExport.homepage(page.isHomepage());
        pageExport.generalConditions(page.getGeneralConditions());
        pageExport.source(page.getSource());
        Map<String, String> map = page.getConfiguration();
        if (map != null) {
            pageExport.configuration(new LinkedHashMap<String, String>(map));
        }
        if ((map1 = page.getMetadata()) != null) {
            pageExport.metadata(new LinkedHashMap<String, String>(map1));
        }
        pageExport.useAutoFetch(page.getUseAutoFetch());
        List<PageMedia> list = page.getAttachedMedia();
        if (list != null) {
            pageExport.attachedMedia(new ArrayList<PageMedia>(list));
        }
        return pageExport.build();
    }

    private PlanMode sourcePlanDefinitionHttpV4Mode(io.gravitee.apim.core.plan.model.Plan plan) {
        io.gravitee.definition.model.v4.plan.Plan planDefinitionHttpV4 = plan.getPlanDefinitionHttpV4();
        if (planDefinitionHttpV4 == null) {
            return null;
        }
        return planDefinitionHttpV4.getMode();
    }

    private PlanStatus sourcePlanDefinitionHttpV4Status(io.gravitee.apim.core.plan.model.Plan plan) {
        io.gravitee.definition.model.v4.plan.Plan planDefinitionHttpV4 = plan.getPlanDefinitionHttpV4();
        if (planDefinitionHttpV4 == null) {
            return null;
        }
        return planDefinitionHttpV4.getStatus();
    }

    private PlanMode sourcePlanDefinitionNativeV4Mode(io.gravitee.apim.core.plan.model.Plan plan) {
        NativePlan planDefinitionNativeV4 = plan.getPlanDefinitionNativeV4();
        if (planDefinitionNativeV4 == null) {
            return null;
        }
        return planDefinitionNativeV4.getMode();
    }

    private PlanStatus sourcePlanDefinitionNativeV4Status(io.gravitee.apim.core.plan.model.Plan plan) {
        NativePlan planDefinitionNativeV4 = plan.getPlanDefinitionNativeV4();
        if (planDefinitionNativeV4 == null) {
            return null;
        }
        return planDefinitionNativeV4.getStatus();
    }

    private PlanMode sourceFederatedPlanDefinitionMode(io.gravitee.apim.core.plan.model.Plan plan) {
        FederatedPlan federatedPlanDefinition = plan.getFederatedPlanDefinition();
        if (federatedPlanDefinition == null) {
            return null;
        }
        return federatedPlanDefinition.getMode();
    }

    private PlanStatus sourceFederatedPlanDefinitionStatus(io.gravitee.apim.core.plan.model.Plan plan) {
        FederatedPlan federatedPlanDefinition = plan.getFederatedPlanDefinition();
        if (federatedPlanDefinition == null) {
            return null;
        }
        return federatedPlanDefinition.getStatus();
    }

    private String sourceFederatedPlanDefinitionProviderId(io.gravitee.apim.core.plan.model.Plan plan) {
        FederatedPlan federatedPlanDefinition = plan.getFederatedPlanDefinition();
        if (federatedPlanDefinition == null) {
            return null;
        }
        return federatedPlanDefinition.getProviderId();
    }

    private String sourcePlanDefinitionV2Status(io.gravitee.apim.core.plan.model.Plan plan) {
        Plan planDefinitionV2 = plan.getPlanDefinitionV2();
        if (planDefinitionV2 == null) {
            return null;
        }
        return planDefinitionV2.getStatus();
    }

    private String sourcePlanDefinitionV2SecurityDefinition(io.gravitee.apim.core.plan.model.Plan plan) {
        Plan planDefinitionV2 = plan.getPlanDefinitionV2();
        if (planDefinitionV2 == null) {
            return null;
        }
        return planDefinitionV2.getSecurityDefinition();
    }

    private Map<String, List<Rule>> sourcePlanDefinitionV2Paths(io.gravitee.apim.core.plan.model.Plan plan) {
        Plan planDefinitionV2 = plan.getPlanDefinitionV2();
        if (planDefinitionV2 == null) {
            return null;
        }
        return planDefinitionV2.getPaths();
    }

    private List<io.gravitee.definition.model.flow.Flow> sourcePlanDefinitionV2Flows(io.gravitee.apim.core.plan.model.Plan plan) {
        Plan planDefinitionV2 = plan.getPlanDefinitionV2();
        if (planDefinitionV2 == null) {
            return null;
        }
        return planDefinitionV2.getFlows();
    }

    protected Lifecycle.State lifecycleStateToState(Api.LifecycleState lifecycleState) {
        if (lifecycleState == null) {
            return null;
        }
        return switch (lifecycleState) {
            case Api.LifecycleState.STARTED -> Lifecycle.State.STARTED;
            case Api.LifecycleState.STOPPED -> Lifecycle.State.STOPPED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)lifecycleState));
        };
    }

    protected ApiLifecycleState apiLifecycleStateToApiLifecycleState(Api.ApiLifecycleState apiLifecycleState) {
        if (apiLifecycleState == null) {
            return null;
        }
        return switch (apiLifecycleState) {
            case Api.ApiLifecycleState.CREATED -> ApiLifecycleState.CREATED;
            case Api.ApiLifecycleState.PUBLISHED -> ApiLifecycleState.PUBLISHED;
            case Api.ApiLifecycleState.UNPUBLISHED -> ApiLifecycleState.UNPUBLISHED;
            case Api.ApiLifecycleState.DEPRECATED -> ApiLifecycleState.DEPRECATED;
            case Api.ApiLifecycleState.ARCHIVED -> ApiLifecycleState.ARCHIVED;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)apiLifecycleState));
        };
    }

    private List<Listener> apiEntityApiDefinitionHttpV4Listeners(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getListeners();
    }

    private Analytics apiEntityApiDefinitionHttpV4Analytics(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getAnalytics();
    }

    private FlowExecution apiEntityApiDefinitionHttpV4FlowExecution(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getFlowExecution();
    }

    private List<Flow> apiEntityApiDefinitionHttpV4Flows(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getFlows();
    }

    private Map<String, Map<String, ResponseTemplate>> apiEntityApiDefinitionHttpV4ResponseTemplates(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getResponseTemplates();
    }

    private List<Property> apiEntityApiDefinitionHttpV4Properties(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getProperties();
    }

    private List<io.gravitee.definition.model.v4.resource.Resource> apiEntityApiDefinitionHttpV4Resources(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getResources();
    }

    private List<EndpointGroup> apiEntityApiDefinitionHttpV4EndpointGroups(Api api) {
        io.gravitee.definition.model.v4.Api apiDefinitionHttpV4 = api.getApiDefinitionHttpV4();
        if (apiDefinitionHttpV4 == null) {
            return null;
        }
        return apiDefinitionHttpV4.getEndpointGroups();
    }

    protected Visibility visibilityToVisibility(Api.Visibility visibility) {
        if (visibility == null) {
            return null;
        }
        return switch (visibility) {
            case Api.Visibility.PUBLIC -> Visibility.PUBLIC;
            case Api.Visibility.PRIVATE -> Visibility.PRIVATE;
            default -> throw new IllegalArgumentException("Unexpected enum constant: " + String.valueOf((Object)visibility));
        };
    }

    private List<NativeListener> apiEntityApiDefinitionNativeV4Listeners(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getListeners();
    }

    private List<NativeFlow> apiEntityApiDefinitionNativeV4Flows(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getFlows();
    }

    private List<Property> apiEntityApiDefinitionNativeV4Properties(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getProperties();
    }

    private List<io.gravitee.definition.model.v4.resource.Resource> apiEntityApiDefinitionNativeV4Resources(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getResources();
    }

    private List<NativeEndpointGroup> apiEntityApiDefinitionNativeV4EndpointGroups(Api api) {
        NativeApi apiDefinitionNativeV4 = api.getApiDefinitionNativeV4();
        if (apiDefinitionNativeV4 == null) {
            return null;
        }
        return apiDefinitionNativeV4.getEndpointGroups();
    }

    protected OriginContext.Integration integrationToIntegration(Integration integration) {
        if (integration == null) {
            return null;
        }
        String integrationId = null;
        String integrationName = null;
        String provider = null;
        integrationId = integration.getId();
        integrationName = integration.getName();
        provider = integration.getProvider();
        OriginContext.Origin origin = null;
        OriginContext.Integration integration1 = new OriginContext.Integration(origin, integrationId, integrationName, provider);
        return integration1;
    }

    private String apiEntityFederatedApiDefinitionProviderId(Api api) {
        FederatedApi federatedApiDefinition = api.getFederatedApiDefinition();
        if (federatedApiDefinition == null) {
            return null;
        }
        return federatedApiDefinition.getProviderId();
    }

    private Proxy apiEntityApiDefinitionProxy(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getProxy();
    }

    private Services apiEntityApiDefinitionServices(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getServices();
    }

    private List<Resource> apiEntityApiDefinitionResources(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getResources();
    }

    private Map<String, List<Rule>> apiEntityApiDefinitionPaths(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getPaths();
    }

    private List<io.gravitee.definition.model.flow.Flow> apiEntityApiDefinitionFlows(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getFlows();
    }

    private Properties apiEntityApiDefinitionProperties(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getProperties();
    }

    private Set<String> apiEntityApiDefinitionTags(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getTags();
    }

    private Map<String, Pattern> apiEntityApiDefinitionPathMappings(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getPathMappings();
    }

    private Map<String, Map<String, ResponseTemplate>> apiEntityApiDefinitionResponseTemplates(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getResponseTemplates();
    }

    private List<Plan> apiEntityApiDefinitionPlans(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getPlans();
    }

    private ExecutionMode apiEntityApiDefinitionExecutionMode(Api api) {
        io.gravitee.definition.model.Api apiDefinition = api.getApiDefinition();
        if (apiDefinition == null) {
            return null;
        }
        return apiDefinition.getExecutionMode();
    }

    protected NewApiMetadata metadataToNewApiMetadata(Metadata metadata) {
        if (metadata == null) {
            return null;
        }
        NewApiMetadata.NewApiMetadataBuilder newApiMetadata = NewApiMetadata.builder();
        newApiMetadata.key(metadata.getKey());
        newApiMetadata.name(metadata.getName());
        newApiMetadata.format(metadata.getFormat());
        newApiMetadata.value(metadata.getValue());
        return newApiMetadata.build();
    }
}

