/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import com.google.common.base.Strings;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.v4.ApiImagesService;
import jakarta.xml.bind.DatatypeConverter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiImagesServiceImpl
implements ApiImagesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiImagesServiceImpl.class);
    @Value(value="${configuration.default-api-icon:}")
    private String defaultApiIcon;
    private final ApiRepository apiRepository;
    private final AuditService auditService;

    public ApiImagesServiceImpl(@Lazy ApiRepository apiRepository, AuditService auditService) {
        this.apiRepository = apiRepository;
        this.auditService = auditService;
    }

    @Override
    public InlinePictureEntity getApiPicture(ExecutionContext executionContext, String apiId) {
        Api api;
        try {
            api = this.findApi(executionContext, apiId);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        String picture = api.getPicture();
        if (picture != null) {
            ApiImagesServiceImpl.convertImage(imageEntity, picture);
        } else {
            this.getDefaultPicture().ifPresent(content -> {
                imageEntity.setType("image/png");
                imageEntity.setContent(content);
            });
        }
        return imageEntity;
    }

    @Override
    public void updateApiPicture(ExecutionContext executionContext, String apiId, String picture) {
        try {
            Api apiToUpdate = this.findApi(executionContext, apiId);
            Api newApi = apiToUpdate.withPicture(picture).withUpdatedAt(new Date());
            this.apiRepository.update((Object)newApi);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, newApi.getUpdatedAt(), apiToUpdate, newApi);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    @Override
    public InlinePictureEntity getApiBackground(ExecutionContext executionContext, String apiId) {
        Api api;
        try {
            api = this.findApi(executionContext, apiId);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        String background = api.getBackground();
        if (background != null) {
            ApiImagesServiceImpl.convertImage(imageEntity, background);
        }
        return imageEntity;
    }

    @Override
    public void updateApiBackground(ExecutionContext executionContext, String apiId, String background) {
        try {
            Api apiToUpdate = this.findApi(executionContext, apiId);
            Api newApi = apiToUpdate.withBackground(background).withUpdatedAt(new Date());
            this.apiRepository.update((Object)newApi);
            this.auditService.createApiAuditLog(executionContext, apiId, Collections.emptyMap(), (Audit.AuditEvent)Api.AuditEvent.API_UPDATED, newApi.getUpdatedAt(), apiToUpdate, newApi);
        }
        catch (TechnicalException ex) {
            log.error("An error occurs while trying to find an API using its ID: {}", (Object)apiId, (Object)ex);
            throw new TechnicalManagementException("An error occurs while trying to find an API using its ID: " + apiId, ex);
        }
    }

    private Api findApi(ExecutionContext executionContext, String apiId) throws TechnicalException {
        log.debug("Find API by ID: {}", (Object)apiId);
        Optional<Api> optApi = this.apiRepository.findById((Object)apiId);
        if (executionContext.hasEnvironmentId()) {
            optApi = optApi.filter(result -> executionContext.getEnvironmentId().equals(result.getEnvironmentId()));
        }
        Api api = (Api)optApi.orElseThrow(() -> new ApiNotFoundException(apiId));
        return api;
    }

    private static void convertImage(InlinePictureEntity imageEntity, String picture) {
        String[] parts = picture.split(";", 2);
        imageEntity.setType(parts[0].split(":")[1]);
        String base64Content = picture.split(",", 2)[1];
        imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
    }

    private Optional<byte[]> getDefaultPicture() {
        Optional<byte[]> content = Optional.empty();
        if (!Strings.isNullOrEmpty((String)this.defaultApiIcon)) {
            try {
                content = Optional.of(IOUtils.toByteArray((InputStream)new FileInputStream(this.defaultApiIcon)));
            }
            catch (IOException ioe) {
                log.error("Default icon for API does not exist", (Throwable)ioe);
            }
        }
        return content;
    }
}

