/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiExportDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.api.model.NewApiMetadata;
import io.gravitee.apim.core.api.model.import_definition.ApiDescriptor;
import io.gravitee.apim.core.api.model.import_definition.ApiMember;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.api.model.import_definition.PageExport;
import io.gravitee.apim.core.api.model.import_definition.PlanDescriptor;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.query_service.PageQueryService;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.media.model.Media;
import io.gravitee.apim.core.media.query_service.MediaQueryService;
import io.gravitee.apim.core.membership.crud_service.MembershipCrudService;
import io.gravitee.apim.core.membership.domain_service.ApiPrimaryOwnerDomainService;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.metadata.crud_service.MetadataCrudService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.apim.core.workflow.crud_service.WorkflowCrudService;
import io.gravitee.apim.core.workflow.model.Workflow;
import io.gravitee.apim.infra.adapter.GraviteeDefinitionAdapter;
import io.gravitee.apim.infra.adapter.MemberAdapter;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.v4.ApiType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.permissions.RolePermission;
import io.gravitee.rest.api.model.permissions.RolePermissionAction;
import io.gravitee.rest.api.service.PermissionService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.ApiDefinitionVersionNotSupportedException;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ApiExportDomainServiceImpl
implements ApiExportDomainService {
    private static final GraviteeDefinitionAdapter DEFINITION_ADAPTER = GraviteeDefinitionAdapter.INSTANCE;
    private final PermissionService permissionService;
    private final MediaQueryService mediaService;
    private final WorkflowCrudService workflowCrudService;
    private final MembershipCrudService membershipCrudService;
    private final MetadataCrudService metadataCrudService;
    private final PageQueryService pageQueryService;
    private final ApiCrudService apiCrudService;
    private final ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService;
    private final PlanCrudService planCrudService;
    private final IntegrationCrudService integrationCrudService;

    @Override
    public GraviteeDefinition export(String apiId, AuditInfo auditInfo, Collection<ApiExportDomainService.Excludable> excluded) {
        ExecutionContext executionContext = new ExecutionContext(auditInfo.organizationId(), auditInfo.environmentId());
        PrimaryOwnerEntity apiPrimaryOwner = this.apiPrimaryOwnerDomainService.getApiPrimaryOwner(auditInfo.organizationId(), apiId);
        Api api1 = this.apiCrudService.findById(apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
        Set<ApiMember> members = !excluded.contains((Object)ApiExportDomainService.Excludable.MEMBERS) ? this.exportApiMembers(apiId) : null;
        Set<NewApiMetadata> metadata = !excluded.contains((Object)ApiExportDomainService.Excludable.METADATA) ? this.exportApiMetadata(executionContext, apiId) : null;
        List<PageExport> pages = !excluded.contains((Object)ApiExportDomainService.Excludable.PAGES_MEDIA) ? this.exportApiPages(apiId) : null;
        List<Media> medias = !excluded.contains((Object)ApiExportDomainService.Excludable.PAGES_MEDIA) ? this.exportApiMedia(apiId) : null;
        WorkflowState workflowState = CollectionUtils.stream(this.workflowCrudService.findByApiId(apiId)).map(Workflow::getState).map(Enum::name).map(WorkflowState::valueOf).findFirst().orElse(null);
        Set<String> groups = !excluded.contains((Object)ApiExportDomainService.Excludable.GROUPS) ? api1.getGroups() : null;
        return switch (this.apiType(api1).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Collection<PlanDescriptor.V2> plans = this.mapPlan(apiId, DEFINITION_ADAPTER::mapPlanV2, excluded);
                ApiDescriptor.ApiDescriptorV2 api = DEFINITION_ADAPTER.mapV2(api1, apiPrimaryOwner, workflowState, groups, metadata);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
            case 1 -> {
                Collection<PlanDescriptor.V4> plans = this.mapPlan(apiId, DEFINITION_ADAPTER::mapPlanV4, excluded);
                ApiDescriptor.ApiDescriptorV4 api = DEFINITION_ADAPTER.mapV4(api1, apiPrimaryOwner, workflowState, groups, metadata);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
            case 2 -> {
                Collection<PlanDescriptor.V4> plans = this.mapPlan(apiId, DEFINITION_ADAPTER::mapPlanNative, excluded);
                ApiDescriptor.Native api = DEFINITION_ADAPTER.mapNative(api1, apiPrimaryOwner, workflowState, groups, metadata);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
            case 3 -> {
                OriginContext.Integration ori;
                Collection<PlanDescriptor.Federated> plans = this.mapPlan(apiId, DEFINITION_ADAPTER::mapPlanFederated, excluded);
                OriginContext var16_21 = api1.getOriginContext();
                Integration integ = var16_21 instanceof OriginContext.Integration && (ori = (OriginContext.Integration)var16_21).integrationName() == null ? (Integration)this.integrationCrudService.findById(ori.integrationId()).orElse(null) : null;
                ApiDescriptor.Federated api = DEFINITION_ADAPTER.mapFederated(api1, apiPrimaryOwner, workflowState, groups, metadata, integ);
                yield GraviteeDefinition.from(api, members, metadata, pages, plans, medias, api1.getPicture(), api1.getBackground());
            }
        };
    }

    private Set<ApiMember> exportApiMembers(String apiId) {
        return this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_MEMBER, apiId, RolePermissionAction.READ) ? CollectionUtils.stream(this.membershipCrudService.findByApiId(apiId)).filter(memberEntity -> memberEntity.getMemberType() == Membership.Type.USER).map(MemberAdapter.INSTANCE::toApiMember).collect(Collectors.toSet()) : null;
    }

    private Set<NewApiMetadata> exportApiMetadata(ExecutionContext executionContext, String apiId) {
        return this.permissionService.hasPermission(executionContext, RolePermission.API_METADATA, apiId, RolePermissionAction.READ) ? DEFINITION_ADAPTER.mapMetadata(this.metadataCrudService.findByApiId(apiId)) : null;
    }

    private List<PageExport> exportApiPages(String apiId) {
        return this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.READ) ? DEFINITION_ADAPTER.mapPage(this.pageQueryService.searchByApiId(apiId)) : null;
    }

    private List<Media> exportApiMedia(String apiId) {
        return this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_DOCUMENTATION, apiId, RolePermissionAction.READ) ? this.mediaService.findAllByApiId(apiId) : null;
    }

    private Collection<? extends PlanDescriptor> exportApiPlans(Api api) {
        if (!this.permissionService.hasPermission(GraviteeContext.getExecutionContext(), RolePermission.API_PLAN, api.getId(), RolePermissionAction.READ)) {
            return null;
        }
        return switch (this.apiType(api).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CollectionUtils.stream(this.planCrudService.findByApiId(api.getId())).map(DEFINITION_ADAPTER::mapPlanV2).toList();
            case 1 -> CollectionUtils.stream(this.planCrudService.findByApiId(api.getId())).map(DEFINITION_ADAPTER::mapPlanV4).toList();
            case 2 -> CollectionUtils.stream(this.planCrudService.findByApiId(api.getId())).map(DEFINITION_ADAPTER::mapPlanNative).toList();
            case 3 -> List.of();
        };
    }

    private ValidatedType apiType(Api api1) {
        if (api1.getDefinitionVersion() == DefinitionVersion.V4 && api1.getApiDefinitionHttpV4() != null && api1.getType() != ApiType.NATIVE) {
            return ValidatedType.V4;
        }
        if (api1.getDefinitionVersion() == DefinitionVersion.V4 && api1.getApiDefinitionNativeV4() != null && api1.getType() == ApiType.NATIVE) {
            return ValidatedType.V4_NATIVE;
        }
        if (api1.getDefinitionVersion() == DefinitionVersion.FEDERATED && api1.getFederatedApiDefinition() != null) {
            return ValidatedType.FEDERATED;
        }
        if (api1.getDefinitionVersion() == DefinitionVersion.V2 && api1.getApiDefinition() != null) {
            return ValidatedType.V2;
        }
        throw new ApiDefinitionVersionNotSupportedException(api1.getDefinitionVersion() != null ? api1.getDefinitionVersion().getLabel() : null);
    }

    @Nullable
    private <T> Collection<T> mapPlan(String apiId, Function<Plan, T> mapper, Collection<ApiExportDomainService.Excludable> excluded) {
        return excluded.contains((Object)ApiExportDomainService.Excludable.PLANS) ? null : CollectionUtils.stream(this.planCrudService.findByApiId(apiId)).map(mapper).toList();
    }

    @Generated
    public ApiExportDomainServiceImpl(PermissionService permissionService, MediaQueryService mediaService, WorkflowCrudService workflowCrudService, MembershipCrudService membershipCrudService, MetadataCrudService metadataCrudService, PageQueryService pageQueryService, ApiCrudService apiCrudService, ApiPrimaryOwnerDomainService apiPrimaryOwnerDomainService, PlanCrudService planCrudService, IntegrationCrudService integrationCrudService) {
        this.permissionService = permissionService;
        this.mediaService = mediaService;
        this.workflowCrudService = workflowCrudService;
        this.membershipCrudService = membershipCrudService;
        this.metadataCrudService = metadataCrudService;
        this.pageQueryService = pageQueryService;
        this.apiCrudService = apiCrudService;
        this.apiPrimaryOwnerDomainService = apiPrimaryOwnerDomainService;
        this.planCrudService = planCrudService;
        this.integrationCrudService = integrationCrudService;
    }

    private static enum ValidatedType {
        V2,
        V4,
        V4_NATIVE,
        FEDERATED;

    }
}

