/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.domain_service.ApiExportDomainService;
import io.gravitee.apim.core.api.exception.ApiNotFoundException;
import io.gravitee.apim.core.api.model.import_definition.GraviteeDefinition;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.json.GraviteeDefinitionSerializer;
import io.gravitee.apim.core.json.JsonProcessingException;
import io.gravitee.apim.core.scoring.model.ScoreRequest;
import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.model.ScoringFunction;
import io.gravitee.apim.core.scoring.model.ScoringRuleset;
import io.gravitee.apim.core.scoring.query_service.ScoringFunctionQueryService;
import io.gravitee.apim.core.scoring.query_service.ScoringRulesetQueryService;
import io.gravitee.apim.core.scoring.service_provider.ScoringProvider;
import io.gravitee.apim.core.utils.StringUtils;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.reactivestreams.Publisher;

@UseCase
public class ScoreApiRequestUseCase {
    private final ApiCrudService apiCrudService;
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final ApiExportDomainService apiExportDomainService;
    private final GraviteeDefinitionSerializer graviteeDefinitionSerializer;
    private final ScoringProvider scoringProvider;
    private final AsyncJobCrudService asyncJobCrudService;
    private final ScoringRulesetQueryService scoringRulesetQueryService;
    private final ScoringFunctionQueryService scoringFunctionQueryService;

    public Completable execute(Input input) {
        Flowable pages$ = Flowable.fromIterable(this.apiDocumentationDomainService.getApiPages(input.apiId, null)).filter(page -> page.isAsyncApi() || page.isSwagger()).map(this::assetToScore);
        Single customRulesets$ = Flowable.fromCallable(() -> this.scoringRulesetQueryService.findByReference(input.auditInfo.environmentId(), ScoringRuleset.ReferenceType.ENVIRONMENT)).flatMap(Flowable::fromIterable).flatMapMaybe(this::customRuleset).toList();
        Single customFunctions$ = Flowable.fromCallable(() -> this.scoringFunctionQueryService.findByReference(input.auditInfo.environmentId(), ScoringFunction.ReferenceType.ENVIRONMENT)).flatMap(Flowable::fromIterable).map(r -> new ScoreRequest.Function(r.name(), r.payload())).toList();
        Flowable export$ = Flowable.fromCallable(() -> this.apiExportDomainService.export(input.apiId, input.auditInfo, EnumSet.noneOf(ApiExportDomainService.Excludable.class))).map(this::assetToScore).onErrorResumeNext(th -> Flowable.empty());
        return Maybe.fromOptional(this.apiCrudService.findById(input.apiId())).switchIfEmpty((SingleSource)Single.error((Throwable)new ApiNotFoundException(input.apiId()))).flatMap(api -> Flowable.merge((Publisher)pages$, (Publisher)export$).toList()).flatMap(assets -> Single.zip((SingleSource)customRulesets$, (SingleSource)customFunctions$, RulesetAndFunctions::new).map(entry -> new ScoreRequest(UuidString.generateRandom(), input.auditInfo.organizationId(), input.auditInfo.environmentId(), input.apiId, (List<ScoreRequest.AssetToScore>)assets, entry.rulesets(), entry.functions()))).flatMapCompletable(request -> {
            AsyncJob job = this.newScoringJob(request.jobId(), input.auditInfo, input.apiId, this.deadLine((ScoreRequest)request));
            return this.scoringProvider.requestScore((ScoreRequest)request).doOnComplete(() -> this.asyncJobCrudService.create(job));
        });
    }

    private ScoreRequest.AssetToScore assetToScore(Page page) {
        return new ScoreRequest.AssetToScore(page.getId(), new ScoreRequest.AssetType(ScoringAssetType.fromPageType(page.getType())), page.getName(), page.getContent());
    }

    private ScoreRequest.AssetToScore assetToScore(GraviteeDefinition definition) throws JsonProcessingException {
        return new ScoreRequest.AssetToScore(definition.api().id(), new ScoreRequest.AssetType(ScoringAssetType.GRAVITEE_DEFINITION, ScoreApiRequestUseCase.getFormat(definition)), definition.api().name(), this.graviteeDefinitionSerializer.serialize(definition));
    }

    private static ScoreRequest.Format getFormat(GraviteeDefinition definition) {
        GraviteeDefinition graviteeDefinition = definition;
        Objects.requireNonNull(graviteeDefinition);
        GraviteeDefinition graviteeDefinition2 = graviteeDefinition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GraviteeDefinition.V2.class, GraviteeDefinition.Federated.class, GraviteeDefinition.Native.class, GraviteeDefinition.V4.class}, (Object)graviteeDefinition2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                GraviteeDefinition.V2 ignored = (GraviteeDefinition.V2)graviteeDefinition2;
                yield ScoreRequest.Format.GRAVITEE_V2;
            }
            case 1 -> {
                GraviteeDefinition.Federated ignored = (GraviteeDefinition.Federated)graviteeDefinition2;
                yield ScoreRequest.Format.GRAVITEE_FEDERATED;
            }
            case 2 -> {
                GraviteeDefinition.Native ignored = (GraviteeDefinition.Native)graviteeDefinition2;
                yield ScoreRequest.Format.GRAVITEE_NATIVE;
            }
            case 3 -> {
                GraviteeDefinition.V4 v4 = (GraviteeDefinition.V4)graviteeDefinition2;
                switch (v4.api().type()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case PROXY: {
                        yield ScoreRequest.Format.GRAVITEE_PROXY;
                    }
                    case MESSAGE: {
                        yield ScoreRequest.Format.GRAVITEE_MESSAGE;
                    }
                    case NATIVE: 
                }
                yield ScoreRequest.Format.GRAVITEE_NATIVE;
            }
        };
    }

    private Maybe<ScoreRequest.CustomRuleset> customRuleset(ScoringRuleset scoringRuleset) {
        return StringUtils.isEmpty(scoringRuleset.payload()) ? Maybe.empty() : Maybe.just((Object)new ScoreRequest.CustomRuleset(scoringRuleset.payload(), this.format(scoringRuleset.format())));
    }

    private ScoreRequest.Format format(ScoringRuleset.Format format) {
        ScoringRuleset.Format format2 = format;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"GRAVITEE_FEDERATION", "GRAVITEE_MESSAGE", "GRAVITEE_PROXY", "GRAVITEE_NATIVE", "GRAVITEE_V2", "OPENAPI", "ASYNCAPI"}, (ScoringRuleset.Format)format2, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> null;
            case 0 -> ScoreRequest.Format.GRAVITEE_FEDERATED;
            case 1 -> ScoreRequest.Format.GRAVITEE_MESSAGE;
            case 2 -> ScoreRequest.Format.GRAVITEE_PROXY;
            case 3 -> ScoreRequest.Format.GRAVITEE_NATIVE;
            case 4 -> ScoreRequest.Format.GRAVITEE_V2;
            case 5, 6 -> null;
        };
    }

    public AsyncJob newScoringJob(String id, AuditInfo auditInfo, String apiId, Duration ttl) {
        ZonedDateTime now = TimeProvider.now();
        return AsyncJob.builder().id(id).sourceId(apiId).environmentId(auditInfo.environmentId()).initiatorId(auditInfo.actor().userId()).type(AsyncJob.Type.SCORING_REQUEST).status(AsyncJob.Status.PENDING).upperLimit(1L).createdAt(now).updatedAt(now).deadLine(now.plus(ttl)).build();
    }

    private Duration deadLine(ScoreRequest request) {
        Duration margin = Duration.ofSeconds(30L);
        int nbAssets = request.assets().size();
        int rulesets = Math.min(1, request.customRulesets().size());
        int numberOfRuns = nbAssets * rulesets;
        return Duration.ofSeconds(10L).multipliedBy(numberOfRuns).plus(margin);
    }

    @Generated
    public ScoreApiRequestUseCase(ApiCrudService apiCrudService, ApiDocumentationDomainService apiDocumentationDomainService, ApiExportDomainService apiExportDomainService, GraviteeDefinitionSerializer graviteeDefinitionSerializer, ScoringProvider scoringProvider, AsyncJobCrudService asyncJobCrudService, ScoringRulesetQueryService scoringRulesetQueryService, ScoringFunctionQueryService scoringFunctionQueryService) {
        this.apiCrudService = apiCrudService;
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.apiExportDomainService = apiExportDomainService;
        this.graviteeDefinitionSerializer = graviteeDefinitionSerializer;
        this.scoringProvider = scoringProvider;
        this.asyncJobCrudService = asyncJobCrudService;
        this.scoringRulesetQueryService = scoringRulesetQueryService;
        this.scoringFunctionQueryService = scoringFunctionQueryService;
    }

    public record Input(String apiId, AuditInfo auditInfo) {
    }

    private record RulesetAndFunctions(List<ScoreRequest.CustomRuleset> rulesets, List<ScoreRequest.Function> functions) {
    }
}

