/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.repository.management.model.GroupEvent;
import io.gravitee.rest.api.model.GroupEntity;
import io.gravitee.rest.api.model.MembershipEntity;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.service.GroupService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.GroupsNotFoundException;
import io.gravitee.rest.api.service.exceptions.InvalidDataException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.validation.GroupValidationService;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class GroupValidationServiceImpl
extends TransactionalService
implements GroupValidationService {
    private final GroupService groupService;
    private final MembershipService membershipService;

    public GroupValidationServiceImpl(GroupService groupService, MembershipService membershipService) {
        this.groupService = groupService;
        this.membershipService = membershipService;
    }

    @Override
    public Set<String> validateAndSanitize(ExecutionContext executionContext, String apiId, Set<String> groups, PrimaryOwnerEntity primaryOwnerEntity, boolean addDefaultGroups) {
        Set<String> sanitizedGroups = new HashSet<String>();
        if (groups != null && !groups.isEmpty()) {
            try {
                Set<GroupEntity> groundGroupEntities = this.groupService.findByIds(groups);
                sanitizedGroups = this.removePrimaryOwnerGroups(executionContext, groundGroupEntities, apiId);
            }
            catch (GroupsNotFoundException e) {
                throw new InvalidDataException("These groups [" + e.getParameters().get("groups") + "] do not exist");
            }
        }
        if (addDefaultGroups) {
            Set defaultGroups = this.groupService.findByEvent(executionContext.getEnvironmentId(), GroupEvent.API_CREATE).stream().map(GroupEntity::getId).collect(Collectors.toSet());
            sanitizedGroups.addAll(defaultGroups);
        }
        if (primaryOwnerEntity != null && ApiPrimaryOwnerMode.GROUP.name().equals(primaryOwnerEntity.getType())) {
            sanitizedGroups.add(primaryOwnerEntity.getId());
        }
        return sanitizedGroups;
    }

    private Set<String> removePrimaryOwnerGroups(ExecutionContext executionContext, Set<GroupEntity> groundGroupEntities, String apiId) {
        MembershipEntity primaryOwner;
        Stream<Object> groupEntityStream = groundGroupEntities.stream();
        groupEntityStream = apiId != null ? ((primaryOwner = this.membershipService.getPrimaryOwner(executionContext.getOrganizationId(), MembershipReferenceType.API, apiId)).getMemberType() == MembershipMemberType.GROUP ? groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()) || group.getId().equals(primaryOwner.getMemberId())) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()))) : groupEntityStream.filter(group -> StringUtils.isEmpty((CharSequence)group.getApiPrimaryOwner()));
        return groupEntityStream.map(GroupEntity::getId).collect(Collectors.toSet());
    }
}

