/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.api;

import io.gravitee.apim.core.api.domain_service.CategoryDomainService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.utils.CollectionUtils;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiCategoryOrderRepository;
import io.gravitee.repository.management.model.ApiCategoryOrder;
import io.gravitee.rest.api.service.converter.CategoryMapper;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class CategoryDomainServiceImpl
implements CategoryDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CategoryDomainServiceImpl.class);
    private final CategoryMapper categoryMapper;
    private final ApiCategoryOrderRepository apiCategoryOrderRepository;

    public CategoryDomainServiceImpl(CategoryMapper categoryMapper, @Lazy ApiCategoryOrderRepository apiCategoryOrderRepository) {
        this.categoryMapper = categoryMapper;
        this.apiCategoryOrderRepository = apiCategoryOrderRepository;
    }

    @Override
    public Set<String> toCategoryId(Api api, String environmentId) {
        return this.categoryMapper.toCategoryId(environmentId, api.getCategories());
    }

    @Override
    public Set<String> toCategoryKey(Api api, String environmentId) {
        return this.categoryMapper.toCategoryKey(environmentId, api.getCategories());
    }

    @Override
    public void updateOrderCategoriesOfApi(String apiId, @Nullable Collection<String> categoryIds) {
        try {
            Set previousCategories = this.apiCategoryOrderRepository.findAllByApiId(apiId);
            this.apiCategoryOrderRepository.delete(apiId, previousCategories.stream().map(ApiCategoryOrder::getCategoryId).toList());
            if (!CollectionUtils.isEmpty(categoryIds)) {
                int index = 0;
                for (String categoryId : categoryIds) {
                    ApiCategoryOrder categoryOrder = ApiCategoryOrder.builder().categoryId(categoryId).apiId(apiId).order(index++).build();
                    this.apiCategoryOrderRepository.create(categoryOrder);
                }
            }
        }
        catch (TechnicalException ex) {
            log.error("Impossible to update order categories of API", (Throwable)ex);
        }
    }
}

