/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultEnvironmentUpgrader
implements Upgrader {
    private final Logger logger = LoggerFactory.getLogger(DefaultEnvironmentUpgrader.class);
    @Autowired
    private EnvironmentService environmentService;

    public boolean upgrade() {
        try {
            if (this.environmentService.findByOrganization(GraviteeContext.getDefaultOrganization()).isEmpty()) {
                this.logger.info("    No environment found. Add default one.");
                this.environmentService.initialize();
            }
        }
        catch (Exception e) {
            this.logger.error("unable to apply upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    public int getOrder() {
        return 100;
    }
}

