/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.log;

import io.gravitee.apim.core.log.crud_service.ConnectionLogsCrudService;
import io.gravitee.apim.infra.adapter.ConnectionLogAdapter;
import io.gravitee.repository.analytics.AnalyticsException;
import io.gravitee.repository.common.query.QueryContext;
import io.gravitee.repository.log.v4.api.LogRepository;
import io.gravitee.repository.log.v4.model.LogResponse;
import io.gravitee.repository.log.v4.model.connection.ConnectionLog;
import io.gravitee.repository.log.v4.model.connection.ConnectionLogDetailQuery;
import io.gravitee.repository.log.v4.model.connection.ConnectionLogQuery;
import io.gravitee.rest.api.model.analytics.SearchLogsFilters;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.model.v4.log.SearchLogsResponse;
import io.gravitee.rest.api.model.v4.log.connection.BaseConnectionLog;
import io.gravitee.rest.api.model.v4.log.connection.ConnectionLogDetail;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
class ConnectionLogsCrudServiceImpl
implements ConnectionLogsCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionLogsCrudServiceImpl.class);
    private final LogRepository logRepository;

    public ConnectionLogsCrudServiceImpl(@Lazy LogRepository logRepository) {
        this.logRepository = logRepository;
    }

    @Override
    public SearchLogsResponse<BaseConnectionLog> searchApiConnectionLogs(ExecutionContext executionContext, String apiId, SearchLogsFilters logsFilters, Pageable pageable) {
        try {
            LogResponse response = this.logRepository.searchConnectionLogs(new QueryContext(executionContext.getOrganizationId(), executionContext.getEnvironmentId()), ConnectionLogQuery.builder().filter(ConnectionLogQuery.Filter.builder().apiId(apiId).from(logsFilters.from()).to(logsFilters.to()).applicationIds(logsFilters.applicationIds()).planIds(logsFilters.planIds()).methods(logsFilters.methods()).statuses(logsFilters.statuses()).entrypointIds(logsFilters.entrypointIds()).build()).page(pageable.getPageNumber()).size(pageable.getPageSize()).build());
            return this.mapToConnectionResponse((LogResponse<ConnectionLog>)response);
        }
        catch (AnalyticsException e) {
            log.error("An error occurs while trying to search connection logs of api [apiId={}]", (Object)apiId, (Object)e);
            throw new TechnicalManagementException("Error while searching connection logs of api " + apiId, e);
        }
    }

    @Override
    public Optional<ConnectionLogDetail> searchApiConnectionLog(ExecutionContext executionContext, String apiId, String requestId) {
        try {
            Optional response = this.logRepository.searchConnectionLogDetail(new QueryContext(executionContext.getOrganizationId(), executionContext.getEnvironmentId()), ConnectionLogDetailQuery.builder().filter(ConnectionLogDetailQuery.Filter.builder().apiId(apiId).requestId(requestId).build()).build());
            return response.map(this::mapToConnectionLogDetail);
        }
        catch (AnalyticsException e) {
            log.error("An error occurs while trying to search connection log of api [apiId={}, requestId={}]", new Object[]{apiId, requestId, e});
            throw new TechnicalManagementException("Error while searching connection log of api " + apiId + " requestId " + requestId, e);
        }
    }

    private SearchLogsResponse<BaseConnectionLog> mapToConnectionResponse(LogResponse<ConnectionLog> logs) {
        long total = logs != null ? logs.total() : 0L;
        List<BaseConnectionLog> data = ConnectionLogAdapter.INSTANCE.toEntitiesList(logs != null ? logs.data() : new ArrayList());
        return new SearchLogsResponse(total, data);
    }

    private ConnectionLogDetail mapToConnectionLogDetail(io.gravitee.repository.log.v4.model.connection.ConnectionLogDetail connectionLogDetail) {
        return ConnectionLogAdapter.INSTANCE.toEntity(connectionLogDetail);
    }
}

