/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.portal_menu_link.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.portal_menu_link.crud_service.PortalMenuLinkCrudService;
import io.gravitee.apim.core.portal_menu_link.model.PortalMenuLink;
import io.gravitee.apim.core.portal_menu_link.query_service.PortalMenuLinkQueryService;
import lombok.Generated;

@UseCase
public class DeletePortalMenuLinkUseCase {
    private final PortalMenuLinkCrudService portalMenuLinkCrudService;
    private final PortalMenuLinkQueryService portalMenuLinkQueryService;

    public Output execute(Input input) {
        PortalMenuLink existingPortalMenuLink = this.portalMenuLinkCrudService.getByIdAndEnvironmentId(input.portalMenuLinkId(), input.environmentId());
        this.portalMenuLinkCrudService.delete(existingPortalMenuLink.getId());
        this.updatePortalMenuLinkOrder(existingPortalMenuLink.getOrder(), existingPortalMenuLink.getEnvironmentId());
        return new Output();
    }

    private void updatePortalMenuLinkOrder(int oldOrder, String environmentId) {
        int orderIncrement = -1;
        this.portalMenuLinkQueryService.findByEnvironmentIdSortByOrder(environmentId).stream().filter(menuLink -> this.toBeMovedUp(oldOrder, menuLink.getOrder())).forEach(menuLink -> {
            int updatedOrder = menuLink.getOrder() + orderIncrement;
            this.portalMenuLinkCrudService.update(menuLink.toBuilder().order(updatedOrder).build());
        });
    }

    private boolean toBeMovedUp(int oldOrder, int portalMenuLinkOrder) {
        return oldOrder < portalMenuLinkOrder;
    }

    @Generated
    public DeletePortalMenuLinkUseCase(PortalMenuLinkCrudService portalMenuLinkCrudService, PortalMenuLinkQueryService portalMenuLinkQueryService) {
        this.portalMenuLinkCrudService = portalMenuLinkCrudService;
        this.portalMenuLinkQueryService = portalMenuLinkQueryService;
    }

    public record Input(String portalMenuLinkId, String environmentId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String portalMenuLinkId;
            @Generated
            private String environmentId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder portalMenuLinkId(String portalMenuLinkId) {
                this.portalMenuLinkId = portalMenuLinkId;
                return this;
            }

            @Generated
            public InputBuilder environmentId(String environmentId) {
                this.environmentId = environmentId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.portalMenuLinkId, this.environmentId);
            }

            @Generated
            public String toString() {
                return "DeletePortalMenuLinkUseCase.Input.InputBuilder(portalMenuLinkId=" + this.portalMenuLinkId + ", environmentId=" + this.environmentId + ")";
            }
        }
    }

    public record Output() {
    }
}

