/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.api.DefinitionContextEntity;
import io.gravitee.rest.api.service.ApiDefinitionContextService;
import io.gravitee.rest.api.service.exceptions.ApiNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiDefinitionContextServiceImpl
implements ApiDefinitionContextService {
    private static final Logger LOG = LoggerFactory.getLogger(ApiDefinitionContextServiceImpl.class);
    private final ApiRepository apiRepository;

    @Autowired
    public ApiDefinitionContextServiceImpl(@Lazy ApiRepository apiRepository) {
        this.apiRepository = apiRepository;
    }

    @Override
    public void setDefinitionContext(String apiId, DefinitionContextEntity definitionContext) {
        try {
            Api api = (Api)this.apiRepository.findById((Object)apiId).orElseThrow(() -> new ApiNotFoundException(apiId));
            api.setOrigin(definitionContext.getOrigin());
            api.setMode(definitionContext.getMode());
            api.setSyncFrom(definitionContext.getSyncFrom());
            this.apiRepository.update((Object)api);
        }
        catch (TechnicalException e) {
            LOG.error("An error has occurred while trying to set definition context on API " + apiId, (Throwable)e);
            throw new TechnicalManagementException(e);
        }
    }
}

