/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.infra.adapter.ApiAdapter;
import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.federation.FederatedApiEntity;

public abstract class ApiAdapterDecorator
implements ApiAdapter {
    private final ApiAdapter delegate;

    public ApiAdapterDecorator(ApiAdapter delegate) {
        this.delegate = delegate;
    }

    @Override
    public Api toRepository(io.gravitee.apim.core.api.model.Api source) {
        Api api = this.delegate.toRepository(source);
        api.setOrigin(source.getOriginContext().name());
        OriginContext originContext = source.getOriginContext();
        if (originContext instanceof OriginContext.Integration) {
            OriginContext.Integration integration = (OriginContext.Integration)originContext;
            api.setIntegrationId(integration.integrationId());
        } else {
            originContext = source.getOriginContext();
            if (originContext instanceof OriginContext.Kubernetes) {
                OriginContext.Kubernetes kub = (OriginContext.Kubernetes)originContext;
                api.setMode(kub.mode().name().toLowerCase());
                api.setSyncFrom(kub.syncFrom());
            }
        }
        return api;
    }

    @Override
    public io.gravitee.apim.core.api.model.Api toCoreModel(Api source) {
        io.gravitee.apim.core.api.model.Api api = this.delegate.toCoreModel(source);
        api.setOriginContext(ApiAdapterDecorator.toOriginContext(source));
        return api;
    }

    @Override
    public FederatedApiEntity toFederatedApiEntity(Api source, PrimaryOwnerEntity primaryOwnerEntity) {
        FederatedApiEntity api = this.delegate.toFederatedApiEntity(source, primaryOwnerEntity);
        OriginContext originContext = ApiAdapterDecorator.toOriginContext(source);
        if (originContext instanceof OriginContext.Integration) {
            OriginContext.Integration integrationCtx = (OriginContext.Integration)originContext;
            api.setOriginContext(integrationCtx);
        }
        api.setCategories(source.getCategories());
        return api;
    }

    public static OriginContext toOriginContext(Api source) {
        return switch (ApiAdapterDecorator.getOriginContextOrDefault(source)) {
            default -> throw new IncompatibleClassChangeError();
            case OriginContext.Origin.MANAGEMENT -> new OriginContext.Management();
            case OriginContext.Origin.KUBERNETES -> new OriginContext.Kubernetes(source.getMode() != null ? OriginContext.Kubernetes.Mode.valueOf((String)source.getMode().toUpperCase()) : OriginContext.Kubernetes.Mode.FULLY_MANAGED);
            case OriginContext.Origin.INTEGRATION -> new OriginContext.Integration(source.getIntegrationId());
        };
    }

    private static OriginContext.Origin getOriginContextOrDefault(Api source) {
        try {
            return source.getOrigin() == null ? OriginContext.Origin.MANAGEMENT : OriginContext.Origin.valueOf((String)source.getOrigin().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return OriginContext.Origin.MANAGEMENT;
        }
    }
}

