/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.scoring;

import io.gravitee.apim.core.scoring.model.EnvironmentApiScoringReport;
import io.gravitee.apim.core.scoring.model.EnvironmentOverview;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.apim.core.scoring.query_service.ScoringReportQueryService;
import io.gravitee.apim.infra.adapter.ScoringReportAdapter;
import io.gravitee.common.data.domain.Page;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ScoringReportRepository;
import io.gravitee.rest.api.model.common.Pageable;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScoringReportQueryServiceImpl
extends AbstractService
implements ScoringReportQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScoringReportQueryServiceImpl.class);
    private final ScoringReportRepository scoringReportRepository;

    public ScoringReportQueryServiceImpl(@Lazy ScoringReportRepository scoringReportRepository) {
        this.scoringReportRepository = scoringReportRepository;
    }

    @Override
    public Optional<ScoringReport> findLatestByApiId(String apiId) {
        try {
            return this.scoringReportRepository.findLatestFor(apiId).map(ScoringReportAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding Scoring Report by API id", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding Scoring Report of API: " + apiId, e);
        }
    }

    @Override
    public Page<EnvironmentApiScoringReport> findEnvironmentLatestReports(String environmentId, Pageable pageable) {
        try {
            return this.scoringReportRepository.findEnvironmentLatestReports(environmentId, ScoringReportQueryServiceImpl.convert(pageable)).map(ScoringReportAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            log.error("An error occurred while finding latest Scoring Reports for environment", (Throwable)e);
            throw new TechnicalManagementException("An error occurred while finding latest Scoring Reports for environment: " + environmentId, e);
        }
    }

    @Override
    public EnvironmentOverview getEnvironmentScoringSummary(String environmentId) {
        try {
            return ScoringReportAdapter.INSTANCE.toEntity(this.scoringReportRepository.getScoringEnvironmentSummary(environmentId));
        }
        catch (TechnicalException e) {
            log.error("An error occurred while getting Scoring Environment Summary of {}", (Object)environmentId, (Object)e);
            throw new TechnicalManagementException("An error occurred while getting Scoring Environment Summary of " + environmentId, e);
        }
    }
}

