/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.PageAuditEvent;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.crud_service.PageRevisionCrudService;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.search.Indexer;
import io.gravitee.apim.core.search.model.IndexablePage;
import java.time.ZoneId;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

@DomainService
public class UpdateApiDocumentationDomainService {
    private final PageCrudService pageCrudService;
    private final PageRevisionCrudService pageRevisionCrudService;
    private final AuditDomainService auditDomainService;
    private final Indexer indexer;

    public Page updatePage(Page page, Page oldPage, AuditInfo auditInfo) {
        Page updatedPage = this.pageCrudService.updateDocumentationPage(page);
        if (updatedPage.isSwaggerOrMarkdown() || updatedPage.isAsyncApi()) {
            if (!Objects.equals(updatedPage.getName(), oldPage.getName()) || !Objects.equals(updatedPage.getContent(), oldPage.getContent())) {
                this.pageRevisionCrudService.create(updatedPage);
            }
            Indexer.IndexationContext context = new Indexer.IndexationContext(auditInfo.organizationId(), auditInfo.environmentId());
            if (page.isPublished()) {
                this.indexer.index(context, new IndexablePage(page));
            } else {
                this.indexer.delete(context, new IndexablePage(page));
            }
        }
        this.auditDomainService.createApiAuditLog(ApiAuditLogEntity.builder().apiId(page.getReferenceId()).event(PageAuditEvent.PAGE_UPDATED).createdAt(page.getUpdatedAt().toInstant().atZone(ZoneId.of("UTC"))).organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).actor(auditInfo.actor()).properties(Map.of(AuditProperties.PAGE, page.getId())).oldValue(oldPage).newValue(updatedPage).build());
        return updatedPage;
    }

    @Generated
    public UpdateApiDocumentationDomainService(PageCrudService pageCrudService, PageRevisionCrudService pageRevisionCrudService, AuditDomainService auditDomainService, Indexer indexer) {
        this.pageCrudService = pageCrudService;
        this.pageRevisionCrudService = pageRevisionCrudService;
        this.auditDomainService = auditDomainService;
        this.indexer = indexer;
    }
}

