/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.query_service.access_point;

import io.gravitee.apim.core.access_point.model.AccessPoint;
import io.gravitee.apim.core.access_point.query_service.AccessPointQueryService;
import io.gravitee.apim.infra.adapter.AccessPointAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.AccessPointRepository;
import io.gravitee.repository.management.model.AccessPoint;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class AccessPointQueryServiceImpl
implements AccessPointQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AccessPointQueryServiceImpl.class);
    private final AccessPointRepository accessPointRepository;

    public AccessPointQueryServiceImpl(@Lazy AccessPointRepository accessPointRepository) {
        this.accessPointRepository = accessPointRepository;
    }

    @Override
    public Optional<ReferenceContext> getReferenceContext(String host) {
        try {
            return this.accessPointRepository.findByHost(host).map(accessPoint -> ReferenceContext.builder().referenceId(accessPoint.getReferenceId()).referenceType(ReferenceContext.Type.valueOf(accessPoint.getReferenceType().name())).build());
        }
        catch (TechnicalException e) {
            log.debug("Unable to retrieve access point from given host '{}'", (Object)host, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public List<io.gravitee.apim.core.access_point.model.AccessPoint> getConsoleAccessPoints() {
        try {
            return this.accessPointRepository.findByTarget(AccessPointAdapter.INSTANCE.fromEntity(AccessPoint.Target.CONSOLE)).stream().map(AccessPointAdapter.INSTANCE::toEntity).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while getting all console access points", e);
        }
    }

    @Override
    public List<io.gravitee.apim.core.access_point.model.AccessPoint> getConsoleAccessPoints(String organizationId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organizationId, AccessPoint.Target.CONSOLE, true).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting console access point for organization '%s'", organizationId), e);
        }
    }

    @Override
    public io.gravitee.apim.core.access_point.model.AccessPoint getConsoleAccessPoint(String organizationId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organizationId, AccessPoint.Target.CONSOLE, false).findFirst().orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting console access point for organization '%s'", organizationId), e);
        }
    }

    @Override
    public io.gravitee.apim.core.access_point.model.AccessPoint getConsoleApiAccessPoint(String organizationId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ORGANIZATION, organizationId, AccessPoint.Target.CONSOLE_API, false).findFirst().orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting console api access point for organization '%s'", organizationId), e);
        }
    }

    @Override
    public List<io.gravitee.apim.core.access_point.model.AccessPoint> getPortalAccessPoints() {
        try {
            return this.findAccessPoints(AccessPoint.Target.PORTAL);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException("An error occurs while getting all portal access points", e);
        }
    }

    @Override
    public List<io.gravitee.apim.core.access_point.model.AccessPoint> getPortalAccessPoints(String environmentId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environmentId, AccessPoint.Target.PORTAL, true).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting portal access point for environment '%s'", environmentId), e);
        }
    }

    @Override
    public io.gravitee.apim.core.access_point.model.AccessPoint getPortalAccessPoint(String environmentId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environmentId, AccessPoint.Target.PORTAL, false).findFirst().orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting portal access point for environment '%s'", environmentId), e);
        }
    }

    @Override
    public io.gravitee.apim.core.access_point.model.AccessPoint getPortalApiAccessPoint(String environmentId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environmentId, AccessPoint.Target.PORTAL_API, false).findFirst().orElse(null);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting portal api access point for environment '%s'", environmentId), e);
        }
    }

    @Override
    public List<io.gravitee.apim.core.access_point.model.AccessPoint> getGatewayAccessPoints(String environmentId) {
        try {
            return this.findAccessPoints(AccessPoint.ReferenceType.ENVIRONMENT, environmentId, AccessPoint.Target.GATEWAY, false).toList();
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while getting gateway restricted domain from environment '%s'", environmentId), e);
        }
    }

    private List<io.gravitee.apim.core.access_point.model.AccessPoint> findAccessPoints(AccessPoint.Target target) throws TechnicalException {
        return this.accessPointRepository.findByTarget(AccessPointAdapter.INSTANCE.fromEntity(target)).stream().map(AccessPointAdapter.INSTANCE::toEntity).toList();
    }

    private Stream<io.gravitee.apim.core.access_point.model.AccessPoint> findAccessPoints(AccessPoint.ReferenceType referenceType, String referenceId, AccessPoint.Target target, boolean includeAll) throws TechnicalException {
        ArrayList<AccessPoint> filteredList = new ArrayList<AccessPoint>();
        List accessPoints = this.accessPointRepository.findByReferenceAndTarget(AccessPointAdapter.INSTANCE.fromEntity(referenceType), referenceId, AccessPointAdapter.INSTANCE.fromEntity(target));
        if (accessPoints.size() == 1 || includeAll) {
            filteredList.addAll(accessPoints);
        } else {
            filteredList.addAll(accessPoints.stream().filter(AccessPoint::isOverriding).toList());
        }
        return filteredList.stream().map(AccessPointAdapter.INSTANCE::toEntity);
    }
}

