/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.notification;

import io.gravitee.apim.core.notification.domain_service.TriggerNotificationDomainService;
import io.gravitee.apim.core.notification.model.Recipient;
import io.gravitee.apim.core.notification.model.hook.ApiHookContext;
import io.gravitee.apim.core.notification.model.hook.ApplicationHookContext;
import io.gravitee.apim.core.notification.model.hook.portal.PortalHookContext;
import io.gravitee.apim.infra.notification.internal.TemplateDataFetcher;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TriggerNotificationDomainServiceFacadeImpl
implements TriggerNotificationDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TriggerNotificationDomainServiceFacadeImpl.class);
    private final NotifierService notifierService;
    private final TemplateDataFetcher templateDataFetcher;

    @Override
    public void triggerApiNotification(String organizationId, String environmentId, ApiHookContext context) {
        Map<String, Object> notificationParameters = this.templateDataFetcher.fetchData(organizationId, context);
        this.notifierService.trigger(new ExecutionContext(organizationId, environmentId), context.getHook(), context.getApiId(), notificationParameters);
    }

    @Override
    public void triggerApplicationNotification(String organizationId, String environmentId, ApplicationHookContext context) {
        this.triggerApplicationNotification(organizationId, environmentId, context, Collections.emptyList());
    }

    @Override
    public void triggerApplicationNotification(String organizationId, String environmentId, ApplicationHookContext context, List<Recipient> additionalRecipients) {
        Map<String, Object> notificationParameters = this.templateDataFetcher.fetchData(organizationId, context);
        this.notifierService.trigger(new ExecutionContext(organizationId, environmentId), context.getHook(), context.getApplicationId(), notificationParameters, additionalRecipients);
    }

    @Override
    public void triggerPortalNotification(String organizationId, String environmentId, PortalHookContext context) {
        Map<String, Object> notificationParameters = this.templateDataFetcher.fetchData(organizationId, context);
        this.notifierService.trigger(new ExecutionContext(organizationId, environmentId), context.getHook(), notificationParameters);
    }

    @Generated
    public TriggerNotificationDomainServiceFacadeImpl(NotifierService notifierService, TemplateDataFetcher templateDataFetcher) {
        this.notifierService = notifierService;
        this.templateDataFetcher = templateDataFetcher;
    }
}

