/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.scoring.model.EnvironmentApiScoringReport;
import io.gravitee.apim.core.scoring.model.EnvironmentOverview;
import io.gravitee.apim.core.scoring.model.ScoringAssetType;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.apim.infra.adapter.ScoringReportAdapter;
import io.gravitee.repository.management.model.ScoringEnvironmentApi;
import io.gravitee.repository.management.model.ScoringEnvironmentSummary;
import io.gravitee.repository.management.model.ScoringReport;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ScoringReportAdapterImpl
implements ScoringReportAdapter {
    @Override
    public io.gravitee.apim.core.scoring.model.ScoringReport toEntity(ScoringReport source) {
        if (source == null) {
            return null;
        }
        ScoringReport.ScoringReportBuilder scoringReport = io.gravitee.apim.core.scoring.model.ScoringReport.builder();
        scoringReport.id(source.getId());
        scoringReport.apiId(source.getApiId());
        scoringReport.environmentId(source.getEnvironmentId());
        if (source.getCreatedAt() != null) {
            scoringReport.createdAt(ZonedDateTime.ofInstant(source.getCreatedAt().toInstant(), ZoneId.systemDefault()));
        }
        scoringReport.summary(this.summaryToSummary(source.getSummary()));
        scoringReport.assets(this.assetListToAssetList(source.getAssets()));
        return scoringReport.build();
    }

    @Override
    public EnvironmentOverview toEntity(ScoringEnvironmentSummary source) {
        if (source == null) {
            return null;
        }
        String environmentId = null;
        Double score = null;
        Long errors = null;
        Long warnings = null;
        Long infos = null;
        Long hints = null;
        environmentId = source.getEnvironmentId();
        score = source.getScore();
        errors = source.getErrors();
        warnings = source.getWarnings();
        infos = source.getInfos();
        hints = source.getHints();
        EnvironmentOverview environmentOverview = new EnvironmentOverview(environmentId, score, errors, warnings, infos, hints);
        return environmentOverview;
    }

    @Override
    public EnvironmentApiScoringReport.Api toEnvironmentApiScoringReportApi(ScoringEnvironmentApi source) {
        if (source == null) {
            return null;
        }
        String apiId = null;
        String name = null;
        ZonedDateTime updatedAt = null;
        apiId = source.getApiId();
        name = source.getApiName();
        if (source.getApiUpdatedAt() != null) {
            updatedAt = ZonedDateTime.ofInstant(source.getApiUpdatedAt().toInstant(), ZoneId.systemDefault());
        }
        EnvironmentApiScoringReport.Api api = new EnvironmentApiScoringReport.Api(apiId, name, updatedAt);
        return api;
    }

    @Override
    public EnvironmentApiScoringReport.Summary toEnvironmentApiScoringReportSummary(ScoringEnvironmentApi source) {
        if (source == null) {
            return null;
        }
        String id = null;
        ZonedDateTime createdAt = null;
        double score = 0.0;
        long errors = 0L;
        long warnings = 0L;
        long infos = 0L;
        long hints = 0L;
        id = source.getReportId();
        if (source.getReportCreatedAt() != null) {
            createdAt = ZonedDateTime.ofInstant(source.getReportCreatedAt().toInstant(), ZoneId.systemDefault());
        }
        if (source.getScore() != null) {
            score = source.getScore();
        }
        if (source.getErrors() != null) {
            errors = source.getErrors();
        }
        if (source.getWarnings() != null) {
            warnings = source.getWarnings();
        }
        if (source.getInfos() != null) {
            infos = source.getInfos();
        }
        if (source.getHints() != null) {
            hints = source.getHints();
        }
        EnvironmentApiScoringReport.Summary summary = new EnvironmentApiScoringReport.Summary(id, createdAt, score, errors, warnings, infos, hints);
        return summary;
    }

    @Override
    public ScoringReport toRepository(io.gravitee.apim.core.scoring.model.ScoringReport source) {
        if (source == null) {
            return null;
        }
        ScoringReport.ScoringReportBuilder scoringReport = ScoringReport.builder();
        scoringReport.id(source.id());
        scoringReport.apiId(source.apiId());
        scoringReport.environmentId(source.environmentId());
        if (source.createdAt() != null) {
            scoringReport.createdAt(Date.from(source.createdAt().toInstant()));
        }
        scoringReport.summary(this.summaryToSummary1(source.summary()));
        scoringReport.assets(this.assetListToAssetList1(source.assets()));
        return scoringReport.build();
    }

    protected ScoringReport.Summary summaryToSummary(ScoringReport.Summary summary) {
        if (summary == null) {
            return null;
        }
        Double score = null;
        Long errors = null;
        Long warnings = null;
        Long infos = null;
        Long hints = null;
        score = summary.score();
        errors = summary.errors();
        warnings = summary.warnings();
        infos = summary.infos();
        hints = summary.hints();
        ScoringReport.Summary summary1 = new ScoringReport.Summary(score, errors, warnings, infos, hints);
        return summary1;
    }

    protected ScoringReport.Position positionToPosition(ScoringReport.Position position) {
        if (position == null) {
            return null;
        }
        int line = 0;
        int character = 0;
        line = position.line();
        character = position.character();
        ScoringReport.Position position1 = new ScoringReport.Position(line, character);
        return position1;
    }

    protected ScoringReport.Range rangeToRange(ScoringReport.Range range) {
        if (range == null) {
            return null;
        }
        ScoringReport.Position start = null;
        ScoringReport.Position end = null;
        start = this.positionToPosition(range.start());
        end = this.positionToPosition(range.end());
        ScoringReport.Range range1 = new ScoringReport.Range(start, end);
        return range1;
    }

    protected ScoringReport.Diagnostic diagnosticToDiagnostic(ScoringReport.Diagnostic diagnostic) {
        if (diagnostic == null) {
            return null;
        }
        ScoringReport.Severity severity = null;
        ScoringReport.Range range = null;
        String rule = null;
        String message = null;
        String path = null;
        if (diagnostic.severity() != null) {
            severity = Enum.valueOf(ScoringReport.Severity.class, diagnostic.severity());
        }
        range = this.rangeToRange(diagnostic.range());
        rule = diagnostic.rule();
        message = diagnostic.message();
        path = diagnostic.path();
        ScoringReport.Diagnostic diagnostic1 = new ScoringReport.Diagnostic(severity, range, rule, message, path);
        return diagnostic1;
    }

    protected List<ScoringReport.Diagnostic> diagnosticListToDiagnosticList(List<ScoringReport.Diagnostic> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Diagnostic> list1 = new ArrayList<ScoringReport.Diagnostic>(list.size());
        for (ScoringReport.Diagnostic diagnostic : list) {
            list1.add(this.diagnosticToDiagnostic(diagnostic));
        }
        return list1;
    }

    protected ScoringReport.ScoringError scoringErrorToScoringError(ScoringReport.ScoringError scoringError) {
        if (scoringError == null) {
            return null;
        }
        String code = null;
        ArrayList<String> path = null;
        code = scoringError.code();
        List list = scoringError.path();
        if (list != null) {
            path = new ArrayList<String>(list);
        }
        ScoringReport.ScoringError scoringError1 = new ScoringReport.ScoringError(code, path);
        return scoringError1;
    }

    protected List<ScoringReport.ScoringError> scoringErrorListToScoringErrorList(List<ScoringReport.ScoringError> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.ScoringError> list1 = new ArrayList<ScoringReport.ScoringError>(list.size());
        for (ScoringReport.ScoringError scoringError : list) {
            list1.add(this.scoringErrorToScoringError(scoringError));
        }
        return list1;
    }

    protected ScoringReport.Asset assetToAsset(ScoringReport.Asset asset) {
        if (asset == null) {
            return null;
        }
        String pageId = null;
        ScoringAssetType type = null;
        List<ScoringReport.Diagnostic> diagnostics = null;
        List<ScoringReport.ScoringError> errors = null;
        pageId = asset.pageId();
        if (asset.type() != null) {
            type = Enum.valueOf(ScoringAssetType.class, asset.type());
        }
        diagnostics = this.diagnosticListToDiagnosticList(asset.diagnostics());
        errors = this.scoringErrorListToScoringErrorList(asset.errors());
        ScoringReport.Asset asset1 = new ScoringReport.Asset(pageId, type, diagnostics, errors);
        return asset1;
    }

    protected List<ScoringReport.Asset> assetListToAssetList(List<ScoringReport.Asset> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Asset> list1 = new ArrayList<ScoringReport.Asset>(list.size());
        for (ScoringReport.Asset asset : list) {
            list1.add(this.assetToAsset(asset));
        }
        return list1;
    }

    protected ScoringReport.Summary summaryToSummary1(ScoringReport.Summary summary) {
        if (summary == null) {
            return null;
        }
        Double score = null;
        Long errors = null;
        Long warnings = null;
        Long infos = null;
        Long hints = null;
        score = summary.score();
        errors = summary.errors();
        warnings = summary.warnings();
        infos = summary.infos();
        hints = summary.hints();
        ScoringReport.Summary summary1 = new ScoringReport.Summary(score, errors, warnings, infos, hints);
        return summary1;
    }

    protected ScoringReport.Position positionToPosition1(ScoringReport.Position position) {
        if (position == null) {
            return null;
        }
        int line = 0;
        int character = 0;
        line = position.line();
        character = position.character();
        ScoringReport.Position position1 = new ScoringReport.Position(line, character);
        return position1;
    }

    protected ScoringReport.Range rangeToRange1(ScoringReport.Range range) {
        if (range == null) {
            return null;
        }
        ScoringReport.Position start = null;
        ScoringReport.Position end = null;
        start = this.positionToPosition1(range.start());
        end = this.positionToPosition1(range.end());
        ScoringReport.Range range1 = new ScoringReport.Range(start, end);
        return range1;
    }

    protected ScoringReport.Diagnostic diagnosticToDiagnostic1(ScoringReport.Diagnostic diagnostic) {
        if (diagnostic == null) {
            return null;
        }
        String severity = null;
        ScoringReport.Range range = null;
        String rule = null;
        String message = null;
        String path = null;
        if (diagnostic.severity() != null) {
            severity = diagnostic.severity().name();
        }
        range = this.rangeToRange1(diagnostic.range());
        rule = diagnostic.rule();
        message = diagnostic.message();
        path = diagnostic.path();
        ScoringReport.Diagnostic diagnostic1 = new ScoringReport.Diagnostic(severity, range, rule, message, path);
        return diagnostic1;
    }

    protected List<ScoringReport.Diagnostic> diagnosticListToDiagnosticList1(List<ScoringReport.Diagnostic> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Diagnostic> list1 = new ArrayList<ScoringReport.Diagnostic>(list.size());
        for (ScoringReport.Diagnostic diagnostic : list) {
            list1.add(this.diagnosticToDiagnostic1(diagnostic));
        }
        return list1;
    }

    protected ScoringReport.ScoringError scoringErrorToScoringError1(ScoringReport.ScoringError scoringError) {
        if (scoringError == null) {
            return null;
        }
        String code = null;
        ArrayList<String> path = null;
        code = scoringError.code();
        List<String> list = scoringError.path();
        if (list != null) {
            path = new ArrayList<String>(list);
        }
        ScoringReport.ScoringError scoringError1 = new ScoringReport.ScoringError(code, path);
        return scoringError1;
    }

    protected List<ScoringReport.ScoringError> scoringErrorListToScoringErrorList1(List<ScoringReport.ScoringError> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.ScoringError> list1 = new ArrayList<ScoringReport.ScoringError>(list.size());
        for (ScoringReport.ScoringError scoringError : list) {
            list1.add(this.scoringErrorToScoringError1(scoringError));
        }
        return list1;
    }

    protected ScoringReport.Asset assetToAsset1(ScoringReport.Asset asset) {
        if (asset == null) {
            return null;
        }
        String pageId = null;
        String type = null;
        List<ScoringReport.Diagnostic> diagnostics = null;
        List<ScoringReport.ScoringError> errors = null;
        pageId = asset.pageId();
        if (asset.type() != null) {
            type = asset.type().name();
        }
        diagnostics = this.diagnosticListToDiagnosticList1(asset.diagnostics());
        errors = this.scoringErrorListToScoringErrorList1(asset.errors());
        ScoringReport.Asset asset1 = new ScoringReport.Asset(pageId, type, diagnostics, errors);
        return asset1;
    }

    protected List<ScoringReport.Asset> assetListToAssetList1(List<ScoringReport.Asset> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScoringReport.Asset> list1 = new ArrayList<ScoringReport.Asset>(list.size());
        for (ScoringReport.Asset asset : list) {
            list1.add(this.assetToAsset1(asset));
        }
        return list1;
    }
}

