/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api.domain_service.VerifyApiPathDomainService;
import io.gravitee.apim.core.api.model.crd.ApiCRDSpec;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.category.domain_service.ValidateCategoryIdsDomainService;
import io.gravitee.apim.core.documentation.domain_service.ValidatePagesDomainService;
import io.gravitee.apim.core.group.domain_service.ValidateGroupsDomainService;
import io.gravitee.apim.core.member.domain_service.ValidateCRDMembersDomainService;
import io.gravitee.apim.core.member.model.MembershipReferenceType;
import io.gravitee.apim.core.resource.domain_service.ValidateResourceDomainService;
import io.gravitee.apim.core.validation.Validator;
import java.util.ArrayList;
import lombok.Generated;

@DomainService
public class ValidateApiCRDDomainService
implements Validator<Input> {
    private final ValidateCategoryIdsDomainService categoryIdsValidator;
    private final VerifyApiPathDomainService apiPathValidator;
    private final ValidateCRDMembersDomainService membersValidator;
    private final ValidateGroupsDomainService groupsValidator;
    private final ValidateResourceDomainService resourceValidator;
    private final ValidatePagesDomainService pagesValidator;

    @Override
    public Validator.Result<Input> validateAndSanitize(Input input) {
        ArrayList<Validator.Error> errors = new ArrayList<Validator.Error>();
        ApiCRDSpec.ApiCRDSpecBuilder sanitizedBuilder = input.spec().toBuilder();
        if (!input.spec.isNative()) {
            this.validateAndSanitizeHttpV4ForCreation(input, sanitizedBuilder, errors);
        } else {
            this.validateAndSanitizeNativeV4ForCreation(input, sanitizedBuilder, errors);
        }
        this.categoryIdsValidator.validateAndSanitize(new ValidateCategoryIdsDomainService.Input(input.auditInfo().environmentId(), input.spec().getCategories())).peek(sanitized -> sanitizedBuilder.categories(sanitized.idOrKeys()), errors::addAll);
        this.membersValidator.validateAndSanitize(new ValidateCRDMembersDomainService.Input(input.auditInfo(), input.spec.getId(), MembershipReferenceType.API, input.spec().getMembers())).peek(sanitized -> sanitizedBuilder.members(sanitized.members()), errors::addAll);
        this.groupsValidator.validateAndSanitize(new ValidateGroupsDomainService.Input(input.auditInfo.environmentId(), input.spec().getGroups(), input.spec().getDefinitionVersion())).peek(sanitized -> sanitizedBuilder.groups(sanitized.groups()), errors::addAll);
        this.resourceValidator.validateAndSanitize(new ValidateResourceDomainService.Input(input.auditInfo.environmentId(), input.spec().getResources())).peek(sanitized -> sanitizedBuilder.resources(sanitized.resources()), errors::addAll);
        this.pagesValidator.validateAndSanitize(new ValidatePagesDomainService.Input(input.auditInfo, input.spec.getId(), input.spec.getPages())).peek(sanitized -> sanitizedBuilder.pages(sanitized.pages()), errors::addAll);
        return Validator.Result.ofBoth(new Input(input.auditInfo(), sanitizedBuilder.build()), errors);
    }

    private void validateAndSanitizeHttpV4ForCreation(Input input, ApiCRDSpec.ApiCRDSpecBuilder sanitizedBuilder, ArrayList<Validator.Error> errors) {
        this.apiPathValidator.validateAndSanitize(new VerifyApiPathDomainService.Input(input.auditInfo.environmentId(), input.spec.getId(), input.spec.getPaths())).peek(sanitized -> sanitizedBuilder.paths(sanitized.paths()), errors::addAll);
    }

    private void validateAndSanitizeNativeV4ForCreation(Input input, ApiCRDSpec.ApiCRDSpecBuilder sanitizedBuilder, ArrayList<Validator.Error> errors) {
    }

    @Generated
    public ValidateApiCRDDomainService(ValidateCategoryIdsDomainService categoryIdsValidator, VerifyApiPathDomainService apiPathValidator, ValidateCRDMembersDomainService membersValidator, ValidateGroupsDomainService groupsValidator, ValidateResourceDomainService resourceValidator, ValidatePagesDomainService pagesValidator) {
        this.categoryIdsValidator = categoryIdsValidator;
        this.apiPathValidator = apiPathValidator;
        this.membersValidator = membersValidator;
        this.groupsValidator = groupsValidator;
        this.resourceValidator = resourceValidator;
        this.pagesValidator = pagesValidator;
    }

    public record Input(AuditInfo auditInfo, ApiCRDSpec spec) implements Validator.Input
    {
    }
}

