/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.cockpit.command.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.gravitee.cockpit.api.command.v1.CockpitCommandType;
import io.gravitee.cockpit.api.command.v1.v4api.V4ApiCommand;
import io.gravitee.cockpit.api.command.v1.v4api.V4ApiCommandPayload;
import io.gravitee.cockpit.api.command.v1.v4api.V4ApiReply;
import io.gravitee.cockpit.api.command.v1.v4api.V4ApiReplyPayload;
import io.gravitee.exchange.api.command.CommandHandler;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.cockpit.services.V4ApiServiceCockpit;
import io.gravitee.rest.api.service.common.SecurityContextHelper;
import io.reactivex.rxjava3.core.Single;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class V4ApiCommandHandler
implements CommandHandler<V4ApiCommand, V4ApiReply> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(V4ApiCommandHandler.class);
    private final V4ApiServiceCockpit v4ApiServiceCockpit;
    private final UserService userService;

    public String supportType() {
        return CockpitCommandType.V4_API.name();
    }

    public Single<V4ApiReply> handle(V4ApiCommand command) {
        V4ApiCommandPayload payload = (V4ApiCommandPayload)command.getPayload();
        UserEntity user = this.userService.findBySource(payload.organizationId(), "cockpit", payload.userId(), true);
        SecurityContextHelper.authenticateAs(user);
        try {
            return this.v4ApiServiceCockpit.createPublishApi(payload.organizationId(), payload.environmentId(), user.getId(), payload.apiDefinition()).flatMap(apiEntity -> {
                V4ApiReplyPayload v4ApiReplyPayload = V4ApiReplyPayload.builder().apiId(apiEntity.getId()).apiName(apiEntity.getName()).apiVersion(apiEntity.getApiVersion()).build();
                log.info("Api {} successfully created.", (Object)apiEntity.getName());
                return Single.just((Object)new V4ApiReply(command.getId(), v4ApiReplyPayload));
            });
        }
        catch (JsonProcessingException exception) {
            String errorDetails = "An error occurred while creating Api.";
            log.error(errorDetails, (Throwable)exception);
            return Single.just((Object)new V4ApiReply(command.getId(), errorDetails));
        }
    }

    @Generated
    public V4ApiCommandHandler(V4ApiServiceCockpit v4ApiServiceCockpit, UserService userService) {
        this.v4ApiServiceCockpit = v4ApiServiceCockpit;
        this.userService = userService;
    }
}

