/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl;

import io.gravitee.repository.management.model.Api;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.gravitee.rest.api.service.NotifierService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import io.gravitee.rest.api.service.notification.ApiHook;
import io.gravitee.rest.api.service.notification.NotificationParamsBuilder;
import io.gravitee.rest.api.service.v4.ApiNotificationService;
import io.gravitee.rest.api.service.v4.mapper.GenericApiMapper;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class ApiNotificationServiceImpl
extends AbstractService
implements ApiNotificationService {
    private final GenericApiMapper indexableApiMapper;
    private final NotifierService notifierService;
    private final UserService userService;

    public ApiNotificationServiceImpl(GenericApiMapper indexableApiMapper, NotifierService notifierService, UserService userService) {
        this.indexableApiMapper = indexableApiMapper;
        this.notifierService = notifierService;
        this.userService = userService;
    }

    @Override
    @Async
    public void triggerUpdateNotification(ExecutionContext executionContext, Api api) {
        GenericApiEntity indexableApi = this.indexableApiMapper.toGenericApi(api, null);
        this.triggerUpdateNotification(executionContext, indexableApi);
    }

    @Override
    @Async
    public void triggerUpdateNotification(ExecutionContext executionContext, GenericApiEntity indexableApi) {
        this.triggerNotification(executionContext, ApiHook.API_UPDATED, indexableApi);
    }

    @Override
    @Async
    public void triggerDeprecatedNotification(ExecutionContext executionContext, GenericApiEntity indexableApi) {
        this.triggerNotification(executionContext, ApiHook.API_DEPRECATED, indexableApi);
    }

    @Override
    @Async
    public void triggerDeployNotification(ExecutionContext executionContext, GenericApiEntity indexableApi) {
        this.triggerNotification(executionContext, ApiHook.API_DEPLOYED, indexableApi);
    }

    @Override
    @Async
    public void triggerStartNotification(ExecutionContext executionContext, GenericApiEntity indexableApi) {
        this.triggerNotification(executionContext, ApiHook.API_STARTED, indexableApi);
    }

    @Override
    @Async
    public void triggerStopNotification(ExecutionContext executionContext, GenericApiEntity indexableApi) {
        this.triggerNotification(executionContext, ApiHook.API_STOPPED, indexableApi);
    }

    private void triggerNotification(ExecutionContext executionContext, ApiHook hook, GenericApiEntity genericApiEntity) {
        String userId = this.getAuthenticatedUsername();
        if (userId != null && !this.getAuthenticatedUser().isSystem()) {
            UserEntity userEntity = this.userService.findById(executionContext, userId);
            this.notifierService.trigger(executionContext, hook, genericApiEntity.getId(), new NotificationParamsBuilder().api(genericApiEntity).user(userEntity).build());
        }
    }
}

