/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.VirtualHost;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Workflow;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.PropertiesEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowReferenceType;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.WorkflowType;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.api.UpdateApiEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.PlanService;
import io.gravitee.rest.api.service.WorkflowService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.ReferenceContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.converter.CategoryMapper;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiConverter.class);
    private ObjectMapper objectMapper;
    private PlanService planService;
    private FlowService flowService;
    private CategoryMapper categoryMapper;
    private ParameterService parameterService;
    private WorkflowService workflowService;

    public ApiConverter(ObjectMapper objectMapper, @Lazy PlanService planService, @Lazy FlowService flowService, CategoryMapper categoryMapper, ParameterService parameterService, WorkflowService workflowService) {
        this.objectMapper = objectMapper;
        this.planService = planService;
        this.flowService = flowService;
        this.categoryMapper = categoryMapper;
        this.parameterService = parameterService;
        this.workflowService = workflowService;
    }

    public ApiEntity toApiEntity(Api api, PrimaryOwnerEntity primaryOwnerEntity) {
        ApiLifecycleState lifecycleState;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setCrossId(api.getCrossId());
        apiEntity.setEnvironmentId(api.getEnvironmentId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        apiEntity.setGroups(api.getGroups());
        apiEntity.setDisableMembershipNotifications(api.isDisableMembershipNotifications());
        apiEntity.setReferenceType(ReferenceContext.Type.ENVIRONMENT.name());
        apiEntity.setReferenceId(api.getEnvironmentId());
        apiEntity.setCategories(this.categoryMapper.toCategoryKey(api.getEnvironmentId(), api.getCategories()));
        apiEntity.setDefinitionContext(new DefinitionContext(api.getOrigin(), api.getMode(), api.getSyncFrom()));
        if (api.getDefinition() != null) {
            try {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                if (apiDefinition.getDefinitionVersion() != null) {
                    apiEntity.setGraviteeDefinitionVersion(apiDefinition.getDefinitionVersion().getLabel());
                }
                if (apiDefinition.getExecutionMode() != null) {
                    apiEntity.setExecutionMode(apiDefinition.getExecutionMode());
                }
                if (apiDefinition.getFlowMode() != null) {
                    apiEntity.setFlowMode(apiDefinition.getFlowMode());
                }
                if (apiDefinition.getFlows() != null) {
                    apiEntity.setFlows(apiDefinition.getFlows());
                }
                if (apiDefinition.getProxy() != null && apiDefinition.getProxy().getVirtualHosts() != null && !apiDefinition.getProxy().getVirtualHosts().isEmpty()) {
                    apiEntity.setContextPath(((VirtualHost)apiDefinition.getProxy().getVirtualHosts().get(0)).getPath());
                }
                if (apiDefinition.getPathMappings() != null) {
                    apiEntity.setPathMappings(new HashSet(apiDefinition.getPathMappings().keySet()));
                }
                apiEntity.setResponseTemplates(apiDefinition.getResponseTemplates());
            }
            catch (IOException ioe) {
                LOGGER.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setLabels(api.getLabels());
        LifecycleState state = api.getLifecycleState();
        if (state != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)state.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        if ((lifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(io.gravitee.rest.api.model.api.ApiLifecycleState.valueOf((String)lifecycleState.name()));
        }
        if (primaryOwnerEntity != null) {
            apiEntity.setPrimaryOwner(primaryOwnerEntity);
        }
        return apiEntity;
    }

    public ApiEntity toApiEntity(ExecutionContext executionContext, Api api, PrimaryOwnerEntity primaryOwner, boolean readDatabaseFlows) {
        List<Workflow> workflows;
        ApiEntity apiEntity = this.toApiEntity(api, primaryOwner);
        if (apiEntity.getDefinitionContext() == null) {
            apiEntity.setDefinitionContext(new DefinitionContext("management", "fully_managed", "management".toUpperCase()));
        }
        Set<PlanEntity> plans = this.planService.findByApi(executionContext, api.getId());
        apiEntity.setPlans(plans);
        if (readDatabaseFlows) {
            List<Flow> flows = this.flowService.findByReference(FlowReferenceType.API, api.getId());
            apiEntity.setFlows(flows);
        }
        apiEntity.setCategories(this.categoryMapper.toCategoryKey(executionContext.getEnvironmentId(), api.getCategories()));
        if (this.parameterService.findAsBoolean(executionContext, Key.API_REVIEW_ENABLED, api.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT) && (workflows = this.workflowService.findByReferenceAndType(WorkflowReferenceType.API, api.getId(), WorkflowType.REVIEW)) != null && !workflows.isEmpty()) {
            apiEntity.setWorkflowState(WorkflowState.valueOf((String)workflows.get(0).getState()));
        }
        return apiEntity;
    }

    public UpdateApiEntity toUpdateApiEntity(ApiEntity apiEntity) {
        return this.toUpdateApiEntity(apiEntity, false);
    }

    public UpdateApiEntity toUpdateApiEntity(ApiEntity apiEntity, boolean resetCrossId) {
        UpdateApiEntity updateApiEntity = new UpdateApiEntity();
        updateApiEntity.setCrossId(resetCrossId ? null : apiEntity.getCrossId());
        updateApiEntity.setProxy(apiEntity.getProxy());
        updateApiEntity.setVersion(apiEntity.getVersion());
        updateApiEntity.setName(apiEntity.getName());
        updateApiEntity.setProperties(new PropertiesEntity(apiEntity.getProperties()));
        updateApiEntity.setDescription(apiEntity.getDescription());
        updateApiEntity.setGroups(apiEntity.getGroups());
        updateApiEntity.setPaths(apiEntity.getPaths());
        updateApiEntity.setPicture(apiEntity.getPicture());
        updateApiEntity.setBackground(apiEntity.getBackground());
        updateApiEntity.setResources(apiEntity.getResources());
        updateApiEntity.setTags(apiEntity.getTags());
        updateApiEntity.setServices(apiEntity.getServices());
        updateApiEntity.setVisibility(apiEntity.getVisibility());
        updateApiEntity.setLabels(apiEntity.getLabels());
        updateApiEntity.setPathMappings(apiEntity.getPathMappings());
        updateApiEntity.setLifecycleState(apiEntity.getLifecycleState());
        updateApiEntity.setPlans(apiEntity.getPlans());
        updateApiEntity.setFlows(apiEntity.getFlows());
        updateApiEntity.setGraviteeDefinitionVersion(apiEntity.getGraviteeDefinitionVersion());
        updateApiEntity.setFlowMode(apiEntity.getFlowMode());
        updateApiEntity.setResponseTemplates(apiEntity.getResponseTemplates());
        updateApiEntity.setCategories(apiEntity.getCategories());
        updateApiEntity.setDisableMembershipNotifications(apiEntity.isDisableMembershipNotifications());
        return updateApiEntity;
    }
}

