/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.alert.api.trigger.Trigger;
import io.gravitee.repository.management.model.AlertEventRule;
import io.gravitee.repository.management.model.AlertEventType;
import io.gravitee.repository.management.model.AlertTrigger;
import io.gravitee.rest.api.model.AlertEventRuleEntity;
import io.gravitee.rest.api.model.alert.AlertReferenceType;
import io.gravitee.rest.api.model.alert.AlertTriggerEntity;
import io.gravitee.rest.api.model.alert.AlertTriggerEntityWrapper;
import io.gravitee.rest.api.model.alert.NewAlertTriggerEntity;
import io.gravitee.rest.api.model.alert.UpdateAlertTriggerEntity;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AlertTriggerConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlertTriggerConverter.class);
    private ObjectMapper objectMapper;

    @Autowired
    public AlertTriggerConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public AlertTrigger toAlertTrigger(AlertTriggerEntity alertEntity) {
        AlertTrigger alert = new AlertTrigger();
        alert.setId(alertEntity.getId());
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setReferenceId(alertEntity.getReferenceId());
        alert.setReferenceType(alertEntity.getReferenceType().name());
        alert.setEnabled(alertEntity.isTemplate() || alertEntity.isEnabled());
        alert.setType(alertEntity.getType());
        alert.setSeverity(alertEntity.getSeverity().name());
        alert.setTemplate(alertEntity.isTemplate());
        alert.setParentId(alertEntity.getParentId());
        alert.setCreatedAt(alertEntity.getCreatedAt());
        alert.setEnvironmentId(alertEntity.getEnvironmentId());
        this.buildAlertTriggerEventRulesFromEntities(alert, alertEntity.getEventRules());
        this.buildAlertTriggerDefinitionFromEntity(alert, alertEntity);
        return alert;
    }

    public AlertTrigger toAlertTrigger(ExecutionContext executionContext, NewAlertTriggerEntity alertEntity) {
        AlertTrigger alert = new AlertTrigger();
        alert.setId(io.gravitee.common.utils.UUID.toString((UUID)io.gravitee.common.utils.UUID.random()));
        alertEntity.setId(alert.getId());
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setReferenceId(alertEntity.getReferenceId());
        alert.setReferenceType(alertEntity.getReferenceType().name());
        alert.setEnabled(alertEntity.isEnabled());
        alert.setType(alertEntity.getType());
        alert.setSeverity(alertEntity.getSeverity().name());
        alert.setTemplate(alertEntity.isTemplate());
        alert.setEnvironmentId(executionContext.getEnvironmentId());
        this.buildAlertTriggerEventRulesFromEntities(alert, alertEntity.getEventRules());
        this.buildAlertTriggerDefinitionFromEntity(alert, alertEntity);
        return alert;
    }

    private void buildAlertTriggerEventRulesFromEntities(AlertTrigger alert, List<AlertEventRuleEntity> eventRules) {
        if (eventRules != null && !eventRules.isEmpty()) {
            alert.setEventRules(eventRules.stream().map(alertEventRuleEntity -> new AlertEventRule(AlertEventType.valueOf((String)alertEventRuleEntity.getEvent().toUpperCase()))).collect(Collectors.toList()));
        }
    }

    public AlertTrigger toAlertTrigger(ExecutionContext executionContext, UpdateAlertTriggerEntity alertEntity) {
        AlertTrigger alert = new AlertTrigger();
        alert.setId(alertEntity.getId());
        alert.setName(alertEntity.getName());
        alert.setDescription(alertEntity.getDescription());
        alert.setEnabled(alertEntity.isEnabled());
        alert.setSeverity(alertEntity.getSeverity().name());
        alert.setEnvironmentId(executionContext.getEnvironmentId());
        alert.setEventRules(null);
        this.buildAlertTriggerEventRulesFromEntities(alert, alertEntity.getEventRules());
        this.buildAlertTriggerDefinitionFromEntity(alert, alertEntity);
        return alert;
    }

    public AlertTriggerEntity toAlertTriggerEntity(AlertTrigger alert) {
        try {
            Trigger trigger = (Trigger)this.objectMapper.readValue(alert.getDefinition(), Trigger.class);
            AlertTriggerEntityWrapper alertTriggerEntity = new AlertTriggerEntityWrapper(trigger);
            alertTriggerEntity.setDescription(alert.getDescription());
            alertTriggerEntity.setReferenceId(alert.getReferenceId());
            alertTriggerEntity.setReferenceType(AlertReferenceType.valueOf((String)alert.getReferenceType()));
            alertTriggerEntity.setCreatedAt(alert.getCreatedAt());
            alertTriggerEntity.setUpdatedAt(alert.getUpdatedAt());
            alertTriggerEntity.setType(alert.getType());
            if (alert.getSeverity() != null) {
                alertTriggerEntity.setSeverity(Trigger.Severity.valueOf((String)alert.getSeverity()));
            } else {
                alertTriggerEntity.setSeverity(Trigger.Severity.INFO);
            }
            alertTriggerEntity.setEnabled(alert.isEnabled());
            alertTriggerEntity.setTemplate(alert.isTemplate());
            alertTriggerEntity.setParentId(alert.getParentId());
            alertTriggerEntity.setEnvironmentId(alert.getEnvironmentId());
            if (alert.getEventRules() != null) {
                alertTriggerEntity.setEventRules(alert.getEventRules().stream().map(alertEventRule -> new AlertEventRuleEntity(alertEventRule.getEvent().name())).collect(Collectors.toList()));
            }
            return alertTriggerEntity;
        }
        catch (Exception ex) {
            LOGGER.error("An unexpected error occurs while transforming the alert trigger from its definition", (Throwable)ex);
            return null;
        }
    }

    public List<AlertTriggerEntity> toAlertTriggerEntities(List<AlertTrigger> alerts) {
        return alerts.stream().map(this::toAlertTriggerEntity).sorted(Comparator.comparing(alertTriggerEntity -> alertTriggerEntity != null ? alertTriggerEntity.getName() : null, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    private void buildAlertTriggerDefinitionFromEntity(AlertTrigger alertTrigger, Object alertEntity) {
        try {
            alertTrigger.setDefinition(this.objectMapper.writeValueAsString(alertEntity));
        }
        catch (Exception ex) {
            LOGGER.error("An unexpected error occurred while transforming the alert trigger definition into string", (Throwable)ex);
        }
    }
}

