/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.adapter;

import io.gravitee.apim.core.json.JsonDeserializer;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroup;
import io.gravitee.apim.core.shared_policy_group.model.SharedPolicyGroupDefinition;
import io.gravitee.apim.infra.adapter.GraviteeJacksonMapper;
import io.gravitee.repository.management.model.SharedPolicyGroupLifecycleState;
import java.io.IOException;
import org.mapstruct.AfterMapping;
import org.mapstruct.InjectionStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Named;
import org.mapstruct.NullValueMappingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(componentModel="spring", uses={JsonDeserializer.class, JsonDeserializer.class}, injectionStrategy=InjectionStrategy.FIELD, nullValueMappingStrategy=NullValueMappingStrategy.RETURN_NULL)
public abstract class SharedPolicyGroupAdapter {
    private final Logger LOGGER = LoggerFactory.getLogger(SharedPolicyGroupAdapter.class);

    public abstract SharedPolicyGroup toEntity(io.gravitee.repository.management.model.SharedPolicyGroup var1);

    @Mapping(target="definition", source=".", qualifiedByName={"serializeDefinition"})
    public abstract io.gravitee.repository.management.model.SharedPolicyGroup fromEntity(SharedPolicyGroup var1);

    public abstract SharedPolicyGroupLifecycleState fromEntity(SharedPolicyGroup.SharedPolicyGroupLifecycleState var1);

    @AfterMapping
    protected void addPolicyGroupDefinition(@MappingTarget SharedPolicyGroup result, io.gravitee.repository.management.model.SharedPolicyGroup sharedPolicyGroup) {
        String definition = sharedPolicyGroup.getDefinition();
        if (definition == null || definition.isEmpty()) {
            return;
        }
        try {
            SharedPolicyGroupDefinition sharedPolicyGroupDefinition = (SharedPolicyGroupDefinition)GraviteeJacksonMapper.getInstance().readValue(definition, SharedPolicyGroupDefinition.class);
            result.setSteps(sharedPolicyGroupDefinition.getSteps());
        }
        catch (IOException ioe) {
            this.LOGGER.error("Unexpected error while deserializing SharedPolicyGroup definition with id:" + result.getId(), (Throwable)ioe);
        }
    }

    @Named(value="serializeDefinition")
    public String serializeDefinition(SharedPolicyGroup sharedPolicyGroupEntity) {
        if (sharedPolicyGroupEntity == null) {
            return null;
        }
        try {
            SharedPolicyGroupDefinition sharedPolicyGroupDefinition = SharedPolicyGroupDefinition.builder().steps(sharedPolicyGroupEntity.getSteps()).build();
            return GraviteeJacksonMapper.getInstance().writeValueAsString((Object)sharedPolicyGroupDefinition);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected error while serializing SharedPolicyGroup definition with id:" + sharedPolicyGroupEntity.getId(), ioe);
        }
    }
}

