/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.membership.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.group.model.Group;
import io.gravitee.apim.core.group.query_service.GroupQueryService;
import io.gravitee.apim.core.membership.exception.NoPrimaryOwnerGroupForUserException;
import io.gravitee.apim.core.membership.model.Membership;
import io.gravitee.apim.core.membership.model.PrimaryOwnerEntity;
import io.gravitee.apim.core.membership.model.Role;
import io.gravitee.apim.core.membership.query_service.MembershipQueryService;
import io.gravitee.apim.core.membership.query_service.RoleQueryService;
import io.gravitee.apim.core.parameters.model.ParameterContext;
import io.gravitee.apim.core.parameters.query_service.ParametersQueryService;
import io.gravitee.apim.core.user.crud_service.UserCrudService;
import io.gravitee.apim.core.user.model.BaseUserEntity;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.gravitee.rest.api.service.common.ReferenceContext;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@DomainService
public class ApiPrimaryOwnerFactory {
    private final MembershipQueryService membershipQueryService;
    private final ParametersQueryService parametersQueryService;
    private final RoleQueryService roleQueryService;
    private final UserCrudService userCrudService;
    private final GroupQueryService groupQueryService;

    public ApiPrimaryOwnerFactory(GroupQueryService groupQueryService, MembershipQueryService membershipQueryService, ParametersQueryService parametersQueryService, RoleQueryService roleQueryService, UserCrudService userCrudService) {
        this.membershipQueryService = membershipQueryService;
        this.parametersQueryService = parametersQueryService;
        this.roleQueryService = roleQueryService;
        this.userCrudService = userCrudService;
        this.groupQueryService = groupQueryService;
    }

    public PrimaryOwnerEntity createForNewApi(String organizationId, String environmentId, String userId) {
        ApiPrimaryOwnerMode mode = ApiPrimaryOwnerMode.valueOf((String)this.parametersQueryService.findAsString(Key.API_PRIMARY_OWNER_MODE, new ParameterContext(environmentId, organizationId, ParameterReferenceType.ENVIRONMENT)));
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ApiPrimaryOwnerMode.HYBRID, ApiPrimaryOwnerMode.USER -> this.initUserPrimaryOwner(userId);
            case ApiPrimaryOwnerMode.GROUP -> this.initWithFirstGroupWhereUserIsPrimaryOwner(userId, organizationId);
        };
    }

    private PrimaryOwnerEntity initUserPrimaryOwner(String userId) {
        BaseUserEntity user = this.userCrudService.getBaseUser(userId);
        return new PrimaryOwnerEntity(user.getId(), user.getEmail(), user.displayName(), PrimaryOwnerEntity.Type.USER);
    }

    private PrimaryOwnerEntity initWithFirstGroupWhereUserIsPrimaryOwner(String userId, String organizationId) {
        Set<String> userGroupIds = this.membershipQueryService.findGroupsThatUserBelongsTo(userId).stream().map(Membership::getReferenceId).collect(Collectors.toSet());
        Optional<Group> group = this.groupQueryService.findByIds(userGroupIds).stream().filter(g -> g.getApiPrimaryOwner() != null && !g.getApiPrimaryOwner().isBlank()).findFirst();
        return (PrimaryOwnerEntity)group.flatMap(g -> this.membershipQueryService.findByReferenceAndRoleId(Membership.ReferenceType.GROUP, g.getId(), this.getApiPrimaryOwnerRole(organizationId).getId()).stream().findFirst().map(membership -> this.userCrudService.getBaseUser(membership.getMemberId())).map(user -> new PrimaryOwnerEntity(g.getId(), user.getEmail(), g.getName(), PrimaryOwnerEntity.Type.GROUP))).orElseThrow(() -> new NoPrimaryOwnerGroupForUserException(userId));
    }

    private Role getApiPrimaryOwnerRole(String organizationId) {
        return this.roleQueryService.getApiRole(SystemRole.PRIMARY_OWNER.name(), ReferenceContext.builder().referenceType(ReferenceContext.Type.ORGANIZATION).referenceId(organizationId).build());
    }
}

