/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.repository.exceptions.DuplicateKeyException;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EnvironmentRepository;
import io.gravitee.repository.management.api.MetadataRepository;
import io.gravitee.repository.management.model.Environment;
import io.gravitee.repository.management.model.Metadata;
import io.gravitee.repository.management.model.MetadataReferenceType;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class MetadataDefaultReferenceUpgrader
implements Upgrader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataDefaultReferenceUpgrader.class);
    EnvironmentRepository environmentRepository;
    MetadataRepository metadataRepository;

    public MetadataDefaultReferenceUpgrader(@Lazy EnvironmentRepository environmentRepository, @Lazy MetadataRepository metadataRepository) {
        this.environmentRepository = environmentRepository;
        this.metadataRepository = metadataRepository;
    }

    public boolean upgrade() {
        try {
            Set environments = this.environmentRepository.findAll();
            List metadataList = this.metadataRepository.findAll().stream().filter(metadata -> metadata.getReferenceId().equals("_")).flatMap(metadata -> this.migrateDefaultMetadataToEnvironments(environments, (Metadata)metadata)).toList();
            log.info("Migrating metadata: {} for environments {}", (Object)metadataList.size(), (Object)environments);
        }
        catch (Exception e) {
            log.error("Failed to apply {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    private Stream<Metadata> migrateDefaultMetadataToEnvironments(Set<Environment> environments, Metadata metadata) {
        Stream<Metadata> metadataStream = environments.stream().map(environment -> {
            Metadata metadataToCreate = this.duplicateMetadata((Environment)environment, metadata);
            try {
                return this.metadataRepository.create(metadataToCreate);
            }
            catch (DuplicateKeyException e) {
                log.warn("Failed to duplicate metadata {} to {}", new Object[]{metadata, environment, e});
                return metadataToCreate;
            }
            catch (TechnicalException e) {
                log.error("Failed to duplicate metadata {} to {}", new Object[]{metadata, environment, e});
                throw new TechnicalManagementException(e);
            }
        });
        try {
            this.metadataRepository.delete(metadata.getKey(), metadata.getReferenceId(), metadata.getReferenceType());
        }
        catch (TechnicalException e) {
            log.error("Failed to delete metadata {}", (Object)metadata, (Object)e);
            throw new TechnicalManagementException(e);
        }
        return metadataStream;
    }

    private Metadata duplicateMetadata(Environment environment, Metadata metadata) {
        return Metadata.builder().referenceId(environment.getId()).referenceType(MetadataReferenceType.ENVIRONMENT).name(metadata.getName()).key(metadata.getKey()).value(metadata.getValue()).createdAt(metadata.getCreatedAt()).updatedAt(metadata.getUpdatedAt()).format(metadata.getFormat()).build();
    }

    public int getOrder() {
        return 160;
    }
}

