/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.upgrade.upgrader;

import io.gravitee.apim.core.shared_policy_group.use_case.InitializeSharedPolicyGroupUseCase;
import io.gravitee.node.api.upgrader.Upgrader;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.OrganizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InitializeSharedPolicyGroupUpgrader
implements Upgrader {
    private final Logger logger = LoggerFactory.getLogger(InitializeSharedPolicyGroupUpgrader.class);
    @Autowired
    private InitializeSharedPolicyGroupUseCase initializeSharedPolicyGroupUseCase;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private OrganizationService organizationService;

    public boolean upgrade() {
        try {
            this.organizationService.findAll().forEach(organization -> this.environmentService.findByOrganization(organization.getId()).forEach(environment -> this.initializeSharedPolicyGroupUseCase.execute(InitializeSharedPolicyGroupUseCase.Input.builder().organizationId(organization.getId()).environmentId(environment.getId()).build())));
        }
        catch (Exception e) {
            this.logger.error("unable to apply upgrader {}", (Object)this.getClass().getSimpleName(), (Object)e);
            return false;
        }
        return true;
    }

    public int getOrder() {
        return 704;
    }
}

