/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.v4.impl.validation;

import io.gravitee.definition.model.Cors;
import io.gravitee.rest.api.service.exceptions.AllowOriginNotAllowedException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import io.gravitee.rest.api.service.v4.validation.CorsValidationService;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CorsValidationServiceImpl
extends TransactionalService
implements CorsValidationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CorsValidationServiceImpl.class);
    private static final Pattern CORS_REGEX_PATTERN = Pattern.compile("^((\\*)|(null)|(^(([^:\\/?#]+):)?(\\/\\/([^\\/?#]*))?))$");
    private static final String[] CORS_REGEX_CHARS = new String[]{"{", "[", "(", "*"};

    @Override
    public Cors validateAndSanitize(Cors cors) {
        Set accessControlAllowOrigin;
        log.debug("Check CORS Allow-origin format");
        if (cors != null && (accessControlAllowOrigin = cors.getAccessControlAllowOrigin()) != null && !accessControlAllowOrigin.isEmpty()) {
            for (String allowOriginItem : accessControlAllowOrigin) {
                if (CORS_REGEX_PATTERN.matcher(allowOriginItem).matches()) continue;
                if (StringUtils.indexOfAny((CharSequence)allowOriginItem, (CharSequence[])CORS_REGEX_CHARS) >= 0) {
                    try {
                        Pattern.compile(allowOriginItem);
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new AllowOriginNotAllowedException(allowOriginItem);
                    }
                }
                throw new AllowOriginNotAllowedException(allowOriginItem);
            }
        }
        return cors;
    }
}

