/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl.configuration.flow;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.FlowRepository;
import io.gravitee.repository.management.model.flow.FlowReferenceType;
import io.gravitee.rest.api.model.TagEntity;
import io.gravitee.rest.api.model.TagReferenceType;
import io.gravitee.rest.api.service.TagService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.configuration.flow.FlowService;
import io.gravitee.rest.api.service.converter.FlowConverter;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class FlowServiceImpl
extends AbstractService
implements FlowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FlowServiceImpl.class);
    @Lazy
    @Autowired
    private FlowRepository flowRepository;
    @Autowired
    private TagService tagService;
    @Autowired
    private FlowConverter flowConverter;

    private String getFileContent(String path) {
        try {
            InputStream resourceAsStream = this.getClass().getResourceAsStream(path);
            return IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying load flow configuration with path %s", path), e);
        }
    }

    @Override
    public String getConfigurationSchemaForm() {
        return this.getFileContent("/flow/configuration-schema-form.json");
    }

    @Override
    public String getApiFlowSchemaForm() {
        return this.getFileContent("/flow/api-flow-schema-form.json");
    }

    @Override
    public String getPlatformFlowSchemaForm(ExecutionContext executionContext) {
        log.debug("Get platform schema form");
        String fileContent = this.getFileContent("/flow/platform-flow-schema-form.json");
        List<TagEntity> tags = this.tagService.findByReference(executionContext.getOrganizationId(), TagReferenceType.ORGANIZATION);
        if (tags.size() > 0) {
            log.debug("Append {} tag(s) to platform schema form", (Object)tags.size());
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode jsonSchema = mapper.readTree(fileContent);
                ObjectNode consumers = (ObjectNode)jsonSchema.get("properties").get("consumers");
                ArrayNode enumNode = (ArrayNode)consumers.get("items").get("enum");
                HashMap titleMap = new HashMap();
                tags.forEach(tagEntity -> titleMap.put(tagEntity.getId(), tagEntity.getName()));
                titleMap.keySet().forEach(arg_0 -> ((ArrayNode)enumNode).add(arg_0));
                JsonNode titleMapNode = mapper.valueToTree(titleMap);
                ObjectNode xSchemaForm = mapper.createObjectNode();
                consumers.set("x-schema-form", (JsonNode)xSchemaForm);
                xSchemaForm.set("titleMap", titleMapNode);
                return jsonSchema.toPrettyString();
            }
            catch (JsonProcessingException ex) {
                throw new TechnicalManagementException(String.format("An error occurs while append tags to platform flow schema form. Tags:%s", tags), ex);
            }
        }
        return fileContent;
    }

    @Override
    public List<Flow> findByReference(FlowReferenceType flowReferenceType, String referenceId) {
        try {
            log.debug("Find flows by reference {} - {}", (Object)flowReferenceType, (Object)flowReferenceType);
            return this.flowRepository.findByReference(flowReferenceType, referenceId).stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(this.flowConverter::toDefinition).collect(Collectors.toList());
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while find flows by reference", ex);
        }
    }

    @Override
    public List<Flow> save(FlowReferenceType flowReferenceType, String referenceId, List<Flow> flows) {
        log.debug("Saving flows...");
        try {
            log.debug("Save flows for reference {},{}", (Object)flowReferenceType, (Object)referenceId);
            if (flows == null || flows.isEmpty()) {
                this.flowRepository.deleteByReferenceIdAndReferenceType(referenceId, flowReferenceType);
                return List.of();
            }
            Map dbFlowsById = this.flowRepository.findByReference(flowReferenceType, referenceId).stream().collect(Collectors.toMap(io.gravitee.repository.management.model.flow.Flow::getId, Function.identity()));
            Set flowIdsToSave = flows.stream().map(Flow::getId).filter(Objects::nonNull).collect(Collectors.toSet());
            for (String dbFlowId : dbFlowsById.keySet()) {
                if (flowIdsToSave.contains(dbFlowId)) continue;
                this.flowRepository.delete((Object)dbFlowId);
            }
            ArrayList savedFlows = new ArrayList();
            ArrayList toCreate = new ArrayList();
            ArrayList toUpdate = new ArrayList();
            IntStream.range(0, flows.size()).forEach(i -> {
                Flow flow = (Flow)flows.get(i);
                if (flow.getId() == null || !dbFlowsById.containsKey(flow.getId())) {
                    toCreate.add(this.flowConverter.toRepository(flow, flowReferenceType, referenceId, i));
                } else {
                    toUpdate.add(this.flowConverter.toRepositoryUpdate((io.gravitee.repository.management.model.flow.Flow)dbFlowsById.get(flow.getId()), flow, i));
                }
            });
            if (!toCreate.isEmpty()) {
                log.debug("Flows to create: {}", (Object)toCreate.size());
                savedFlows.addAll(this.flowRepository.createAll(toCreate));
            }
            if (!toUpdate.isEmpty()) {
                log.debug("Flows to update: {}", (Object)toUpdate.size());
                savedFlows.addAll(this.flowRepository.updateAll(toUpdate));
            }
            List<Flow> result = savedFlows.stream().sorted(Comparator.comparing(io.gravitee.repository.management.model.flow.Flow::getOrder)).map(this.flowConverter::toDefinition).collect(Collectors.toList());
            log.debug("Flows saved: {}!", (Object)result.size());
            return result;
        }
        catch (TechnicalException ex) {
            throw new TechnicalManagementException("An error occurs while save flows", ex);
        }
    }
}

