/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ApiHeaderRepository;
import io.gravitee.repository.management.model.ApiHeader;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.rest.api.model.api.header.ApiHeaderEntity;
import io.gravitee.rest.api.model.api.header.NewApiHeaderEntity;
import io.gravitee.rest.api.model.api.header.UpdateApiHeaderEntity;
import io.gravitee.rest.api.service.ApiHeaderService;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.ApiHeaderNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.impl.TransactionalService;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ApiHeaderServiceImpl
extends TransactionalService
implements ApiHeaderService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiHeaderServiceImpl.class);
    @Lazy
    @Autowired
    private ApiHeaderRepository apiHeaderRepository;
    @Autowired
    AuditService auditService;

    @Override
    public ApiHeaderEntity create(ExecutionContext executionContext, NewApiHeaderEntity newEntity) {
        try {
            int order = this.apiHeaderRepository.findAllByEnvironment(executionContext.getEnvironmentId()).size() + 1;
            ApiHeader apiHeader = new ApiHeader();
            apiHeader.setId(UuidString.generateRandom());
            apiHeader.setEnvironmentId(executionContext.getEnvironmentId());
            apiHeader.setName(newEntity.getName());
            apiHeader.setValue(newEntity.getValue());
            apiHeader.setOrder(order);
            apiHeader.setCreatedAt(new Date());
            apiHeader.setUpdatedAt(apiHeader.getCreatedAt());
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.API_HEADER, apiHeader.getId()), (Audit.AuditEvent)ApiHeader.AuditEvent.API_HEADER_CREATED, apiHeader.getCreatedAt(), null, apiHeader);
            return this.convert((ApiHeader)this.apiHeaderRepository.create((Object)apiHeader));
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to create a header %s", newEntity), e);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String apiHeaderId) {
        try {
            ApiHeader apiHeader = this.apiHeaderRepository.findById((Object)apiHeaderId).filter(header -> header.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new ApiHeaderNotFoundException(apiHeaderId));
            this.apiHeaderRepository.delete((Object)apiHeaderId);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.API_HEADER, apiHeaderId), (Audit.AuditEvent)ApiHeader.AuditEvent.API_HEADER_DELETED, new Date(), apiHeader, null);
            int currentOrder = 1;
            for (ApiHeaderEntity apiHeaderEntity : this.findAll(executionContext.getEnvironmentId())) {
                if (apiHeaderEntity.getOrder() != currentOrder) {
                    UpdateApiHeaderEntity updateEntity = this.convert(apiHeaderEntity);
                    updateEntity.setOrder(currentOrder);
                    this.update(executionContext, updateEntity);
                    break;
                }
                ++currentOrder;
            }
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to delete a header %s", apiHeaderId), e);
        }
    }

    @Override
    public ApiHeaderEntity update(ExecutionContext executionContext, UpdateApiHeaderEntity updateEntity) {
        try {
            ApiHeader apiHeader = this.apiHeaderRepository.findById((Object)updateEntity.getId()).filter(header -> header.getEnvironmentId().equalsIgnoreCase(executionContext.getEnvironmentId())).orElseThrow(() -> new ApiHeaderNotFoundException(updateEntity.getId()));
            ApiHeader updatedHeader = new ApiHeader(apiHeader);
            Date updatedAt = new Date();
            updatedHeader.setName(updateEntity.getName());
            updatedHeader.setValue(updateEntity.getValue());
            updatedHeader.setUpdatedAt(updatedAt);
            if (updatedHeader.getOrder() != updateEntity.getOrder()) {
                updatedHeader.setOrder(updateEntity.getOrder());
                this.reorderAndSave(executionContext.getEnvironmentId(), updatedHeader);
                return this.convert(updatedHeader);
            }
            ApiHeader header2 = (ApiHeader)this.apiHeaderRepository.update((Object)updatedHeader);
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.API_HEADER, header2.getId()), (Audit.AuditEvent)ApiHeader.AuditEvent.API_HEADER_UPDATED, header2.getUpdatedAt(), apiHeader, header2);
            return this.convert(header2);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to update header %s", updateEntity), e);
        }
    }

    @Override
    public List<ApiHeaderEntity> findAll(String environmentId) {
        try {
            return this.apiHeaderRepository.findAllByEnvironment(environmentId).stream().sorted(Comparator.comparingInt(ApiHeader::getOrder)).map(this::convert).collect(Collectors.toList());
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurs while trying to find all header for environment id: %s", environmentId), e);
        }
    }

    private void reorderAndSave(String environmentId, ApiHeader headerToReorder) throws TechnicalException {
        ApiHeader[] headers = (ApiHeader[])this.apiHeaderRepository.findAllByEnvironment(environmentId).stream().filter(h -> !Objects.equals(h.getId(), headerToReorder.getId())).sorted(Comparator.comparingInt(ApiHeader::getOrder)).toArray(ApiHeader[]::new);
        if (headerToReorder.getOrder() < 1) {
            headerToReorder.setOrder(1);
        } else if (headerToReorder.getOrder() > headers.length + 1) {
            headerToReorder.setOrder(headers.length + 1);
        }
        for (int i = 0; i < headers.length; ++i) {
            int newOrder;
            int n = newOrder = i + 1 < headerToReorder.getOrder() ? i + 1 : i + 2;
            if (headers[i].getOrder() == newOrder) continue;
            headers[i].setOrder(newOrder);
            this.apiHeaderRepository.update((Object)headers[i]);
        }
        this.apiHeaderRepository.update((Object)headerToReorder);
    }

    @Override
    public void initialize(ExecutionContext executionContext) {
        NewApiHeaderEntity h = new NewApiHeaderEntity();
        h.setName("api.version");
        h.setValue("${api.version}");
        this.create(executionContext, h);
        h.setName("api.owner");
        h.setValue("${api.primaryOwner.displayName}");
        this.create(executionContext, h);
        h.setName("api.publishedAt");
        h.setValue("${(api.deployedAt?date)!}");
        this.create(executionContext, h);
    }

    private ApiHeaderEntity convert(ApiHeader apiHeader) {
        ApiHeaderEntity entity = new ApiHeaderEntity();
        entity.setId(apiHeader.getId());
        entity.setName(apiHeader.getName());
        entity.setValue(apiHeader.getValue());
        entity.setOrder(apiHeader.getOrder());
        entity.setCreatedAt(apiHeader.getCreatedAt());
        entity.setUpdatedAt(apiHeader.getUpdatedAt());
        return entity;
    }

    private UpdateApiHeaderEntity convert(ApiHeaderEntity entity) {
        UpdateApiHeaderEntity updateApiHeaderEntity = new UpdateApiHeaderEntity();
        updateApiHeaderEntity.setId(entity.getId());
        updateApiHeaderEntity.setName(entity.getName());
        updateApiHeaderEntity.setOrder(entity.getOrder());
        updateApiHeaderEntity.setValue(entity.getValue());
        return updateApiHeaderEntity;
    }
}

