/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.crud_service.documentation;

import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.exception.ApiPageNotDeletedException;
import io.gravitee.apim.core.documentation.model.Page;
import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.infra.adapter.PageAdapter;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.PageRepository;
import io.gravitee.rest.api.service.exceptions.PageNotFoundException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import java.util.Collection;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class PageCrudServiceImpl
implements PageCrudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PageCrudServiceImpl.class);
    private final PageRepository pageRepository;

    public PageCrudServiceImpl(@Lazy PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }

    @Override
    public Page createDocumentationPage(Page page) {
        io.gravitee.repository.management.model.Page createdDocumentation = this.createDocumentation(PageAdapter.INSTANCE.toRepository(page));
        return PageAdapter.INSTANCE.toEntity(createdDocumentation);
    }

    @Override
    public Page updateDocumentationPage(Page pageToUpdate) {
        try {
            io.gravitee.repository.management.model.Page updatedPage = this.pageRepository.update(PageAdapter.INSTANCE.toRepository(pageToUpdate));
            return PageAdapter.INSTANCE.toEntity(updatedPage);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while updating page %s.", pageToUpdate), e);
        }
    }

    @Override
    public Page get(String id) {
        return this.findById(id).orElseThrow(() -> new PageNotFoundException(id));
    }

    @Override
    public Optional<Page> findById(String id) {
        try {
            return this.pageRepository.findById(id).map(PageAdapter.INSTANCE::toEntity);
        }
        catch (TechnicalException e) {
            log.error("An error occurred while trying to find Page by id {}", (Object)id, (Object)e);
            return Optional.empty();
        }
    }

    @Override
    public void delete(String id) {
        try {
            this.pageRepository.delete(id);
        }
        catch (TechnicalException e) {
            throw new ApiPageNotDeletedException(String.format("An error occurred while trying to delete Page by id %s", id), (Exception)((Object)e));
        }
    }

    @Override
    public void unsetHomepage(Collection<String> ids) {
        try {
            this.pageRepository.unsetHomepage(ids);
        }
        catch (TechnicalException e) {
            throw new TechnicalManagementException(String.format("An error occurred while trying to unset homepage for Page ids %s", ids), e);
        }
    }

    private io.gravitee.repository.management.model.Page createDocumentation(io.gravitee.repository.management.model.Page page) {
        try {
            return this.pageRepository.create(page);
        }
        catch (TechnicalException e) {
            throw new TechnicalDomainException(String.format("An error occurred while creating Page %s with id %s", page.getName(), page.getId()), e);
        }
    }
}

