/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.scoring.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.scoring.crud_service.ScoringReportCrudService;
import io.gravitee.apim.core.scoring.domain_service.ScoreComputingDomainService;
import io.gravitee.apim.core.scoring.model.ScoringReport;
import io.gravitee.common.utils.TimeProvider;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class SaveScoringResponseUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaveScoringResponseUseCase.class);
    private final AsyncJobCrudService asyncJobCrudService;
    private final ScoringReportCrudService scoringReportCrudService;
    private final ScoreComputingDomainService scoreComputingDomainService;

    public Completable execute(Input input) {
        return Maybe.defer(() -> Maybe.fromOptional(this.asyncJobCrudService.findById(input.jobId))).subscribeOn(Schedulers.computation()).flatMapCompletable(job -> {
            String apiId = job.getSourceId();
            String environmentId = job.getEnvironmentId();
            ScoringReport report = ScoringReport.builder().id(job.getId()).apiId(apiId).environmentId(environmentId).createdAt(TimeProvider.now()).summary(this.processSummary(input.analyzedAssets)).assets(input.analyzedAssets).build();
            return Completable.fromRunnable(() -> this.scoringReportCrudService.deleteByApi(apiId)).andThen((CompletableSource)Completable.fromRunnable(() -> this.scoringReportCrudService.create(report))).doOnComplete(() -> this.asyncJobCrudService.update(job.complete())).doOnError(throwable -> log.error("Fail to save scoring report for API [{}]", (Object)apiId, throwable));
        }).onErrorComplete();
    }

    private ScoringReport.Summary processSummary(List<ScoringReport.Asset> assets) {
        ArrayList<ScoringReport.Summary> assetsSummary = new ArrayList<ScoringReport.Summary>();
        for (ScoringReport.Asset asset : assets) {
            Map<ScoringReport.Severity, Long> counters = asset.diagnostics().stream().collect(Collectors.groupingBy(ScoringReport.Diagnostic::severity, Collectors.counting()));
            Long nbErrors = counters.getOrDefault((Object)ScoringReport.Severity.ERROR, 0L);
            Long nbWarnings = counters.getOrDefault((Object)ScoringReport.Severity.WARN, 0L);
            Long nbInfos = counters.getOrDefault((Object)ScoringReport.Severity.INFO, 0L);
            Long nbHints = counters.getOrDefault((Object)ScoringReport.Severity.HINT, 0L);
            assetsSummary.add(new ScoringReport.Summary(this.scoreComputingDomainService.computeScore(nbErrors, nbWarnings, nbInfos, nbHints), nbErrors, nbWarnings, nbInfos, nbHints));
        }
        BigDecimal averageScore = BigDecimal.valueOf(assetsSummary.stream().filter(summary -> summary.score() != null).mapToDouble(ScoringReport.Summary::score).average().orElse(0.0)).setScale(2, RoundingMode.HALF_EVEN);
        return assetsSummary.stream().reduce(new ScoringReport.Summary(averageScore.doubleValue(), 0L, 0L, 0L, 0L), (s1, s2) -> new ScoringReport.Summary(averageScore.doubleValue(), s1.errors() + s2.errors(), s1.warnings() + s2.warnings(), s1.infos() + s2.infos(), s1.hints() + s2.hints()));
    }

    @Generated
    public SaveScoringResponseUseCase(AsyncJobCrudService asyncJobCrudService, ScoringReportCrudService scoringReportCrudService, ScoreComputingDomainService scoreComputingDomainService) {
        this.asyncJobCrudService = asyncJobCrudService;
        this.scoringReportCrudService = scoringReportCrudService;
        this.scoreComputingDomainService = scoreComputingDomainService;
    }

    public record Input(String jobId, List<ScoringReport.Asset> analyzedAssets) {
    }
}

