/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.async_job.crud_service.AsyncJobCrudService;
import io.gravitee.apim.core.async_job.model.AsyncJob;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import io.reactivex.rxjava3.core.Single;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class StartIngestIntegrationApisUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartIngestIntegrationApisUseCase.class);
    private final IntegrationCrudService integrationCrudService;
    private final AsyncJobCrudService asyncJobCrudService;
    private final IntegrationAgent integrationAgent;
    private final LicenseDomainService licenseDomainService;

    public Single<AsyncJob.Status> execute(Input input) {
        AuditInfo auditInfo = input.auditInfo;
        String integrationId = input.integrationId;
        String organizationId = auditInfo.organizationId();
        String environmentId = auditInfo.environmentId();
        if (!this.licenseDomainService.isFederationFeatureAllowed(organizationId)) {
            return Single.error((Throwable)NotAllowedDomainException.noLicenseForFederation());
        }
        return Single.fromCallable(() -> this.integrationCrudService.findById(integrationId).filter(integration -> integration.getEnvironmentId().equals(environmentId)).orElseThrow(() -> new IntegrationNotFoundException(integrationId))).flatMap(integration -> this.integrationAgent.startIngest(integration.getId(), UuidString.generateRandom(), input.apiIds()).map(ingestStarted -> {
            log.info("Ingestion started for integration {}", (Object)integration.getId());
            if (ingestStarted.total() == 0L) {
                log.info("No APIs to ingest for integration {}", (Object)integration.getId());
                return AsyncJob.Status.SUCCESS;
            }
            this.asyncJobCrudService.create(this.newIngestJob(ingestStarted.ingestJobId(), (Integration)integration, auditInfo.actor().userId(), ingestStarted.total()));
            return AsyncJob.Status.PENDING;
        })).doOnError(throwable -> log.error("Error to start ingest {}", (Object)integrationId, throwable));
    }

    public AsyncJob newIngestJob(String id, Integration integration, String initiatorId, Long total) {
        ZonedDateTime now = TimeProvider.now();
        return AsyncJob.builder().id(id).sourceId(integration.getId()).environmentId(integration.getEnvironmentId()).initiatorId(initiatorId).type(AsyncJob.Type.FEDERATED_APIS_INGESTION).status(AsyncJob.Status.PENDING).upperLimit(total).createdAt(now).updatedAt(now).build();
    }

    @Generated
    public StartIngestIntegrationApisUseCase(IntegrationCrudService integrationCrudService, AsyncJobCrudService asyncJobCrudService, IntegrationAgent integrationAgent, LicenseDomainService licenseDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.asyncJobCrudService = asyncJobCrudService;
        this.integrationAgent = integrationAgent;
        this.licenseDomainService = licenseDomainService;
    }

    public record Input(String integrationId, List<String> apiIds, AuditInfo auditInfo) {
    }
}

