/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.documentation.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.crud_service.ApiCrudService;
import io.gravitee.apim.core.api.model.Api;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.documentation.crud_service.PageCrudService;
import io.gravitee.apim.core.documentation.domain_service.ApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.domain_service.DocumentationValidationDomainService;
import io.gravitee.apim.core.documentation.domain_service.UpdateApiDocumentationDomainService;
import io.gravitee.apim.core.documentation.exception.ApiPageSourceNotDefinedException;
import io.gravitee.apim.core.documentation.model.Page;
import java.util.Date;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class ApiUpdateFetchedPageContentUseCase {
    private final ApiDocumentationDomainService apiDocumentationDomainService;
    private final ApiCrudService apiCrudService;
    private final PageCrudService pageCrudService;
    private final DocumentationValidationDomainService documentationValidationDomainService;
    private final UpdateApiDocumentationDomainService updateApiDocumentationDomainService;

    public Output execute(Input input) {
        Api api = this.apiCrudService.get(input.apiId);
        Page oldPage = this.pageCrudService.get(input.pageId);
        this.apiDocumentationDomainService.validatePageAssociatedToApi(oldPage, api.getId());
        if (Objects.isNull(oldPage.getSource())) {
            throw new ApiPageSourceNotDefinedException(oldPage.getId(), oldPage.getReferenceId());
        }
        Page pageToUpdate = this.documentationValidationDomainService.validateAndSanitizeForUpdate(oldPage, input.auditInfo.organizationId(), false);
        if (Objects.equals(pageToUpdate.getContent(), oldPage.getContent())) {
            return new Output(oldPage);
        }
        Page updatedPage = this.updateApiDocumentationDomainService.updatePage(pageToUpdate.toBuilder().updatedAt(new Date()).build(), oldPage, input.auditInfo);
        return new Output(updatedPage);
    }

    @Generated
    public ApiUpdateFetchedPageContentUseCase(ApiDocumentationDomainService apiDocumentationDomainService, ApiCrudService apiCrudService, PageCrudService pageCrudService, DocumentationValidationDomainService documentationValidationDomainService, UpdateApiDocumentationDomainService updateApiDocumentationDomainService) {
        this.apiDocumentationDomainService = apiDocumentationDomainService;
        this.apiCrudService = apiCrudService;
        this.pageCrudService = pageCrudService;
        this.documentationValidationDomainService = documentationValidationDomainService;
        this.updateApiDocumentationDomainService = updateApiDocumentationDomainService;
    }

    public record Input(String pageId, String apiId, AuditInfo auditInfo) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String pageId;
            @Generated
            private String apiId;
            @Generated
            private AuditInfo auditInfo;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder pageId(String pageId) {
                this.pageId = pageId;
                return this;
            }

            @Generated
            public InputBuilder apiId(String apiId) {
                this.apiId = apiId;
                return this;
            }

            @Generated
            public InputBuilder auditInfo(AuditInfo auditInfo) {
                this.auditInfo = auditInfo;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.pageId, this.apiId, this.auditInfo);
            }

            @Generated
            public String toString() {
                return "ApiUpdateFetchedPageContentUseCase.Input.InputBuilder(pageId=" + this.pageId + ", apiId=" + this.apiId + ", auditInfo=" + this.auditInfo + ")";
            }
        }
    }

    public record Output(Page page) {
    }
}

