/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_key.model;

import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import io.gravitee.rest.api.service.exceptions.SubscriptionClosedException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class ApiKeyEntity {
    private String id;
    private String key;
    private String applicationId;
    private List<String> subscriptions = new ArrayList<String>();
    private String environmentId;
    private ZonedDateTime expireAt;
    private ZonedDateTime createdAt;
    private ZonedDateTime updatedAt;
    private boolean revoked;
    private ZonedDateTime revokedAt;
    private boolean paused;
    private boolean federated;
    private Integer daysToExpirationOnLastNotification;

    public static ApiKeyEntity generateForSubscription(SubscriptionEntity subscription, String customApiKey) {
        if (customApiKey == null) {
            throw new IllegalArgumentException("Custom api key cannot be null");
        }
        return ApiKeyEntity.generateForSubscription(subscription, customApiKey, false);
    }

    public static ApiKeyEntity generateForFederatedSubscription(SubscriptionEntity subscription, String apiKey) {
        if (apiKey == null) {
            throw new IllegalArgumentException("API Key cannot be null");
        }
        return ApiKeyEntity.generateForSubscription(subscription, apiKey, true);
    }

    public static ApiKeyEntity generateForSubscription(SubscriptionEntity subscription) {
        return ApiKeyEntity.generateForSubscription(subscription, UuidString.generateRandom(), false);
    }

    public ApiKeyEntity addSubscription(String subscriptionId) {
        ArrayList<String> list = new ArrayList<String>(this.subscriptions);
        list.add(subscriptionId);
        return this.toBuilder().subscriptions(list).updatedAt(TimeProvider.now()).build();
    }

    public ApiKeyEntity revoke() {
        ZonedDateTime now = ZonedDateTime.now();
        return this.toBuilder().revoked(true).updatedAt(now).revokedAt(now).build();
    }

    public boolean isExpired() {
        return this.expireAt != null && ZonedDateTime.now().isAfter(this.getExpireAt());
    }

    public boolean canBeRevoked() {
        return !this.isRevoked() && !this.isExpired();
    }

    public boolean hasSubscription(String subscriptionId) {
        return this.subscriptions.contains(subscriptionId);
    }

    private static ApiKeyEntity generateForSubscription(SubscriptionEntity subscription, String customApiKey, boolean federated) {
        ZonedDateTime now = TimeProvider.now();
        if (subscription.getEndingAt() != null && subscription.getEndingAt().isBefore(now)) {
            throw new SubscriptionClosedException(subscription.getId());
        }
        return ApiKeyEntity.builder().id(UuidString.generateRandom()).applicationId(subscription.getApplicationId()).createdAt(now).updatedAt(now).key(customApiKey).subscriptions(List.of(subscription.getId())).environmentId(subscription.getEnvironmentId()).expireAt(subscription.getEndingAt()).federated(federated).build();
    }

    @Generated
    public static ApiKeyEntityBuilder builder() {
        return new ApiKeyEntityBuilder();
    }

    @Generated
    public ApiKeyEntityBuilder toBuilder() {
        return new ApiKeyEntityBuilder().id(this.id).key(this.key).applicationId(this.applicationId).subscriptions(this.subscriptions).environmentId(this.environmentId).expireAt(this.expireAt).createdAt(this.createdAt).updatedAt(this.updatedAt).revoked(this.revoked).revokedAt(this.revokedAt).paused(this.paused).federated(this.federated).daysToExpirationOnLastNotification(this.daysToExpirationOnLastNotification);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getApplicationId() {
        return this.applicationId;
    }

    @Generated
    public List<String> getSubscriptions() {
        return this.subscriptions;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public ZonedDateTime getExpireAt() {
        return this.expireAt;
    }

    @Generated
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public ZonedDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public boolean isRevoked() {
        return this.revoked;
    }

    @Generated
    public ZonedDateTime getRevokedAt() {
        return this.revokedAt;
    }

    @Generated
    public boolean isPaused() {
        return this.paused;
    }

    @Generated
    public boolean isFederated() {
        return this.federated;
    }

    @Generated
    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Generated
    public void setSubscriptions(List<String> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setExpireAt(ZonedDateTime expireAt) {
        this.expireAt = expireAt;
    }

    @Generated
    public void setCreatedAt(ZonedDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(ZonedDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    @Generated
    public void setRevokedAt(ZonedDateTime revokedAt) {
        this.revokedAt = revokedAt;
    }

    @Generated
    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    @Generated
    public void setFederated(boolean federated) {
        this.federated = federated;
    }

    @Generated
    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiKeyEntity)) {
            return false;
        }
        ApiKeyEntity other = (ApiKeyEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRevoked() != other.isRevoked()) {
            return false;
        }
        if (this.isPaused() != other.isPaused()) {
            return false;
        }
        if (this.isFederated() != other.isFederated()) {
            return false;
        }
        Integer this$daysToExpirationOnLastNotification = this.getDaysToExpirationOnLastNotification();
        Integer other$daysToExpirationOnLastNotification = other.getDaysToExpirationOnLastNotification();
        if (this$daysToExpirationOnLastNotification == null ? other$daysToExpirationOnLastNotification != null : !((Object)this$daysToExpirationOnLastNotification).equals(other$daysToExpirationOnLastNotification)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        List<String> this$subscriptions = this.getSubscriptions();
        List<String> other$subscriptions = other.getSubscriptions();
        if (this$subscriptions == null ? other$subscriptions != null : !((Object)this$subscriptions).equals(other$subscriptions)) {
            return false;
        }
        String this$environmentId = this.getEnvironmentId();
        String other$environmentId = other.getEnvironmentId();
        if (this$environmentId == null ? other$environmentId != null : !this$environmentId.equals(other$environmentId)) {
            return false;
        }
        ZonedDateTime this$expireAt = this.getExpireAt();
        ZonedDateTime other$expireAt = other.getExpireAt();
        if (this$expireAt == null ? other$expireAt != null : !((Object)this$expireAt).equals(other$expireAt)) {
            return false;
        }
        ZonedDateTime this$createdAt = this.getCreatedAt();
        ZonedDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        ZonedDateTime this$updatedAt = this.getUpdatedAt();
        ZonedDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        ZonedDateTime this$revokedAt = this.getRevokedAt();
        ZonedDateTime other$revokedAt = other.getRevokedAt();
        return !(this$revokedAt == null ? other$revokedAt != null : !((Object)this$revokedAt).equals(other$revokedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiKeyEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRevoked() ? 79 : 97);
        result = result * 59 + (this.isPaused() ? 79 : 97);
        result = result * 59 + (this.isFederated() ? 79 : 97);
        Integer $daysToExpirationOnLastNotification = this.getDaysToExpirationOnLastNotification();
        result = result * 59 + ($daysToExpirationOnLastNotification == null ? 43 : ((Object)$daysToExpirationOnLastNotification).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        List<String> $subscriptions = this.getSubscriptions();
        result = result * 59 + ($subscriptions == null ? 43 : ((Object)$subscriptions).hashCode());
        String $environmentId = this.getEnvironmentId();
        result = result * 59 + ($environmentId == null ? 43 : $environmentId.hashCode());
        ZonedDateTime $expireAt = this.getExpireAt();
        result = result * 59 + ($expireAt == null ? 43 : ((Object)$expireAt).hashCode());
        ZonedDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        ZonedDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        ZonedDateTime $revokedAt = this.getRevokedAt();
        result = result * 59 + ($revokedAt == null ? 43 : ((Object)$revokedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ApiKeyEntity(id=" + this.getId() + ", key=" + this.getKey() + ", applicationId=" + this.getApplicationId() + ", subscriptions=" + this.getSubscriptions() + ", environmentId=" + this.getEnvironmentId() + ", expireAt=" + this.getExpireAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", revoked=" + this.isRevoked() + ", revokedAt=" + this.getRevokedAt() + ", paused=" + this.isPaused() + ", federated=" + this.isFederated() + ", daysToExpirationOnLastNotification=" + this.getDaysToExpirationOnLastNotification() + ")";
    }

    @Generated
    public ApiKeyEntity(String id, String key, String applicationId, List<String> subscriptions, String environmentId, ZonedDateTime expireAt, ZonedDateTime createdAt, ZonedDateTime updatedAt, boolean revoked, ZonedDateTime revokedAt, boolean paused, boolean federated, Integer daysToExpirationOnLastNotification) {
        this.id = id;
        this.key = key;
        this.applicationId = applicationId;
        this.subscriptions = subscriptions;
        this.environmentId = environmentId;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.revoked = revoked;
        this.revokedAt = revokedAt;
        this.paused = paused;
        this.federated = federated;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public ApiKeyEntity() {
    }

    @Generated
    public static class ApiKeyEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String key;
        @Generated
        private String applicationId;
        @Generated
        private List<String> subscriptions;
        @Generated
        private String environmentId;
        @Generated
        private ZonedDateTime expireAt;
        @Generated
        private ZonedDateTime createdAt;
        @Generated
        private ZonedDateTime updatedAt;
        @Generated
        private boolean revoked;
        @Generated
        private ZonedDateTime revokedAt;
        @Generated
        private boolean paused;
        @Generated
        private boolean federated;
        @Generated
        private Integer daysToExpirationOnLastNotification;

        @Generated
        ApiKeyEntityBuilder() {
        }

        @Generated
        public ApiKeyEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder subscriptions(List<String> subscriptions) {
            this.subscriptions = subscriptions;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder expireAt(ZonedDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder createdAt(ZonedDateTime createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder updatedAt(ZonedDateTime updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder revokedAt(ZonedDateTime revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder federated(boolean federated) {
            this.federated = federated;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public ApiKeyEntity build() {
            return new ApiKeyEntity(this.id, this.key, this.applicationId, this.subscriptions, this.environmentId, this.expireAt, this.createdAt, this.updatedAt, this.revoked, this.revokedAt, this.paused, this.federated, this.daysToExpirationOnLastNotification);
        }

        @Generated
        public String toString() {
            return "ApiKeyEntity.ApiKeyEntityBuilder(id=" + this.id + ", key=" + this.key + ", applicationId=" + this.applicationId + ", subscriptions=" + this.subscriptions + ", environmentId=" + this.environmentId + ", expireAt=" + this.expireAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", revoked=" + this.revoked + ", revokedAt=" + this.revokedAt + ", paused=" + this.paused + ", federated=" + this.federated + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ")";
        }
    }
}

