/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.plan.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.plan.crud_service.PlanCrudService;
import io.gravitee.apim.core.plan.model.Plan;
import io.gravitee.apim.core.plan.query_service.PlanQueryService;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

@DomainService
public class ReorderPlanDomainService {
    private final PlanQueryService planQueryService;
    private final PlanCrudService planCrudService;

    public ReorderPlanDomainService(PlanQueryService planQueryService, PlanCrudService planCrudService) {
        this.planQueryService = planQueryService;
        this.planCrudService = planCrudService;
    }

    public Plan reorderAfterUpdate(Plan toUpdate) {
        List<Plan> toReorder = this.planQueryService.findAllByApiId(toUpdate.getApiId()).stream().filter(p -> p.isPublished() && !Objects.equals(p.getId(), toUpdate.getId())).sorted(Comparator.comparingInt(Plan::getOrder)).toList();
        if (toUpdate.getOrder() < 1) {
            toUpdate.setOrder(1);
        } else if (toUpdate.getOrder() > toReorder.size() + 1) {
            toUpdate.setOrder(toReorder.size() + 1);
        }
        for (int i = 0; i < toReorder.size(); ++i) {
            int newOrder = i + 1 < toUpdate.getOrder() ? i + 1 : i + 2;
            Plan planToReorder = toReorder.get(i);
            if (planToReorder.getOrder() == newOrder) continue;
            this.planCrudService.update((Plan)((Plan.PlanBuilder)planToReorder.toBuilder().order(newOrder)).build());
        }
        return this.planCrudService.update(toUpdate);
    }

    public void refreshOrderAfterDelete(String apiId) {
        List<Plan> toReorder = this.planQueryService.findAllByApiId(apiId).stream().filter(Plan::isPublished).sorted(Comparator.comparingInt(Plan::getOrder)).toList();
        for (int i = 0; i < toReorder.size(); ++i) {
            int expectedOrder = i + 1;
            Plan planToReorder = toReorder.get(i);
            if (planToReorder.getOrder() == expectedOrder) continue;
            this.planCrudService.update((Plan)((Plan.PlanBuilder)planToReorder.toBuilder().order(expectedOrder)).build());
        }
    }
}

