/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.api.model.ApiFieldFilter;
import io.gravitee.apim.core.api.model.ApiSearchCriteria;
import io.gravitee.apim.core.api.query_service.ApiQueryService;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.exception.AssociatedApisFoundException;
import io.gravitee.apim.core.integration.exception.IntegrationNotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseCase
public class DeleteIntegrationUseCase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteIntegrationUseCase.class);
    IntegrationCrudService integrationCrudService;
    ApiQueryService apiQueryService;

    public DeleteIntegrationUseCase(IntegrationCrudService integrationCrudService, ApiQueryService apiQueryService) {
        this.integrationCrudService = integrationCrudService;
        this.apiQueryService = apiQueryService;
    }

    public void execute(Input input) {
        this.apiQueryService.search(ApiSearchCriteria.builder().integrationId(input.integrationId).build(), null, ApiFieldFilter.builder().pictureExcluded(true).definitionExcluded(true).build()).findAny().ifPresentOrElse(api -> {
            throw new AssociatedApisFoundException(input.integrationId);
        }, () -> this.integrationCrudService.findById(input.integrationId).ifPresentOrElse(integration -> this.integrationCrudService.delete(integration.getId()), () -> {
            throw new IntegrationNotFoundException(input.integrationId);
        }));
    }

    public record Input(String integrationId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private String integrationId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integrationId(String integrationId) {
                this.integrationId = integrationId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integrationId);
            }

            @Generated
            public String toString() {
                return "DeleteIntegrationUseCase.Input.InputBuilder(integrationId=" + this.integrationId + ")";
            }
        }
    }
}

