/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api_key.domain_service;

import io.gravitee.apim.core.DomainService;
import io.gravitee.apim.core.api_key.crud_service.ApiKeyCrudService;
import io.gravitee.apim.core.api_key.model.ApiKeyEntity;
import io.gravitee.apim.core.api_key.query_service.ApiKeyQueryService;
import io.gravitee.apim.core.application.crud_service.ApplicationCrudService;
import io.gravitee.apim.core.audit.domain_service.AuditDomainService;
import io.gravitee.apim.core.audit.model.ApiAuditLogEntity;
import io.gravitee.apim.core.audit.model.AuditInfo;
import io.gravitee.apim.core.audit.model.AuditProperties;
import io.gravitee.apim.core.audit.model.event.ApiKeyAuditEvent;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.gravitee.rest.api.service.exceptions.ApiKeyAlreadyExistingException;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DomainService
public class GenerateApiKeyDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenerateApiKeyDomainService.class);
    private final ApiKeyCrudService apiKeyCrudService;
    private final ApiKeyQueryService apiKeyQueryService;
    private final ApplicationCrudService applicationCrudService;
    private final AuditDomainService auditService;

    public ApiKeyEntity generate(SubscriptionEntity subscription, AuditInfo auditInfo, String customApiKey) {
        BaseApplicationEntity app = this.applicationCrudService.findById(subscription.getApplicationId(), auditInfo.environmentId());
        return this.generate(subscription, app, auditInfo, customApiKey, false);
    }

    public ApiKeyEntity generateForFederated(SubscriptionEntity subscription, AuditInfo auditInfo, String customApiKey) {
        BaseApplicationEntity app = this.applicationCrudService.findById(subscription.getApplicationId(), auditInfo.environmentId());
        return this.generate(subscription, app, auditInfo, customApiKey, true);
    }

    private ApiKeyEntity generate(SubscriptionEntity subscription, BaseApplicationEntity application, AuditInfo auditInfo, String apiKeyValue, boolean federated) {
        if (!application.hasApiKeySharedMode()) {
            return this.generate(auditInfo, subscription, apiKeyValue, federated);
        }
        return this.findOrGenerate(auditInfo, application, subscription, apiKeyValue, federated);
    }

    private ApiKeyEntity generate(AuditInfo auditInfo, SubscriptionEntity subscription, String apiKeyValue, boolean federated) {
        log.debug("Generate an API Key for subscription {}", (Object)subscription);
        ApiKeyEntity apiKey = this.generateForSubscription(subscription, apiKeyValue, federated);
        this.apiKeyCrudService.create(apiKey);
        this.createAuditLog(apiKey, subscription, auditInfo);
        return apiKey;
    }

    private ApiKeyEntity generateForSubscription(SubscriptionEntity subscription, String customApiKey, boolean federated) {
        if (federated) {
            return ApiKeyEntity.generateForFederatedSubscription(subscription, customApiKey);
        }
        if (Objects.nonNull(customApiKey) && !customApiKey.isEmpty()) {
            if (!this.isKeyExistFor(customApiKey, subscription)) {
                throw new ApiKeyAlreadyExistingException();
            }
            return ApiKeyEntity.generateForSubscription(subscription, customApiKey);
        }
        return ApiKeyEntity.generateForSubscription(subscription);
    }

    private boolean isKeyExistFor(String apiKeyValue, SubscriptionEntity subscription) {
        String apiId = subscription.getApiId();
        log.debug("Check if an API Key can be created for api {} and application {}", (Object)apiId, (Object)subscription.getApplicationId());
        return this.apiKeyQueryService.findByKeyAndApiId(apiKeyValue, apiId).isEmpty();
    }

    private ApiKeyEntity findOrGenerate(AuditInfo auditInfo, BaseApplicationEntity application, SubscriptionEntity subscription, String customApiKey, boolean federated) {
        return this.apiKeyQueryService.findByApplication(application.getId()).peek(apiKey -> this.addSubscription((ApiKeyEntity)apiKey, subscription)).max(Comparator.comparing(ApiKeyEntity::isRevoked, Comparator.reverseOrder()).thenComparing(ApiKeyEntity::getExpireAt, Comparator.nullsLast(Comparator.naturalOrder()))).orElseGet(() -> this.generate(auditInfo, subscription, customApiKey, federated));
    }

    private void addSubscription(ApiKeyEntity apiKey, SubscriptionEntity subscription) {
        this.apiKeyCrudService.update(apiKey.addSubscription(subscription.getId()));
    }

    private void createAuditLog(ApiKeyEntity createdApiKeyEntity, SubscriptionEntity subscription, AuditInfo auditInfo) {
        this.auditService.createApiAuditLog(ApiAuditLogEntity.builder().organizationId(auditInfo.organizationId()).environmentId(auditInfo.environmentId()).apiId(subscription.getApiId()).event(ApiKeyAuditEvent.APIKEY_CREATED).actor(auditInfo.actor()).oldValue(null).newValue(createdApiKeyEntity).createdAt(createdApiKeyEntity.getCreatedAt()).properties(Map.of(AuditProperties.API_KEY, createdApiKeyEntity.getKey(), AuditProperties.API, subscription.getApiId(), AuditProperties.APPLICATION, subscription.getApplicationId())).build());
    }

    @Generated
    public GenerateApiKeyDomainService(ApiKeyCrudService apiKeyCrudService, ApiKeyQueryService apiKeyQueryService, ApplicationCrudService applicationCrudService, AuditDomainService auditService) {
        this.apiKeyCrudService = apiKeyCrudService;
        this.apiKeyQueryService = apiKeyQueryService;
        this.applicationCrudService = applicationCrudService;
        this.auditService = auditService;
    }
}

