/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.ThemeRepository;
import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.Theme;
import io.gravitee.repository.management.model.ThemeReferenceType;
import io.gravitee.repository.management.model.ThemeType;
import io.gravitee.rest.api.model.InlinePictureEntity;
import io.gravitee.rest.api.model.PictureEntity;
import io.gravitee.rest.api.model.UrlPictureEntity;
import io.gravitee.rest.api.model.theme.GenericThemeEntity;
import io.gravitee.rest.api.model.theme.portal.NewThemeEntity;
import io.gravitee.rest.api.model.theme.portal.ThemeComponentDefinition;
import io.gravitee.rest.api.model.theme.portal.ThemeCssDefinition;
import io.gravitee.rest.api.model.theme.portal.ThemeDefinition;
import io.gravitee.rest.api.model.theme.portal.ThemeEntity;
import io.gravitee.rest.api.model.theme.portal.UpdateThemeEntity;
import io.gravitee.rest.api.service.AuditService;
import io.gravitee.rest.api.service.ThemeService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.exceptions.DuplicateThemeNameException;
import io.gravitee.rest.api.service.exceptions.TechnicalManagementException;
import io.gravitee.rest.api.service.exceptions.ThemeNotFoundException;
import io.gravitee.rest.api.service.impl.AbstractService;
import jakarta.activation.MimetypesFileTypeMap;
import jakarta.xml.bind.DatatypeConverter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class ThemeServiceImpl
extends AbstractService
implements ThemeService {
    private final Logger LOGGER = LoggerFactory.getLogger(ThemeServiceImpl.class);
    private static final ThemeDefinitionMapper MAPPER = new ThemeDefinitionMapper();
    private static final String DEFAULT_THEME_PATH = "/definition.json";
    @Lazy
    @Autowired
    private ThemeRepository themeRepository;
    @Autowired
    private AuditService auditService;
    @Value(value="${portal.themes.path:${gravitee.home}/themes}")
    private String themesPath;

    @Override
    public Set<GenericThemeEntity> findAllByType(ExecutionContext executionContext, io.gravitee.rest.api.model.theme.ThemeType type) {
        try {
            this.LOGGER.debug("Find all themes by reference: " + executionContext.getEnvironmentId());
            return this.themeRepository.findByReferenceIdAndReferenceTypeAndType(executionContext.getEnvironmentId(), ThemeReferenceType.ENVIRONMENT.name(), ThemeType.valueOf((String)type.name())).stream().map(this::convert).collect(Collectors.toSet());
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all themes", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find all themes", ex);
        }
    }

    @Override
    public GenericThemeEntity findById(ExecutionContext executionContext, String themeId) {
        return this.convert(this.findByIdWithoutConvert(executionContext, themeId));
    }

    private Theme findByIdWithoutConvert(ExecutionContext executionContext, String themeId) {
        try {
            this.LOGGER.debug("Find theme by ID: {}", (Object)themeId);
            Optional optTheme = this.themeRepository.findById((Object)themeId);
            if (!optTheme.isPresent()) {
                throw new ThemeNotFoundException(themeId);
            }
            Theme theme = (Theme)optTheme.get();
            if (!theme.getReferenceId().equals(executionContext.getEnvironmentId())) {
                this.LOGGER.warn("Theme is not in current environment " + executionContext.getEnvironmentId() + " actual:" + theme.getReferenceId());
                throw new ThemeNotFoundException(themeId);
            }
            return theme;
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find theme by ID", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find theme by ID", ex);
        }
    }

    @Override
    public ThemeEntity createPortalTheme(ExecutionContext executionContext, NewThemeEntity themeEntity) {
        try {
            if (this.findByName(executionContext, themeEntity.getName(), null).isPresent()) {
                throw new DuplicateThemeNameException(themeEntity.getName());
            }
            Theme theme = (Theme)this.themeRepository.create((Object)this.convert(executionContext, themeEntity));
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.THEME, theme.getId()), (Audit.AuditEvent)Theme.AuditEvent.THEME_CREATED, theme.getCreatedAt(), null, theme);
            return this.convertToPortalThemeEntity(theme);
        }
        catch (TechnicalException ex) {
            String error = "An error occurred while trying to create theme " + themeEntity;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    private Optional<GenericThemeEntity> findByName(ExecutionContext executionContext, String name, String excludedId) {
        return this.findAllByType(executionContext, io.gravitee.rest.api.model.theme.ThemeType.PORTAL).stream().filter(t -> !t.getId().equals(excludedId) && t.getName().equals(name)).findAny();
    }

    @Override
    public ThemeEntity updatePortalTheme(ExecutionContext executionContext, UpdateThemeEntity updateThemeEntity) {
        try {
            Optional themeOptional = this.themeRepository.findById((Object)updateThemeEntity.getId());
            if (themeOptional.isPresent()) {
                Theme theme = new Theme((Theme)themeOptional.get());
                if (!theme.getReferenceId().equals(executionContext.getEnvironmentId())) {
                    this.LOGGER.warn("Theme is not in current environment " + executionContext.getEnvironmentId() + " actual:" + theme.getReferenceId());
                    throw new ThemeNotFoundException(theme.getId());
                }
                if (this.findByName(executionContext, theme.getName(), theme.getId()).isPresent()) {
                    throw new DuplicateThemeNameException(theme.getName());
                }
                theme.setEnabled(updateThemeEntity.isEnabled());
                Date now = new Date();
                theme.setUpdatedAt(now);
                theme.setReferenceType(ThemeReferenceType.ENVIRONMENT.name());
                theme.setReferenceId(executionContext.getEnvironmentId());
                if (updateThemeEntity.getName() != null) {
                    theme.setName(updateThemeEntity.getName());
                }
                theme.setDefinition(MAPPER.writeValueAsString(updateThemeEntity.getDefinition()));
                if (updateThemeEntity.getLogo() != null) {
                    theme.setLogo(updateThemeEntity.getLogo());
                } else {
                    theme.setLogo(this.getDefaultLogo());
                }
                theme.setBackgroundImage(updateThemeEntity.getBackgroundImage());
                if (updateThemeEntity.getOptionalLogo() != null) {
                    theme.setOptionalLogo(updateThemeEntity.getOptionalLogo());
                } else {
                    theme.setOptionalLogo(this.getDefaultOptionalLogo());
                }
                if (updateThemeEntity.getFavicon() != null) {
                    theme.setFavicon(updateThemeEntity.getFavicon());
                } else {
                    theme.setFavicon(this.getDefaultFavicon());
                }
                ThemeEntity savedTheme = this.convertToPortalThemeEntity((Theme)this.themeRepository.update((Object)theme));
                this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.THEME, theme.getId()), (Audit.AuditEvent)Theme.AuditEvent.THEME_UPDATED, new Date(), themeOptional.get(), theme);
                return savedTheme;
            }
            NewThemeEntity newTheme = new NewThemeEntity();
            newTheme.setName(updateThemeEntity.getName());
            newTheme.setDefinition((Object)updateThemeEntity.getDefinition());
            newTheme.setBackgroundImage(updateThemeEntity.getBackgroundImage());
            newTheme.setLogo(updateThemeEntity.getLogo());
            newTheme.setOptionalLogo(updateThemeEntity.getOptionalLogo());
            newTheme.setFavicon(updateThemeEntity.getFavicon());
            newTheme.setEnabled(updateThemeEntity.isEnabled());
            return this.createPortalTheme(executionContext, newTheme);
        }
        catch (JsonProcessingException | TechnicalException ex) {
            String error = "An error occurred while trying to update theme " + updateThemeEntity;
            this.LOGGER.error(error, ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public void delete(ExecutionContext executionContext, String themeId) {
        try {
            Optional<Theme> themeOptional = this.themeRepository.findById((Object)themeId).filter(t -> ThemeReferenceType.ENVIRONMENT.name().equalsIgnoreCase(t.getReferenceType()) && t.getReferenceId().equalsIgnoreCase(executionContext.getEnvironmentId()));
            if (themeOptional.isPresent()) {
                this.themeRepository.delete((Object)themeId);
                this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.THEME, themeId), (Audit.AuditEvent)Theme.AuditEvent.THEME_DELETED, new Date(), null, themeOptional.get());
            }
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to delete theme " + themeId;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    @Override
    public ThemeEntity findEnabledPortalTheme(ExecutionContext executionContext) {
        try {
            return this.findEnvironmentPortalThemes(executionContext).filter(ThemeEntity::isEnabled).orElseGet(this::buildDefaultPortalTheme);
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find enabled theme";
            this.LOGGER.error("An error occurs while trying to find enabled theme", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find enabled theme", ex);
        }
    }

    @Override
    public ThemeEntity findOrCreateDefaultPortalTheme(ExecutionContext executionContext) {
        try {
            return this.findEnvironmentPortalThemes(executionContext).orElseGet(() -> this.createDefaultPortalTheme(executionContext));
        }
        catch (TechnicalException ex) {
            String error = "An error occurs while trying to find theme or create default";
            this.LOGGER.error("An error occurs while trying to find theme or create default", (Throwable)ex);
            throw new TechnicalManagementException("An error occurs while trying to find theme or create default", ex);
        }
    }

    private Optional<ThemeEntity> findEnvironmentPortalThemes(ExecutionContext executionContext) throws TechnicalException {
        return this.themeRepository.findByReferenceIdAndReferenceTypeAndType(executionContext.getEnvironmentId(), ThemeReferenceType.ENVIRONMENT.name(), ThemeType.PORTAL).stream().sorted(Comparator.comparing(Theme::isEnabled, Comparator.reverseOrder())).findFirst().map(this::convertToPortalThemeEntity);
    }

    private ThemeEntity buildDefaultPortalTheme() {
        ThemeEntity theme = new ThemeEntity();
        theme.setId(UUID.randomUUID().toString());
        theme.setName("Default theme");
        try {
            theme.setDefinition(MAPPER.readPortalDefinition(this.getDefaultDefinition()));
        }
        catch (IOException e) {
            throw new TechnicalManagementException(e);
        }
        theme.setBackgroundImage(this.getDefaultBackgroundImage());
        theme.setLogo(this.getDefaultLogo());
        theme.setOptionalLogo(this.getDefaultOptionalLogo());
        theme.setFavicon(this.getDefaultFavicon());
        return theme;
    }

    private ThemeEntity createDefaultPortalTheme(ExecutionContext executionContext) {
        return this.createPortalTheme(executionContext, this.convert(this.buildDefaultPortalTheme()));
    }

    @Override
    public void updateDefaultPortalTheme(ExecutionContext executionContext) {
        try {
            Set themes = this.themeRepository.findByReferenceIdAndReferenceTypeAndType(executionContext.getEnvironmentId(), ThemeReferenceType.ENVIRONMENT.name(), ThemeType.PORTAL);
            String defaultDefinition = this.getDefaultDefinition();
            if (themes != null && !themes.isEmpty()) {
                themes.forEach(theme -> {
                    if (!MAPPER.isSame(defaultDefinition, theme.getDefinition())) {
                        try {
                            ThemeDefinition mergeDefinition = MAPPER.merge(defaultDefinition, theme.getDefinition());
                            Theme themeUpdate = new Theme(theme);
                            themeUpdate.setDefinition(MAPPER.writeValueAsString(mergeDefinition));
                            theme.setUpdatedAt(new Date());
                            this.themeRepository.update((Object)themeUpdate);
                            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.THEME, theme.getId()), (Audit.AuditEvent)Theme.AuditEvent.THEME_UPDATED, new Date(), theme, themeUpdate);
                        }
                        catch (IOException ex) {
                            String error = "Error while trying to merge default theme from the definition path: " + this.themesPath + "/definition.json with theme " + theme.toString();
                            this.LOGGER.error(error, (Throwable)ex);
                        }
                        catch (TechnicalException ex) {
                            String error = "Error while trying to update theme after merge with default" + theme.toString();
                            this.LOGGER.error(error, (Throwable)ex);
                        }
                    }
                });
            }
        }
        catch (TechnicalException ex) {
            this.LOGGER.error("An error occurs while trying to find all themes", (Throwable)ex);
        }
    }

    @Override
    public PictureEntity getFavicon(ExecutionContext executionContext, String themeId) {
        try {
            String favicon = this.findByIdWithoutConvert(executionContext, themeId).getFavicon();
            if (favicon != null) {
                return this.convertToPicture(favicon);
            }
        }
        catch (ThemeNotFoundException ex) {
            this.LOGGER.debug("Theme {} not found, using default favicon", (Object)themeId);
        }
        return this.convertToPicture(this.getDefaultFavicon());
    }

    public String getDefaultDefinition() {
        return this.getDefinition(this.themesPath + DEFAULT_THEME_PATH);
    }

    public String getDefinition(String path) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = new String(Files.readAllBytes(new File(path).toPath()), Charset.defaultCharset());
            JsonNode jsonNode = (JsonNode)objectMapper.readValue(json, JsonNode.class);
            return jsonNode.toString();
        }
        catch (IOException ex) {
            String error = "Error while trying to load a theme from the definition path: " + path;
            this.LOGGER.error(error, (Throwable)ex);
            throw new TechnicalManagementException(error, ex);
        }
    }

    public String getDefaultBackgroundImage() {
        return this.getImage("background-image.png");
    }

    public String getDefaultLogo() {
        return this.getImage("logo.png");
    }

    public String getDefaultOptionalLogo() {
        return this.getImage("logo-light.png");
    }

    public String getDefaultFavicon() {
        return this.getImage("favicon.png");
    }

    private String getImage(String filename) {
        String filepath = this.themesPath + "/" + filename;
        File imageFile = new File(filepath);
        if (!imageFile.exists()) {
            return null;
        }
        try {
            byte[] image = Files.readAllBytes(imageFile.toPath());
            MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
            return "data:" + fileTypeMap.getContentType(filename) + ";base64," + Base64.getEncoder().encodeToString(image);
        }
        catch (IOException ex) {
            String error = "Error while trying to load image from: " + filepath;
            this.LOGGER.error(error, (Throwable)ex);
            return null;
        }
    }

    @Override
    public GenericThemeEntity resetToDefaultTheme(ExecutionContext executionContext, String themeId) {
        try {
            this.LOGGER.debug("Reset to default theme by ID: {}", (Object)themeId);
            GenericThemeEntity previousTheme = this.findById(executionContext, themeId);
            this.themeRepository.delete((Object)previousTheme.getId());
            this.auditService.createAuditLog(executionContext, Collections.singletonMap(Audit.AuditProperties.THEME, themeId), (Audit.AuditEvent)Theme.AuditEvent.THEME_RESET, new Date(), previousTheme, null);
            if (io.gravitee.rest.api.model.theme.ThemeType.PORTAL.equals((Object)previousTheme.getType())) {
                return this.findOrCreateDefaultPortalTheme(executionContext);
            }
            return null;
        }
        catch (Exception ex) {
            String error = "Error while trying to reset a default theme";
            this.LOGGER.error("Error while trying to reset a default theme", (Throwable)ex);
            throw new TechnicalManagementException("Error while trying to reset a default theme", ex);
        }
    }

    @Override
    public PictureEntity getLogo(ExecutionContext executionContext, String themeId) {
        try {
            String logo = this.findByIdWithoutConvert(executionContext, themeId).getLogo();
            if (logo != null) {
                return this.convertToPicture(logo);
            }
        }
        catch (ThemeNotFoundException ex) {
            this.LOGGER.debug("Theme {} not found, using default logo", (Object)themeId);
        }
        return this.convertToPicture(this.getDefaultLogo());
    }

    @Override
    public PictureEntity getOptionalLogo(ExecutionContext executionContext, String themeId) {
        try {
            String optionalLogo = this.findByIdWithoutConvert(executionContext, themeId).getOptionalLogo();
            if (optionalLogo != null) {
                return this.convertToPicture(optionalLogo);
            }
        }
        catch (ThemeNotFoundException ex) {
            this.LOGGER.debug("Theme {} not found, using default optional logo", (Object)themeId);
        }
        return this.convertToPicture(this.getDefaultOptionalLogo());
    }

    @Override
    public PictureEntity getBackgroundImage(ExecutionContext executionContext, String themeId) {
        try {
            String backgroundImage = this.findByIdWithoutConvert(executionContext, themeId).getBackgroundImage();
            if (backgroundImage != null) {
                return this.convertToPicture(backgroundImage);
            }
        }
        catch (ThemeNotFoundException ex) {
            this.LOGGER.debug("Theme {} not found, using default background image", (Object)themeId);
        }
        return this.convertToPicture(this.getDefaultBackgroundImage());
    }

    private PictureEntity convertToPicture(String picture) {
        if (StringUtils.isEmpty((CharSequence)picture)) {
            return null;
        }
        if (picture.matches("^(http|https)://.*$")) {
            return new UrlPictureEntity(picture);
        }
        InlinePictureEntity imageEntity = new InlinePictureEntity();
        String[] parts = picture.split(";", 2);
        imageEntity.setType(parts[0].split(":")[1]);
        String base64Content = picture.split(",", 2)[1];
        imageEntity.setContent(DatatypeConverter.parseBase64Binary((String)base64Content));
        return imageEntity;
    }

    private Theme convert(ExecutionContext executionContext, NewThemeEntity themeEntity) {
        try {
            Date now = new Date();
            Theme theme = new Theme();
            theme.setId(String.valueOf(UUID.randomUUID()));
            theme.setType(ThemeType.valueOf((String)themeEntity.getType().name()));
            theme.setCreatedAt(now);
            theme.setUpdatedAt(now);
            theme.setReferenceId(executionContext.getEnvironmentId());
            theme.setReferenceType(ThemeReferenceType.ENVIRONMENT.name());
            theme.setLogo(themeEntity.getLogo());
            theme.setName(themeEntity.getName());
            theme.setDefinition(MAPPER.writeValueAsString(themeEntity.getDefinition()));
            theme.setEnabled(themeEntity.isEnabled());
            theme.setBackgroundImage(themeEntity.getBackgroundImage());
            theme.setOptionalLogo(themeEntity.getOptionalLogo());
            theme.setFavicon(themeEntity.getFavicon());
            return theme;
        }
        catch (JsonProcessingException e) {
            throw new TechnicalManagementException("Cannot convert new theme entity", e);
        }
    }

    private ThemeEntity convertToPortalThemeEntity(Theme theme) {
        ThemeEntity themeEntity = new ThemeEntity();
        themeEntity.setId(theme.getId());
        themeEntity.setName(theme.getName());
        try {
            themeEntity.setDefinition(MAPPER.readPortalDefinition(theme.getDefinition()));
        }
        catch (IOException e) {
            this.LOGGER.error("Cannot read definition of theme " + theme.getId() + " definition:" + theme.getDefinition());
        }
        themeEntity.setCreatedAt(theme.getCreatedAt());
        themeEntity.setUpdatedAt(theme.getUpdatedAt());
        themeEntity.setEnabled(theme.isEnabled());
        themeEntity.setLogo(theme.getLogo());
        themeEntity.setBackgroundImage(theme.getBackgroundImage());
        themeEntity.setOptionalLogo(theme.getOptionalLogo());
        themeEntity.setFavicon(theme.getFavicon());
        return themeEntity;
    }

    private GenericThemeEntity convert(Theme theme) {
        if (ThemeType.PORTAL.equals((Object)theme.getType())) {
            return this.convertToPortalThemeEntity(theme);
        }
        try {
            io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition portalNextDefinition = MAPPER.readPortalNextDefinition(theme.getDefinition());
            return io.gravitee.rest.api.model.theme.portalnext.ThemeEntity.builder().id(theme.getId()).name(theme.getName()).definition(portalNextDefinition).createdAt(theme.getCreatedAt()).updatedAt(theme.getUpdatedAt()).logo(theme.getLogo()).optionalLogo(theme.getOptionalLogo()).favicon(theme.getFavicon()).build();
        }
        catch (IOException e) {
            throw new TechnicalManagementException(e);
        }
    }

    private NewThemeEntity convert(ThemeEntity theme) {
        NewThemeEntity newThemeEntity = new NewThemeEntity();
        newThemeEntity.setName(theme.getName());
        newThemeEntity.setDefinition((Object)theme.getDefinition());
        newThemeEntity.setBackgroundImage(theme.getBackgroundImage());
        newThemeEntity.setLogo(theme.getLogo());
        newThemeEntity.setOptionalLogo(theme.getOptionalLogo());
        newThemeEntity.setFavicon(theme.getFavicon());
        return newThemeEntity;
    }

    public static class ThemeDefinitionMapper
    extends ObjectMapper {
        private final Logger LOGGER = LoggerFactory.getLogger(ThemeDefinitionMapper.class);

        public ThemeDefinition readPortalDefinition(String themeDefinition) throws IOException {
            return (ThemeDefinition)this.readValue(themeDefinition, ThemeDefinition.class);
        }

        public io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition readPortalNextDefinition(String themeDefinition) throws IOException {
            return (io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition)this.readValue(themeDefinition, io.gravitee.rest.api.model.theme.portalnext.ThemeDefinition.class);
        }

        public ThemeDefinition merge(String base, String override) throws IOException {
            ThemeDefinition overrideDefinition = this.readPortalDefinition(override);
            ThemeDefinition overrideDefinitionFinal = this.readPortalDefinition(override);
            ThemeDefinition mergedDefinition = (ThemeDefinition)this.readerForUpdating(overrideDefinition).readValue(base);
            List componentsData = mergedDefinition.getData().stream().map(component -> {
                List cssMerged = component.getCss().stream().map(css -> {
                    ThemeCssDefinition customCss = this.getThemeCssDefinition(overrideDefinitionFinal, component.getName(), css.getName());
                    if (customCss != null) {
                        css.setValue(customCss.getValue());
                    }
                    return css;
                }).collect(Collectors.toList());
                component.setCss(cssMerged);
                return component;
            }).collect(Collectors.toList());
            mergedDefinition.setData(componentsData);
            return mergedDefinition;
        }

        public ThemeComponentDefinition getThemeComponentDefinition(ThemeDefinition themeDefinition, String name) {
            return themeDefinition.getData().stream().filter(themeComponentDefinition -> name.equals(themeComponentDefinition.getName())).findFirst().orElse(null);
        }

        public ThemeCssDefinition getThemeCssDefinition(ThemeDefinition themeDefinition, String name, String cssName) {
            ThemeComponentDefinition componentDefinition = this.getThemeComponentDefinition(themeDefinition, name);
            if (componentDefinition != null) {
                return componentDefinition.getCss().stream().filter(css -> cssName.equals(css.getName())).findFirst().orElse(null);
            }
            return null;
        }

        public boolean isSame(String definitionA, String definitionB) {
            try {
                return this.readTree(definitionA).equals((Object)this.readTree(definitionB));
            }
            catch (IOException e) {
                this.LOGGER.error("Cannot compare definition " + definitionA + " and " + definitionB, (Throwable)e);
                return false;
            }
        }
    }
}

