/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.integration;

import io.gravitee.apim.core.exception.TechnicalDomainException;
import io.gravitee.apim.core.integration.exception.IntegrationDiscoveryException;
import io.gravitee.apim.core.integration.exception.IntegrationIngestionException;
import io.gravitee.apim.core.integration.exception.IntegrationSubscriptionException;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.integration.model.IntegrationApi;
import io.gravitee.apim.core.integration.model.IntegrationSubscription;
import io.gravitee.apim.core.integration.service_provider.IntegrationAgent;
import io.gravitee.apim.core.subscription.model.SubscriptionEntity;
import io.gravitee.apim.infra.adapter.IntegrationAdapter;
import io.gravitee.definition.model.federation.FederatedApi;
import io.gravitee.definition.model.federation.SubscriptionParameter;
import io.gravitee.exchange.api.command.Command;
import io.gravitee.exchange.api.command.CommandStatus;
import io.gravitee.exchange.api.controller.ExchangeController;
import io.gravitee.integration.api.command.discover.DiscoverCommand;
import io.gravitee.integration.api.command.discover.DiscoverReply;
import io.gravitee.integration.api.command.discover.DiscoverReplyPayload;
import io.gravitee.integration.api.command.ingest.IngestCommand;
import io.gravitee.integration.api.command.ingest.IngestCommandPayload;
import io.gravitee.integration.api.command.ingest.IngestReply;
import io.gravitee.integration.api.command.ingest.IngestReplyPayload;
import io.gravitee.integration.api.command.subscribe.SubscribeCommand;
import io.gravitee.integration.api.command.subscribe.SubscribeCommandPayload;
import io.gravitee.integration.api.command.subscribe.SubscribeReply;
import io.gravitee.integration.api.command.subscribe.SubscribeReplyPayload;
import io.gravitee.integration.api.command.unsubscribe.UnsubscribeCommand;
import io.gravitee.integration.api.command.unsubscribe.UnsubscribeCommandPayload;
import io.gravitee.integration.api.command.unsubscribe.UnsubscribeReply;
import io.gravitee.integration.api.model.Api;
import io.gravitee.integration.api.model.Subscription;
import io.gravitee.integration.api.model.SubscriptionResult;
import io.gravitee.integration.api.model.SubscriptionType;
import io.gravitee.rest.api.model.BaseApplicationEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class IntegrationAgentImpl
implements IntegrationAgent {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IntegrationAgentImpl.class);
    private final Optional<ExchangeController> exchangeController;

    public IntegrationAgentImpl(@Qualifier(value="integrationExchangeController") Optional<ExchangeController> exchangeController) {
        this.exchangeController = exchangeController;
    }

    @Override
    public Flowable<IntegrationApi> fetchAllApis(Integration integration) {
        String targetId = integration.getId();
        IngestCommand command = new IngestCommand(new IngestCommandPayload(List.of()));
        log.debug("Fetch all assets for [integrationId={}]", (Object)targetId);
        return this.sendIngestCommand(command, targetId).toFlowable().flatMap(reply -> {
            if (reply.getCommandStatus() == CommandStatus.SUCCEEDED) {
                log.debug("Received apis for [integrationId={}] [total={}]", (Object)targetId, (Object)((IngestReplyPayload)reply.getPayload()).apis().size());
                return Flowable.fromIterable((Iterable)((IngestReplyPayload)reply.getPayload()).apis()).map(api -> IntegrationAdapter.INSTANCE.map((Api)api, integration.getId()));
            }
            return Flowable.error((Throwable)new IntegrationIngestionException(reply.getErrorDetails()));
        });
    }

    @Override
    public Single<IntegrationSubscription> subscribe(String integrationId, FederatedApi api, SubscriptionParameter subscriptionParameter, String subscriptionId, BaseApplicationEntity application) {
        Map<String, String> metadata;
        SubscriptionType type;
        if (subscriptionParameter instanceof SubscriptionParameter.ApiKey) {
            SubscriptionParameter.ApiKey apiKeyParams = (SubscriptionParameter.ApiKey)subscriptionParameter;
            type = SubscriptionType.API_KEY;
            metadata = Map.of("planId", apiKeyParams.plan().getProviderId());
        } else if (subscriptionParameter instanceof SubscriptionParameter.OAuth) {
            SubscriptionParameter.OAuth oauthParams = (SubscriptionParameter.OAuth)subscriptionParameter;
            type = SubscriptionType.OAUTH;
            metadata = Map.of("planId", oauthParams.plan().getProviderId(), "consumerKey", oauthParams.clientId());
        } else {
            return Single.error((Throwable)new IntegrationIngestionException("Unsupported subscription type: " + subscriptionParameter.plan().getSecurity().getType()));
        }
        SubscribeCommandPayload payload = new SubscribeCommandPayload(api.getProviderId(), Subscription.builder().graviteeSubscriptionId(subscriptionId).graviteeApplicationId(application.getId()).graviteeApplicationName(application.getName()).type(type).metadata(metadata).build());
        return this.sendSubscribeCommand(new SubscribeCommand(payload), integrationId).flatMap(reply -> {
            if (reply.getCommandStatus() == CommandStatus.ERROR) {
                return Single.error((Throwable)new IntegrationSubscriptionException(reply.getErrorDetails()));
            }
            SubscriptionResult subscriptionResult = ((SubscribeReplyPayload)reply.getPayload()).subscription();
            return switch (payload.subscription().type()) {
                case SubscriptionType.API_KEY -> Single.just((Object)IntegrationSubscription.apiKey(integrationId, subscriptionResult.apiKey(), subscriptionResult.metadata()));
                case SubscriptionType.OAUTH -> Single.just((Object)IntegrationSubscription.oAuth(integrationId));
                default -> Single.error((Throwable)new IntegrationSubscriptionException("Unsupported subscription type: " + payload.subscription().type()));
            };
        });
    }

    @Override
    public Completable unsubscribe(String integrationId, FederatedApi api, SubscriptionEntity subscription) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (subscription.getMetadata() != null) {
            metadata.putAll(subscription.getMetadata());
        }
        if (subscription.getClientId() != null) {
            metadata.put("consumerKey", subscription.getClientId());
        }
        UnsubscribeCommandPayload payload = new UnsubscribeCommandPayload(api.getProviderId(), Subscription.builder().graviteeSubscriptionId(subscription.getId()).metadata(metadata).build());
        return this.sendUnsubscribeCommand(new UnsubscribeCommand(payload), integrationId).flatMapCompletable(reply -> reply.getCommandStatus() == CommandStatus.ERROR ? Completable.error((Throwable)new IntegrationSubscriptionException(reply.getErrorDetails())) : Completable.complete());
    }

    @Override
    public Flowable<IntegrationApi> discoverApis(String integrationId) {
        DiscoverCommand command = new DiscoverCommand();
        log.debug("Discover all assets for [integrationId={}]", (Object)integrationId);
        return this.sendDiscoverCommand(command, integrationId).toFlowable().flatMap(discoverReply -> {
            if (discoverReply.getCommandStatus() == CommandStatus.ERROR) {
                return Flowable.error((Throwable)new IntegrationDiscoveryException(discoverReply.getErrorDetails()));
            }
            log.debug("Discovered APIs for [integrationId={}] total: [{}]", (Object)integrationId, (Object)((DiscoverReplyPayload)discoverReply.getPayload()).apis().size());
            return Flowable.fromIterable((Iterable)((DiscoverReplyPayload)discoverReply.getPayload()).apis()).map(api -> IntegrationAdapter.INSTANCE.map((Api)api, integrationId));
        });
    }

    private Single<IngestReply> sendIngestCommand(IngestCommand fetchCommand, String integrationId) {
        return this.exchangeController.map(controller -> controller.sendCommand((Command)fetchCommand, integrationId).cast(IngestReply.class).onErrorReturn(throwable -> new IngestReply(fetchCommand.getId(), throwable.getMessage()))).orElse(Single.error((Throwable)new TechnicalDomainException("Federation feature not enabled")));
    }

    private Single<SubscribeReply> sendSubscribeCommand(SubscribeCommand subscribeCommand, String integrationId) {
        return this.exchangeController.map(controller -> controller.sendCommand((Command)subscribeCommand, integrationId).cast(SubscribeReply.class).onErrorReturn(throwable -> new SubscribeReply(subscribeCommand.getId(), throwable.getMessage()))).orElse(Single.error((Throwable)new TechnicalDomainException("Federation feature not enabled")));
    }

    private Single<UnsubscribeReply> sendUnsubscribeCommand(UnsubscribeCommand command, String integrationId) {
        return this.exchangeController.map(controller -> controller.sendCommand((Command)command, integrationId).cast(UnsubscribeReply.class).onErrorReturn(throwable -> new UnsubscribeReply(command.getId(), throwable.getMessage()))).orElse(Single.error((Throwable)new TechnicalDomainException("Federation feature not enabled")));
    }

    private Single<DiscoverReply> sendDiscoverCommand(DiscoverCommand command, String integrationId) {
        return this.exchangeController.map(controller -> controller.sendCommand((Command)command, integrationId).cast(DiscoverReply.class).onErrorReturn(throwable -> new DiscoverReply(command.getId(), throwable.getMessage()))).orElse(Single.error((Throwable)new TechnicalDomainException("Federation feature not enabled")));
    }
}

