/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.theme.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.theme.domain_service.DefaultThemeDomainService;
import io.gravitee.apim.core.theme.model.Theme;
import io.gravitee.apim.core.theme.model.ThemeType;
import io.gravitee.apim.core.theme.query_service.ThemeQueryService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import java.util.Objects;
import lombok.Generated;

@UseCase
public class GetCurrentThemeUseCase {
    private final ThemeQueryService themeQueryService;
    private final DefaultThemeDomainService defaultThemeDomainService;

    public Output execute(Input input) {
        Theme currentTheme = this.themeQueryService.findByThemeTypeAndEnvironmentId(input.type(), input.executionContext().getEnvironmentId()).stream().filter(theme -> Objects.equals(true, theme.isEnabled())).findFirst().orElseGet(() -> this.defaultThemeDomainService.createAndEnableDefaultTheme(input.type(), input.executionContext()));
        return new Output(currentTheme);
    }

    @Generated
    public GetCurrentThemeUseCase(ThemeQueryService themeQueryService, DefaultThemeDomainService defaultThemeDomainService) {
        this.themeQueryService = themeQueryService;
        this.defaultThemeDomainService = defaultThemeDomainService;
    }

    public record Input(ThemeType type, ExecutionContext executionContext) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private ThemeType type;
            @Generated
            private ExecutionContext executionContext;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder type(ThemeType type) {
                this.type = type;
                return this;
            }

            @Generated
            public InputBuilder executionContext(ExecutionContext executionContext) {
                this.executionContext = executionContext;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.type, this.executionContext);
            }

            @Generated
            public String toString() {
                return "GetCurrentThemeUseCase.Input.InputBuilder(type=" + this.type + ", executionContext=" + this.executionContext + ")";
            }
        }
    }

    public record Output(Theme result) {
    }
}

