/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.integration.use_case;

import io.gravitee.apim.core.UseCase;
import io.gravitee.apim.core.exception.NotAllowedDomainException;
import io.gravitee.apim.core.integration.crud_service.IntegrationCrudService;
import io.gravitee.apim.core.integration.model.Integration;
import io.gravitee.apim.core.license.domain_service.LicenseDomainService;
import io.gravitee.common.utils.TimeProvider;
import io.gravitee.rest.api.service.common.UuidString;
import java.time.ZonedDateTime;
import lombok.Generated;

@UseCase
public class CreateIntegrationUseCase {
    private final IntegrationCrudService integrationCrudService;
    private final LicenseDomainService licenseDomainService;

    public CreateIntegrationUseCase(IntegrationCrudService integrationCrudService, LicenseDomainService licenseDomainService) {
        this.integrationCrudService = integrationCrudService;
        this.licenseDomainService = licenseDomainService;
    }

    public Output execute(Input input) {
        if (!this.licenseDomainService.isFederationFeatureAllowed(input.organizationId())) {
            throw NotAllowedDomainException.noLicenseForFederation();
        }
        ZonedDateTime now = TimeProvider.now();
        Integration integrationToCreate = Integration.builder().id(UuidString.generateRandom()).name(input.integration.getName()).description(input.integration.getDescription()).provider(input.integration.getProvider()).environmentId(input.integration.getEnvironmentId()).agentStatus(Integration.AgentStatus.DISCONNECTED).createdAt(now).updatedAt(now).build();
        Integration integrationCreated = this.integrationCrudService.create(integrationToCreate);
        return new Output(integrationCreated);
    }

    public record Input(Integration integration, String organizationId) {
        @Generated
        public static InputBuilder builder() {
            return new InputBuilder();
        }

        @Generated
        public static class InputBuilder {
            @Generated
            private Integration integration;
            @Generated
            private String organizationId;

            @Generated
            InputBuilder() {
            }

            @Generated
            public InputBuilder integration(Integration integration) {
                this.integration = integration;
                return this;
            }

            @Generated
            public InputBuilder organizationId(String organizationId) {
                this.organizationId = organizationId;
                return this;
            }

            @Generated
            public Input build() {
                return new Input(this.integration, this.organizationId);
            }

            @Generated
            public String toString() {
                return "CreateIntegrationUseCase.Input.InputBuilder(integration=" + this.integration + ", organizationId=" + this.organizationId + ")";
            }
        }
    }

    public record Output(Integration createdIntegration) {
    }
}

