/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.service.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.apim.core.installation.query_service.InstallationAccessQueryService;
import io.gravitee.rest.api.model.annotations.ParameterKey;
import io.gravitee.rest.api.model.parameters.Key;
import io.gravitee.rest.api.model.parameters.ParameterReferenceType;
import io.gravitee.rest.api.model.settings.AbstractCommonSettingsEntity;
import io.gravitee.rest.api.model.settings.CommonAuthentication;
import io.gravitee.rest.api.model.settings.ConsoleConfigEntity;
import io.gravitee.rest.api.model.settings.ConsoleReCaptcha;
import io.gravitee.rest.api.model.settings.ConsoleSettingsEntity;
import io.gravitee.rest.api.model.settings.Enabled;
import io.gravitee.rest.api.model.settings.Newsletter;
import io.gravitee.rest.api.model.settings.PortalAuthentication;
import io.gravitee.rest.api.model.settings.PortalConfigEntity;
import io.gravitee.rest.api.model.settings.PortalReCaptcha;
import io.gravitee.rest.api.model.settings.PortalSettingsEntity;
import io.gravitee.rest.api.service.ConfigService;
import io.gravitee.rest.api.service.NewsletterService;
import io.gravitee.rest.api.service.ParameterService;
import io.gravitee.rest.api.service.ReCaptchaService;
import io.gravitee.rest.api.service.common.ExecutionContext;
import io.gravitee.rest.api.service.impl.AbstractService;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@Component
public class ConfigServiceImpl
extends AbstractService
implements ConfigService {
    private final Logger LOGGER = LoggerFactory.getLogger(ConfigServiceImpl.class);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @Autowired
    private ParameterService parameterService;
    @Autowired
    private ConfigurableEnvironment environment;
    @Autowired
    private NewsletterService newsletterService;
    @Autowired
    private ReCaptchaService reCaptchaService;
    @Autowired
    private InstallationAccessQueryService installationAccessQueryService;
    private static final String SENSITIVE_VALUE = "********";

    @Override
    public boolean portalLoginForced(ExecutionContext executionContext) {
        boolean result = false;
        PortalAuthentication auth = this.getPortalSettings(executionContext).getAuthentication();
        if (auth.getForceLogin() != null) {
            result = auth.getForceLogin().isEnabled();
        }
        return result;
    }

    @Override
    public PortalConfigEntity getPortalConfig(ExecutionContext executionContext) {
        return (PortalConfigEntity)MAPPER.convertValue((Object)this.getPortalSettings(executionContext), PortalConfigEntity.class);
    }

    @Override
    public PortalSettingsEntity getPortalSettings(ExecutionContext executionContext) {
        PortalSettingsEntity portalConfigEntity = new PortalSettingsEntity();
        Object[] objects = this.getObjectArray(portalConfigEntity);
        this.loadConfigByReference(executionContext, objects, (AbstractCommonSettingsEntity)portalConfigEntity, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
        this.enhanceFromConfigFile(portalConfigEntity);
        this.enhanceUrlFromService(executionContext, portalConfigEntity);
        return portalConfigEntity;
    }

    @Override
    public ConsoleConfigEntity getConsoleConfig(ExecutionContext executionContext) {
        return (ConsoleConfigEntity)MAPPER.convertValue((Object)this.getConsoleSettings(executionContext), ConsoleConfigEntity.class);
    }

    @Override
    public ConsoleSettingsEntity getConsoleSettings(ExecutionContext executionContext) {
        ConsoleSettingsEntity consoleConfigEntity = new ConsoleSettingsEntity();
        Object[] objects = this.getObjectArray(consoleConfigEntity);
        this.loadConfigByReference(executionContext, objects, (AbstractCommonSettingsEntity)consoleConfigEntity, executionContext.getOrganizationId(), ParameterReferenceType.ORGANIZATION);
        this.enhanceFromConfigFile(consoleConfigEntity);
        this.enhanceUrlFromService(executionContext, consoleConfigEntity);
        this.hideForTrialInstance(consoleConfigEntity);
        return consoleConfigEntity;
    }

    private void loadConfigByReference(ExecutionContext executionContext, Object[] objects, AbstractCommonSettingsEntity configEntity, String referenceId, ParameterReferenceType referenceType) {
        ArrayList<Key> parameterKeys = new ArrayList<Key>();
        for (Object o : objects) {
            for (Field f : o.getClass().getDeclaredFields()) {
                ParameterKey parameterKey = f.getAnnotation(ParameterKey.class);
                if (parameterKey == null) continue;
                parameterKeys.add(parameterKey.value());
            }
        }
        Map<String, List<String>> parameterMap = this.parameterService.findAll(executionContext, parameterKeys, value -> value == null ? null : value.trim(), referenceId, referenceType);
        for (Object o : objects) {
            for (Field f : o.getClass().getDeclaredFields()) {
                ParameterKey parameterKey = f.getAnnotation(ParameterKey.class);
                if (parameterKey == null) continue;
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    List<String> values = parameterMap.get(parameterKey.value().key());
                    if (this.environment.containsProperty(parameterKey.value().key())) {
                        configEntity.getMetadata().add((Object)"readonly", (Object)parameterKey.value().key());
                    }
                    String defaultValue = parameterKey.value().defaultValue();
                    if (Enabled.class.isAssignableFrom(f.getType())) {
                        f.set(o, Boolean.parseBoolean(this.getFirstValueOrDefault(values, defaultValue)) ? new Enabled(true) : new Enabled(false));
                    } else if (Boolean.class.isAssignableFrom(f.getType())) {
                        f.set(o, Boolean.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (Integer.class.isAssignableFrom(f.getType())) {
                        f.set(o, Integer.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (Double.class.isAssignableFrom(f.getType())) {
                        f.set(o, Double.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (Long.class.isAssignableFrom(f.getType())) {
                        f.set(o, Long.valueOf(this.getFirstValueOrDefault(values, defaultValue)));
                    } else if (List.class.isAssignableFrom(f.getType())) {
                        if (values == null || values.isEmpty()) {
                            if (StringUtils.isNotEmpty((CharSequence)defaultValue)) {
                                f.set(o, Arrays.asList(defaultValue.split(";")));
                            } else {
                                f.set(o, Collections.emptyList());
                            }
                        } else {
                            f.set(o, values);
                        }
                    } else if (Map.class.isAssignableFrom(f.getType())) {
                        if (values == null || values.isEmpty()) {
                            if (defaultValue == null) {
                                f.set(o, Collections.emptyMap());
                            } else {
                                f.set(o, Collections.singletonMap(defaultValue.split("@")[0], defaultValue.split("@")[1]));
                            }
                        } else {
                            f.set(o, values.stream().collect(Collectors.toMap(v -> v.split("@")[0], v -> {
                                String[] split = v.split("@");
                                if (split.length < 2) {
                                    return "";
                                }
                                return split[1];
                            })));
                        }
                    } else if (!parameterKey.sensitive()) {
                        f.set(o, this.getFirstValueOrDefault(values, defaultValue));
                    } else {
                        f.set(o, SENSITIVE_VALUE);
                    }
                }
                catch (IllegalAccessException e) {
                    this.LOGGER.error("Unable to set parameter {}. Use the default value", (Object)parameterKey.value().key(), (Object)e);
                }
                f.setAccessible(accessible);
            }
        }
    }

    private String getFirstValueOrDefault(List<String> values, String defaultValue) {
        if (values == null || values.isEmpty()) {
            return defaultValue;
        }
        return values.get(0);
    }

    private void enhanceAuthenticationFromConfigFile(CommonAuthentication authenticationConfig) {
        boolean found = true;
        int idx = 0;
        while (found) {
            String type = this.environment.getProperty("security.providers[" + idx + "].type");
            boolean bl = found = type != null;
            if (found) {
                String clientId = this.environment.getProperty("security.providers[" + idx + "].clientId");
                if ("google".equals(type)) {
                    authenticationConfig.getGoogle().setClientId(clientId);
                } else if ("github".equals(type)) {
                    authenticationConfig.getGithub().setClientId(clientId);
                } else if ("oauth2".equals(type)) {
                    authenticationConfig.getOauth2().setClientId(clientId);
                }
            }
            ++idx;
        }
    }

    private void enhanceFromConfigFile(PortalSettingsEntity portalConfigEntity) {
        this.enhanceAuthenticationFromConfigFile((CommonAuthentication)portalConfigEntity.getAuthentication());
        PortalReCaptcha reCaptcha = new PortalReCaptcha();
        reCaptcha.setEnabled(Boolean.valueOf(this.reCaptchaService.isEnabled()));
        reCaptcha.setSiteKey(this.reCaptchaService.getSiteKey());
        portalConfigEntity.setReCaptcha(reCaptcha);
    }

    private void enhanceUrlFromService(ExecutionContext executionContext, PortalSettingsEntity portalConfigEntity) {
        String portalCustomUrl = this.installationAccessQueryService.getPortalUrl(executionContext.getEnvironmentId());
        if (portalCustomUrl != null && !portalCustomUrl.equals(portalConfigEntity.getPortal().getUrl())) {
            portalConfigEntity.getPortal().setUrl(portalCustomUrl);
            if (!portalCustomUrl.equals("http://localhost:4100")) {
                portalConfigEntity.getMetadata().add((Object)"readonly", (Object)Key.PORTAL_URL.key());
            }
        }
    }

    private void enhanceFromConfigFile(ConsoleSettingsEntity consoleSettingsEntity) {
        this.enhanceAuthenticationFromConfigFile((CommonAuthentication)consoleSettingsEntity.getAuthentication());
        ConsoleReCaptcha reCaptcha = new ConsoleReCaptcha();
        reCaptcha.setEnabled(Boolean.valueOf(this.reCaptchaService.isEnabled()));
        reCaptcha.setSiteKey(this.reCaptchaService.getSiteKey());
        consoleSettingsEntity.setReCaptcha(reCaptcha);
        Newsletter newsletter = new Newsletter();
        newsletter.setEnabled(Boolean.valueOf(this.newsletterService.isEnabled()));
        consoleSettingsEntity.setNewsletter(newsletter);
    }

    private void enhanceUrlFromService(ExecutionContext executionContext, ConsoleSettingsEntity consoleConfigEntity) {
        String consoleCustomUrl = this.installationAccessQueryService.getConsoleUrl(executionContext.getOrganizationId());
        if (consoleCustomUrl != null && !consoleCustomUrl.equals(consoleConfigEntity.getManagement().getUrl())) {
            consoleConfigEntity.getManagement().setUrl(consoleCustomUrl);
            if (!consoleCustomUrl.equals("http://localhost:4100")) {
                consoleConfigEntity.getMetadata().add((Object)"readonly", (Object)Key.MANAGEMENT_URL.key());
            }
        }
    }

    private void hideForTrialInstance(ConsoleSettingsEntity consoleConfigEntity) {
        if (Boolean.TRUE.equals(consoleConfigEntity.getTrialInstance().getEnabled())) {
            consoleConfigEntity.setEmail(null);
        }
    }

    @Override
    public void save(ExecutionContext executionContext, PortalSettingsEntity portalSettingsEntity) {
        Object[] objects = this.getObjectArray(portalSettingsEntity);
        this.saveConfigByReference(executionContext, objects, executionContext.getEnvironmentId(), ParameterReferenceType.ENVIRONMENT);
    }

    @Override
    public void save(ExecutionContext executionContext, ConsoleSettingsEntity consoleSettingsEntity) {
        Object[] objects = this.getObjectArray(consoleSettingsEntity);
        this.saveConfigByReference(executionContext, objects, executionContext.getOrganizationId(), ParameterReferenceType.ORGANIZATION, this.isTrialInstance(consoleSettingsEntity));
    }

    private boolean isTrialInstance(ConsoleSettingsEntity consoleSettings) {
        return consoleSettings.getTrialInstance() != null && consoleSettings.getTrialInstance().getEnabled() != null && consoleSettings.getTrialInstance().getEnabled() != false;
    }

    private void saveConfigByReference(ExecutionContext executionContext, Object[] objects, String referenceId, ParameterReferenceType referenceType) {
        this.saveConfigByReference(executionContext, objects, referenceId, referenceType, false);
    }

    private void saveConfigByReference(ExecutionContext executionContext, Object[] objects, String referenceId, ParameterReferenceType referenceType, boolean isTrialInstance) {
        for (Object o : objects) {
            for (Field f : o.getClass().getDeclaredFields()) {
                ParameterKey parameterKey = f.getAnnotation(ParameterKey.class);
                if (parameterKey == null || isTrialInstance && parameterKey.value().isHiddenForTrial()) continue;
                boolean accessible = f.isAccessible();
                f.setAccessible(true);
                try {
                    if (Enabled.class.isAssignableFrom(f.getType())) {
                        value = f.get(o) == null ? null : Boolean.toString(((Enabled)f.get(o)).isEnabled());
                        this.parameterService.save(executionContext, parameterKey.value(), value, referenceId, referenceType);
                    } else if (Boolean.class.isAssignableFrom(f.getType())) {
                        value = f.get(o) == null ? null : Boolean.toString((Boolean)f.get(o));
                        this.parameterService.save(executionContext, parameterKey.value(), value, referenceId, referenceType);
                    } else if (Integer.class.isAssignableFrom(f.getType())) {
                        value = f.get(o) == null ? null : Integer.toString((Integer)f.get(o));
                        this.parameterService.save(executionContext, parameterKey.value(), value, referenceId, referenceType);
                    } else if (Double.class.isAssignableFrom(f.getType())) {
                        value = f.get(o) == null ? null : Double.toString((Double)f.get(o));
                        this.parameterService.save(executionContext, parameterKey.value(), value, referenceId, referenceType);
                    } else if (Long.class.isAssignableFrom(f.getType())) {
                        value = f.get(o) == null ? null : Long.toString((Long)f.get(o));
                        this.parameterService.save(executionContext, parameterKey.value(), value, referenceId, referenceType);
                    } else if (List.class.isAssignableFrom(f.getType())) {
                        this.parameterService.save(executionContext, parameterKey.value(), (List)f.get(o), referenceId, referenceType);
                    } else if (Map.class.isAssignableFrom(f.getType())) {
                        this.parameterService.save(executionContext, parameterKey.value(), (Map)f.get(o), referenceId, referenceType);
                    } else {
                        value = (String)f.get(o);
                        if (!parameterKey.sensitive() || !SENSITIVE_VALUE.equals(value)) {
                            this.parameterService.save(executionContext, parameterKey.value(), (String)f.get(o), referenceId, referenceType);
                        }
                    }
                }
                catch (IllegalAccessException e) {
                    this.LOGGER.error("Unable to set parameter {}. Use the default value", (Object)parameterKey.value().key(), (Object)e);
                }
                f.setAccessible(accessible);
            }
        }
    }

    private Object[] getObjectArray(PortalSettingsEntity portalConfigEntity) {
        return new Object[]{portalConfigEntity, portalConfigEntity.getEmail(), portalConfigEntity.getEmail().getProperties(), portalConfigEntity.getAnalytics(), portalConfigEntity.getApi(), portalConfigEntity.getApiQualityMetrics(), portalConfigEntity.getApiReview(), portalConfigEntity.getApplication(), portalConfigEntity.getApplication().getRegistration(), portalConfigEntity.getApplication().getTypes(), portalConfigEntity.getAuthentication(), portalConfigEntity.getAuthentication().getGithub(), portalConfigEntity.getAuthentication().getGoogle(), portalConfigEntity.getAuthentication().getOauth2(), portalConfigEntity.getCompany(), portalConfigEntity.getCors(), portalConfigEntity.getDocumentation(), portalConfigEntity.getOpenAPIDocViewer(), portalConfigEntity.getOpenAPIDocViewer().getOpenAPIDocType(), portalConfigEntity.getPlan(), portalConfigEntity.getPlan().getSecurity(), portalConfigEntity.getPortal(), portalConfigEntity.getPortal().getApis(), portalConfigEntity.getPortal().getAnalytics(), portalConfigEntity.getPortal().getRating(), portalConfigEntity.getPortal().getRating().getComment(), portalConfigEntity.getPortal().getUploadMedia(), portalConfigEntity.getPortal().getUserCreation(), portalConfigEntity.getPortalNext(), portalConfigEntity.getPortalNext().getBanner(), portalConfigEntity.getReCaptcha(), portalConfigEntity.getScheduler(), portalConfigEntity.getDashboards(), portalConfigEntity.getDashboards().getApiStatus(), portalConfigEntity.getLogging(), portalConfigEntity.getLogging().getAudit(), portalConfigEntity.getLogging().getAudit().getTrail(), portalConfigEntity.getLogging().getUser(), portalConfigEntity.getLogging().getMessageSampling(), portalConfigEntity.getLogging().getMessageSampling().getCount(), portalConfigEntity.getLogging().getMessageSampling().getProbabilistic(), portalConfigEntity.getLogging().getMessageSampling().getTemporal()};
    }

    private Object[] getObjectArray(ConsoleSettingsEntity consoleConfigEntity) {
        return new Object[]{consoleConfigEntity, consoleConfigEntity.getEmail(), consoleConfigEntity.getEmail().getProperties(), consoleConfigEntity.getAlert(), consoleConfigEntity.getAuthentication(), consoleConfigEntity.getAuthentication().getGithub(), consoleConfigEntity.getAuthentication().getGoogle(), consoleConfigEntity.getAuthentication().getOauth2(), consoleConfigEntity.getCors(), consoleConfigEntity.getReCaptcha(), consoleConfigEntity.getScheduler(), consoleConfigEntity.getAnalyticsPendo(), consoleConfigEntity.getLogging(), consoleConfigEntity.getLogging().getAudit(), consoleConfigEntity.getLogging().getAudit().getTrail(), consoleConfigEntity.getLogging().getUser(), consoleConfigEntity.getLogging().getMessageSampling(), consoleConfigEntity.getLogging().getMessageSampling().getCount(), consoleConfigEntity.getLogging().getMessageSampling().getProbabilistic(), consoleConfigEntity.getLogging().getMessageSampling().getTemporal(), consoleConfigEntity.getMaintenance(), consoleConfigEntity.getManagement(), consoleConfigEntity.getNewsletter(), consoleConfigEntity.getV4EmulationEngine(), consoleConfigEntity.getAlertEngine(), consoleConfigEntity.getLicenseExpirationNotification(), consoleConfigEntity.getTrialInstance()};
    }
}

