/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.infra.domain_service.documentation;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import io.gravitee.apim.core.documentation.domain_service.TemplateResolverDomainService;
import io.gravitee.apim.core.documentation.exception.InvalidPageContentException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

@Service
public class FreemarkerTemplateResolver
implements TemplateResolverDomainService {
    @Override
    public String resolveTemplate(String content, Map<String, Object> params) throws InvalidPageContentException {
        Configuration freemarkerConfiguration = this.initFreemarkerConfiguration();
        try {
            Template template = new Template("template", (Reader)new StringReader(content), freemarkerConfiguration);
            return FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, params);
        }
        catch (IOException e) {
            throw new InvalidPageContentException("Invalid template " + e.getMessage(), e);
        }
        catch (TemplateException e) {
            throw new InvalidPageContentException("Invalid expression " + e.getBlamedExpressionString(), e);
        }
    }

    private Configuration initFreemarkerConfiguration() {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_22);
        configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
        configuration.setTemplateLoader((TemplateLoader)new StringTemplateLoader());
        return configuration;
    }
}

