/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.apim.core.api.model;

import io.gravitee.apim.core.api.exception.InvalidPathsException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import lombok.Generated;

public class Path {
    private static final Pattern DUPLICATE_SLASH_REMOVER = Pattern.compile("[//]+");
    private static final Pattern VALID_PATH = Pattern.compile("^[/.a-zA-Z0-9-_]*$");
    private static final String URI_PATH_SEPARATOR = "/";
    private static final char URI_PATH_SEPARATOR_CHAR = '/';
    String host;
    String path;
    boolean overrideAccess;

    public boolean hasHost() {
        return this.host != null && !this.host.isEmpty();
    }

    public Path sanitize() {
        return this.withPath(Path.sanitizePath(this.getPath()));
    }

    public static String sanitizePath(String path) {
        Object sanitizedPath = path;
        if (sanitizedPath == null || ((String)sanitizedPath).isEmpty()) {
            sanitizedPath = URI_PATH_SEPARATOR;
        }
        if (!((String)sanitizedPath).startsWith(URI_PATH_SEPARATOR)) {
            sanitizedPath = URI_PATH_SEPARATOR + (String)sanitizedPath;
        }
        if (((String)sanitizedPath).lastIndexOf(47) != ((String)sanitizedPath).length() - 1) {
            sanitizedPath = (String)sanitizedPath + URI_PATH_SEPARATOR;
        }
        if ((sanitizedPath = DUPLICATE_SLASH_REMOVER.matcher((CharSequence)sanitizedPath).replaceAll(URI_PATH_SEPARATOR)) != null) {
            try {
                new URL("https", "localhost", 80, (String)sanitizedPath).toURI();
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new InvalidPathsException(e.getMessage());
            }
        }
        return sanitizedPath;
    }

    @Generated
    Path(String host, String path, boolean overrideAccess) {
        this.host = host;
        this.path = path;
        this.overrideAccess = overrideAccess;
    }

    @Generated
    public static PathBuilder builder() {
        return new PathBuilder();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public boolean isOverrideAccess() {
        return this.overrideAccess;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setOverrideAccess(boolean overrideAccess) {
        this.overrideAccess = overrideAccess;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path other = (Path)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isOverrideAccess() != other.isOverrideAccess()) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Path;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isOverrideAccess() ? 79 : 97);
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Path(host=" + this.getHost() + ", path=" + this.getPath() + ", overrideAccess=" + this.isOverrideAccess() + ")";
    }

    @Generated
    public Path withHost(String host) {
        return this.host == host ? this : new Path(host, this.path, this.overrideAccess);
    }

    @Generated
    public Path withPath(String path) {
        return this.path == path ? this : new Path(this.host, path, this.overrideAccess);
    }

    @Generated
    public Path withOverrideAccess(boolean overrideAccess) {
        return this.overrideAccess == overrideAccess ? this : new Path(this.host, this.path, overrideAccess);
    }

    @Generated
    public static class PathBuilder {
        @Generated
        private String host;
        @Generated
        private String path;
        @Generated
        private boolean overrideAccess;

        @Generated
        PathBuilder() {
        }

        @Generated
        public PathBuilder host(String host) {
            this.host = host;
            return this;
        }

        @Generated
        public PathBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public PathBuilder overrideAccess(boolean overrideAccess) {
            this.overrideAccess = overrideAccess;
            return this;
        }

        @Generated
        public Path build() {
            return new Path(this.host, this.path, this.overrideAccess);
        }

        @Generated
        public String toString() {
            return "Path.PathBuilder(host=" + this.host + ", path=" + this.path + ", overrideAccess=" + this.overrideAccess + ")";
        }
    }
}

